/*
 * Copyright (c) 1997 Massachusetts Institute of Technology
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to use, copy, modify, and distribute the Software without
 * restriction, provided the Software, including any modified copies made
 * under this license, is not distributed for a fee, subject to
 * the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE MASSACHUSETTS INSTITUTE OF TECHNOLOGY BE LIABLE
 * FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * Except as contained in this notice, the name of the Massachusetts
 * Institute of Technology shall not be used in advertising or otherwise
 * to promote the sale, use or other dealings in this Software without
 * prior written authorization from the Massachusetts Institute of
 * Technology.
 *  
 */

/* This file has been automatically generated --- DO NOT EDIT */

#include <fftw.h>
#include "konst.h"

/* Generated by $Id: genfft.ml,v 1.31 1997/08/27 20:46:08 fftw Exp $ */

/* This function contains 928 FP additions and 248 FP multiplications */

void fftwi_no_twiddle_64(const FFTW_COMPLEX *in, FFTW_COMPLEX *out, int istride, int ostride)
{
     FFTW_REAL tre0_0_0;
     FFTW_REAL tim0_0_0;
     FFTW_REAL tre0_0_1;
     FFTW_REAL tim0_0_1;
     FFTW_REAL tre0_0_2;
     FFTW_REAL tim0_0_2;
     FFTW_REAL tre0_0_3;
     FFTW_REAL tim0_0_3;
     FFTW_REAL tre0_0_4;
     FFTW_REAL tim0_0_4;
     FFTW_REAL tre0_0_5;
     FFTW_REAL tim0_0_5;
     FFTW_REAL tre0_0_6;
     FFTW_REAL tim0_0_6;
     FFTW_REAL tre0_0_7;
     FFTW_REAL tim0_0_7;
     FFTW_REAL tre0_1_0;
     FFTW_REAL tim0_1_0;
     FFTW_REAL tre0_1_1;
     FFTW_REAL tim0_1_1;
     FFTW_REAL tre0_1_2;
     FFTW_REAL tim0_1_2;
     FFTW_REAL tre0_1_3;
     FFTW_REAL tim0_1_3;
     FFTW_REAL tre0_1_4;
     FFTW_REAL tim0_1_4;
     FFTW_REAL tre0_1_5;
     FFTW_REAL tim0_1_5;
     FFTW_REAL tre0_1_6;
     FFTW_REAL tim0_1_6;
     FFTW_REAL tre0_1_7;
     FFTW_REAL tim0_1_7;
     FFTW_REAL tre0_2_0;
     FFTW_REAL tim0_2_0;
     FFTW_REAL tre0_2_1;
     FFTW_REAL tim0_2_1;
     FFTW_REAL tre0_2_2;
     FFTW_REAL tim0_2_2;
     FFTW_REAL tre0_2_3;
     FFTW_REAL tim0_2_3;
     FFTW_REAL tre0_2_4;
     FFTW_REAL tim0_2_4;
     FFTW_REAL tre0_2_5;
     FFTW_REAL tim0_2_5;
     FFTW_REAL tre0_2_6;
     FFTW_REAL tim0_2_6;
     FFTW_REAL tre0_2_7;
     FFTW_REAL tim0_2_7;
     FFTW_REAL tre0_3_0;
     FFTW_REAL tim0_3_0;
     FFTW_REAL tre0_3_1;
     FFTW_REAL tim0_3_1;
     FFTW_REAL tre0_3_2;
     FFTW_REAL tim0_3_2;
     FFTW_REAL tre0_3_3;
     FFTW_REAL tim0_3_3;
     FFTW_REAL tre0_3_4;
     FFTW_REAL tim0_3_4;
     FFTW_REAL tre0_3_5;
     FFTW_REAL tim0_3_5;
     FFTW_REAL tre0_3_6;
     FFTW_REAL tim0_3_6;
     FFTW_REAL tre0_3_7;
     FFTW_REAL tim0_3_7;
     FFTW_REAL tre0_4_0;
     FFTW_REAL tim0_4_0;
     FFTW_REAL tre0_4_1;
     FFTW_REAL tim0_4_1;
     FFTW_REAL tre0_4_2;
     FFTW_REAL tim0_4_2;
     FFTW_REAL tre0_4_3;
     FFTW_REAL tim0_4_3;
     FFTW_REAL tre0_4_4;
     FFTW_REAL tim0_4_4;
     FFTW_REAL tre0_4_5;
     FFTW_REAL tim0_4_5;
     FFTW_REAL tre0_4_6;
     FFTW_REAL tim0_4_6;
     FFTW_REAL tre0_4_7;
     FFTW_REAL tim0_4_7;
     FFTW_REAL tre0_5_0;
     FFTW_REAL tim0_5_0;
     FFTW_REAL tre0_5_1;
     FFTW_REAL tim0_5_1;
     FFTW_REAL tre0_5_2;
     FFTW_REAL tim0_5_2;
     FFTW_REAL tre0_5_3;
     FFTW_REAL tim0_5_3;
     FFTW_REAL tre0_5_4;
     FFTW_REAL tim0_5_4;
     FFTW_REAL tre0_5_5;
     FFTW_REAL tim0_5_5;
     FFTW_REAL tre0_5_6;
     FFTW_REAL tim0_5_6;
     FFTW_REAL tre0_5_7;
     FFTW_REAL tim0_5_7;
     FFTW_REAL tre0_6_0;
     FFTW_REAL tim0_6_0;
     FFTW_REAL tre0_6_1;
     FFTW_REAL tim0_6_1;
     FFTW_REAL tre0_6_2;
     FFTW_REAL tim0_6_2;
     FFTW_REAL tre0_6_3;
     FFTW_REAL tim0_6_3;
     FFTW_REAL tre0_6_4;
     FFTW_REAL tim0_6_4;
     FFTW_REAL tre0_6_5;
     FFTW_REAL tim0_6_5;
     FFTW_REAL tre0_6_6;
     FFTW_REAL tim0_6_6;
     FFTW_REAL tre0_6_7;
     FFTW_REAL tim0_6_7;
     FFTW_REAL tre0_7_0;
     FFTW_REAL tim0_7_0;
     FFTW_REAL tre0_7_1;
     FFTW_REAL tim0_7_1;
     FFTW_REAL tre0_7_2;
     FFTW_REAL tim0_7_2;
     FFTW_REAL tre0_7_3;
     FFTW_REAL tim0_7_3;
     FFTW_REAL tre0_7_4;
     FFTW_REAL tim0_7_4;
     FFTW_REAL tre0_7_5;
     FFTW_REAL tim0_7_5;
     FFTW_REAL tre0_7_6;
     FFTW_REAL tim0_7_6;
     FFTW_REAL tre0_7_7;
     FFTW_REAL tim0_7_7;
     {
	  FFTW_REAL tre1_0_0;
	  FFTW_REAL tim1_0_0;
	  FFTW_REAL tre1_0_1;
	  FFTW_REAL tim1_0_1;
	  FFTW_REAL tre1_0_2;
	  FFTW_REAL tim1_0_2;
	  FFTW_REAL tre1_0_3;
	  FFTW_REAL tim1_0_3;
	  FFTW_REAL tre1_1_0;
	  FFTW_REAL tim1_1_0;
	  FFTW_REAL tre1_1_1;
	  FFTW_REAL tim1_1_1;
	  FFTW_REAL tre1_1_2;
	  FFTW_REAL tim1_1_2;
	  FFTW_REAL tre1_1_3;
	  FFTW_REAL tim1_1_3;
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = c_re(in[0]);
	       tim2_0_0 = c_im(in[0]);
	       tre2_1_0 = c_re(in[32 * istride]);
	       tim2_1_0 = c_im(in[32 * istride]);
	       tre1_0_0 = tre2_0_0 + tre2_1_0;
	       tim1_0_0 = tim2_0_0 + tim2_1_0;
	       tre1_1_0 = tre2_0_0 - tre2_1_0;
	       tim1_1_0 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = c_re(in[8 * istride]);
	       tim2_0_0 = c_im(in[8 * istride]);
	       tre2_1_0 = c_re(in[40 * istride]);
	       tim2_1_0 = c_im(in[40 * istride]);
	       tre1_0_1 = tre2_0_0 + tre2_1_0;
	       tim1_0_1 = tim2_0_0 + tim2_1_0;
	       tre1_1_1 = tre2_0_0 - tre2_1_0;
	       tim1_1_1 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = c_re(in[16 * istride]);
	       tim2_0_0 = c_im(in[16 * istride]);
	       tre2_1_0 = c_re(in[48 * istride]);
	       tim2_1_0 = c_im(in[48 * istride]);
	       tre1_0_2 = tre2_0_0 + tre2_1_0;
	       tim1_0_2 = tim2_0_0 + tim2_1_0;
	       tre1_1_2 = tre2_0_0 - tre2_1_0;
	       tim1_1_2 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = c_re(in[24 * istride]);
	       tim2_0_0 = c_im(in[24 * istride]);
	       tre2_1_0 = c_re(in[56 * istride]);
	       tim2_1_0 = c_im(in[56 * istride]);
	       tre1_0_3 = tre2_0_0 + tre2_1_0;
	       tim1_0_3 = tim2_0_0 + tim2_1_0;
	       tre1_1_3 = tre2_0_0 - tre2_1_0;
	       tim1_1_3 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_0_1;
	       FFTW_REAL tim2_0_1;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       FFTW_REAL tre2_1_1;
	       FFTW_REAL tim2_1_1;
	       tre2_0_0 = tre1_0_0 + tre1_0_2;
	       tim2_0_0 = tim1_0_0 + tim1_0_2;
	       tre2_1_0 = tre1_0_0 - tre1_0_2;
	       tim2_1_0 = tim1_0_0 - tim1_0_2;
	       tre2_0_1 = tre1_0_1 + tre1_0_3;
	       tim2_0_1 = tim1_0_1 + tim1_0_3;
	       tre2_1_1 = tre1_0_1 - tre1_0_3;
	       tim2_1_1 = tim1_0_1 - tim1_0_3;
	       tre0_0_0 = tre2_0_0 + tre2_0_1;
	       tim0_0_0 = tim2_0_0 + tim2_0_1;
	       tre0_4_0 = tre2_0_0 - tre2_0_1;
	       tim0_4_0 = tim2_0_0 - tim2_0_1;
	       tre0_2_0 = tre2_1_0 - tim2_1_1;
	       tim0_2_0 = tim2_1_0 + tre2_1_1;
	       tre0_6_0 = tre2_1_0 + tim2_1_1;
	       tim0_6_0 = tim2_1_0 - tre2_1_1;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_0_1;
	       FFTW_REAL tim2_0_1;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       FFTW_REAL tre2_1_1;
	       FFTW_REAL tim2_1_1;
	       tre2_0_0 = tre1_1_0 - tim1_1_2;
	       tim2_0_0 = tim1_1_0 + tre1_1_2;
	       tre2_1_0 = tre1_1_0 + tim1_1_2;
	       tim2_1_0 = tim1_1_0 - tre1_1_2;
	       {
		    FFTW_REAL tre3_0_0;
		    FFTW_REAL tim3_0_0;
		    FFTW_REAL tre3_1_0;
		    FFTW_REAL tim3_1_0;
		    tre3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_1 - tim1_1_1);
		    tim3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tim1_1_1 + tre1_1_1);
		    tre3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 + tim1_1_3);
		    tim3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 - tim1_1_3);
		    tre2_0_1 = tre3_0_0 - tre3_1_0;
		    tim2_0_1 = tim3_0_0 + tim3_1_0;
		    tre2_1_1 = tre3_0_0 + tre3_1_0;
		    tim2_1_1 = tim3_0_0 - tim3_1_0;
	       }
	       tre0_1_0 = tre2_0_0 + tre2_0_1;
	       tim0_1_0 = tim2_0_0 + tim2_0_1;
	       tre0_5_0 = tre2_0_0 - tre2_0_1;
	       tim0_5_0 = tim2_0_0 - tim2_0_1;
	       tre0_3_0 = tre2_1_0 - tim2_1_1;
	       tim0_3_0 = tim2_1_0 + tre2_1_1;
	       tre0_7_0 = tre2_1_0 + tim2_1_1;
	       tim0_7_0 = tim2_1_0 - tre2_1_1;
	  }
     }
     {
	  FFTW_REAL tre1_0_0;
	  FFTW_REAL tim1_0_0;
	  FFTW_REAL tre1_0_1;
	  FFTW_REAL tim1_0_1;
	  FFTW_REAL tre1_0_2;
	  FFTW_REAL tim1_0_2;
	  FFTW_REAL tre1_0_3;
	  FFTW_REAL tim1_0_3;
	  FFTW_REAL tre1_1_0;
	  FFTW_REAL tim1_1_0;
	  FFTW_REAL tre1_1_1;
	  FFTW_REAL tim1_1_1;
	  FFTW_REAL tre1_1_2;
	  FFTW_REAL tim1_1_2;
	  FFTW_REAL tre1_1_3;
	  FFTW_REAL tim1_1_3;
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = c_re(in[istride]);
	       tim2_0_0 = c_im(in[istride]);
	       tre2_1_0 = c_re(in[33 * istride]);
	       tim2_1_0 = c_im(in[33 * istride]);
	       tre1_0_0 = tre2_0_0 + tre2_1_0;
	       tim1_0_0 = tim2_0_0 + tim2_1_0;
	       tre1_1_0 = tre2_0_0 - tre2_1_0;
	       tim1_1_0 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = c_re(in[9 * istride]);
	       tim2_0_0 = c_im(in[9 * istride]);
	       tre2_1_0 = c_re(in[41 * istride]);
	       tim2_1_0 = c_im(in[41 * istride]);
	       tre1_0_1 = tre2_0_0 + tre2_1_0;
	       tim1_0_1 = tim2_0_0 + tim2_1_0;
	       tre1_1_1 = tre2_0_0 - tre2_1_0;
	       tim1_1_1 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = c_re(in[17 * istride]);
	       tim2_0_0 = c_im(in[17 * istride]);
	       tre2_1_0 = c_re(in[49 * istride]);
	       tim2_1_0 = c_im(in[49 * istride]);
	       tre1_0_2 = tre2_0_0 + tre2_1_0;
	       tim1_0_2 = tim2_0_0 + tim2_1_0;
	       tre1_1_2 = tre2_0_0 - tre2_1_0;
	       tim1_1_2 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = c_re(in[25 * istride]);
	       tim2_0_0 = c_im(in[25 * istride]);
	       tre2_1_0 = c_re(in[57 * istride]);
	       tim2_1_0 = c_im(in[57 * istride]);
	       tre1_0_3 = tre2_0_0 + tre2_1_0;
	       tim1_0_3 = tim2_0_0 + tim2_1_0;
	       tre1_1_3 = tre2_0_0 - tre2_1_0;
	       tim1_1_3 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_0_1;
	       FFTW_REAL tim2_0_1;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       FFTW_REAL tre2_1_1;
	       FFTW_REAL tim2_1_1;
	       tre2_0_0 = tre1_0_0 + tre1_0_2;
	       tim2_0_0 = tim1_0_0 + tim1_0_2;
	       tre2_1_0 = tre1_0_0 - tre1_0_2;
	       tim2_1_0 = tim1_0_0 - tim1_0_2;
	       tre2_0_1 = tre1_0_1 + tre1_0_3;
	       tim2_0_1 = tim1_0_1 + tim1_0_3;
	       tre2_1_1 = tre1_0_1 - tre1_0_3;
	       tim2_1_1 = tim1_0_1 - tim1_0_3;
	       tre0_0_1 = tre2_0_0 + tre2_0_1;
	       tim0_0_1 = tim2_0_0 + tim2_0_1;
	       tre0_4_1 = tre2_0_0 - tre2_0_1;
	       tim0_4_1 = tim2_0_0 - tim2_0_1;
	       tre0_2_1 = tre2_1_0 - tim2_1_1;
	       tim0_2_1 = tim2_1_0 + tre2_1_1;
	       tre0_6_1 = tre2_1_0 + tim2_1_1;
	       tim0_6_1 = tim2_1_0 - tre2_1_1;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_0_1;
	       FFTW_REAL tim2_0_1;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       FFTW_REAL tre2_1_1;
	       FFTW_REAL tim2_1_1;
	       tre2_0_0 = tre1_1_0 - tim1_1_2;
	       tim2_0_0 = tim1_1_0 + tre1_1_2;
	       tre2_1_0 = tre1_1_0 + tim1_1_2;
	       tim2_1_0 = tim1_1_0 - tre1_1_2;
	       {
		    FFTW_REAL tre3_0_0;
		    FFTW_REAL tim3_0_0;
		    FFTW_REAL tre3_1_0;
		    FFTW_REAL tim3_1_0;
		    tre3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_1 - tim1_1_1);
		    tim3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tim1_1_1 + tre1_1_1);
		    tre3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 + tim1_1_3);
		    tim3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 - tim1_1_3);
		    tre2_0_1 = tre3_0_0 - tre3_1_0;
		    tim2_0_1 = tim3_0_0 + tim3_1_0;
		    tre2_1_1 = tre3_0_0 + tre3_1_0;
		    tim2_1_1 = tim3_0_0 - tim3_1_0;
	       }
	       tre0_1_1 = tre2_0_0 + tre2_0_1;
	       tim0_1_1 = tim2_0_0 + tim2_0_1;
	       tre0_5_1 = tre2_0_0 - tre2_0_1;
	       tim0_5_1 = tim2_0_0 - tim2_0_1;
	       tre0_3_1 = tre2_1_0 - tim2_1_1;
	       tim0_3_1 = tim2_1_0 + tre2_1_1;
	       tre0_7_1 = tre2_1_0 + tim2_1_1;
	       tim0_7_1 = tim2_1_0 - tre2_1_1;
	  }
     }
     {
	  FFTW_REAL tre1_0_0;
	  FFTW_REAL tim1_0_0;
	  FFTW_REAL tre1_0_1;
	  FFTW_REAL tim1_0_1;
	  FFTW_REAL tre1_0_2;
	  FFTW_REAL tim1_0_2;
	  FFTW_REAL tre1_0_3;
	  FFTW_REAL tim1_0_3;
	  FFTW_REAL tre1_1_0;
	  FFTW_REAL tim1_1_0;
	  FFTW_REAL tre1_1_1;
	  FFTW_REAL tim1_1_1;
	  FFTW_REAL tre1_1_2;
	  FFTW_REAL tim1_1_2;
	  FFTW_REAL tre1_1_3;
	  FFTW_REAL tim1_1_3;
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = c_re(in[2 * istride]);
	       tim2_0_0 = c_im(in[2 * istride]);
	       tre2_1_0 = c_re(in[34 * istride]);
	       tim2_1_0 = c_im(in[34 * istride]);
	       tre1_0_0 = tre2_0_0 + tre2_1_0;
	       tim1_0_0 = tim2_0_0 + tim2_1_0;
	       tre1_1_0 = tre2_0_0 - tre2_1_0;
	       tim1_1_0 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = c_re(in[10 * istride]);
	       tim2_0_0 = c_im(in[10 * istride]);
	       tre2_1_0 = c_re(in[42 * istride]);
	       tim2_1_0 = c_im(in[42 * istride]);
	       tre1_0_1 = tre2_0_0 + tre2_1_0;
	       tim1_0_1 = tim2_0_0 + tim2_1_0;
	       tre1_1_1 = tre2_0_0 - tre2_1_0;
	       tim1_1_1 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = c_re(in[18 * istride]);
	       tim2_0_0 = c_im(in[18 * istride]);
	       tre2_1_0 = c_re(in[50 * istride]);
	       tim2_1_0 = c_im(in[50 * istride]);
	       tre1_0_2 = tre2_0_0 + tre2_1_0;
	       tim1_0_2 = tim2_0_0 + tim2_1_0;
	       tre1_1_2 = tre2_0_0 - tre2_1_0;
	       tim1_1_2 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = c_re(in[26 * istride]);
	       tim2_0_0 = c_im(in[26 * istride]);
	       tre2_1_0 = c_re(in[58 * istride]);
	       tim2_1_0 = c_im(in[58 * istride]);
	       tre1_0_3 = tre2_0_0 + tre2_1_0;
	       tim1_0_3 = tim2_0_0 + tim2_1_0;
	       tre1_1_3 = tre2_0_0 - tre2_1_0;
	       tim1_1_3 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_0_1;
	       FFTW_REAL tim2_0_1;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       FFTW_REAL tre2_1_1;
	       FFTW_REAL tim2_1_1;
	       tre2_0_0 = tre1_0_0 + tre1_0_2;
	       tim2_0_0 = tim1_0_0 + tim1_0_2;
	       tre2_1_0 = tre1_0_0 - tre1_0_2;
	       tim2_1_0 = tim1_0_0 - tim1_0_2;
	       tre2_0_1 = tre1_0_1 + tre1_0_3;
	       tim2_0_1 = tim1_0_1 + tim1_0_3;
	       tre2_1_1 = tre1_0_1 - tre1_0_3;
	       tim2_1_1 = tim1_0_1 - tim1_0_3;
	       tre0_0_2 = tre2_0_0 + tre2_0_1;
	       tim0_0_2 = tim2_0_0 + tim2_0_1;
	       tre0_4_2 = tre2_0_0 - tre2_0_1;
	       tim0_4_2 = tim2_0_0 - tim2_0_1;
	       tre0_2_2 = tre2_1_0 - tim2_1_1;
	       tim0_2_2 = tim2_1_0 + tre2_1_1;
	       tre0_6_2 = tre2_1_0 + tim2_1_1;
	       tim0_6_2 = tim2_1_0 - tre2_1_1;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_0_1;
	       FFTW_REAL tim2_0_1;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       FFTW_REAL tre2_1_1;
	       FFTW_REAL tim2_1_1;
	       tre2_0_0 = tre1_1_0 - tim1_1_2;
	       tim2_0_0 = tim1_1_0 + tre1_1_2;
	       tre2_1_0 = tre1_1_0 + tim1_1_2;
	       tim2_1_0 = tim1_1_0 - tre1_1_2;
	       {
		    FFTW_REAL tre3_0_0;
		    FFTW_REAL tim3_0_0;
		    FFTW_REAL tre3_1_0;
		    FFTW_REAL tim3_1_0;
		    tre3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_1 - tim1_1_1);
		    tim3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tim1_1_1 + tre1_1_1);
		    tre3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 + tim1_1_3);
		    tim3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 - tim1_1_3);
		    tre2_0_1 = tre3_0_0 - tre3_1_0;
		    tim2_0_1 = tim3_0_0 + tim3_1_0;
		    tre2_1_1 = tre3_0_0 + tre3_1_0;
		    tim2_1_1 = tim3_0_0 - tim3_1_0;
	       }
	       tre0_1_2 = tre2_0_0 + tre2_0_1;
	       tim0_1_2 = tim2_0_0 + tim2_0_1;
	       tre0_5_2 = tre2_0_0 - tre2_0_1;
	       tim0_5_2 = tim2_0_0 - tim2_0_1;
	       tre0_3_2 = tre2_1_0 - tim2_1_1;
	       tim0_3_2 = tim2_1_0 + tre2_1_1;
	       tre0_7_2 = tre2_1_0 + tim2_1_1;
	       tim0_7_2 = tim2_1_0 - tre2_1_1;
	  }
     }
     {
	  FFTW_REAL tre1_0_0;
	  FFTW_REAL tim1_0_0;
	  FFTW_REAL tre1_0_1;
	  FFTW_REAL tim1_0_1;
	  FFTW_REAL tre1_0_2;
	  FFTW_REAL tim1_0_2;
	  FFTW_REAL tre1_0_3;
	  FFTW_REAL tim1_0_3;
	  FFTW_REAL tre1_1_0;
	  FFTW_REAL tim1_1_0;
	  FFTW_REAL tre1_1_1;
	  FFTW_REAL tim1_1_1;
	  FFTW_REAL tre1_1_2;
	  FFTW_REAL tim1_1_2;
	  FFTW_REAL tre1_1_3;
	  FFTW_REAL tim1_1_3;
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = c_re(in[3 * istride]);
	       tim2_0_0 = c_im(in[3 * istride]);
	       tre2_1_0 = c_re(in[35 * istride]);
	       tim2_1_0 = c_im(in[35 * istride]);
	       tre1_0_0 = tre2_0_0 + tre2_1_0;
	       tim1_0_0 = tim2_0_0 + tim2_1_0;
	       tre1_1_0 = tre2_0_0 - tre2_1_0;
	       tim1_1_0 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = c_re(in[11 * istride]);
	       tim2_0_0 = c_im(in[11 * istride]);
	       tre2_1_0 = c_re(in[43 * istride]);
	       tim2_1_0 = c_im(in[43 * istride]);
	       tre1_0_1 = tre2_0_0 + tre2_1_0;
	       tim1_0_1 = tim2_0_0 + tim2_1_0;
	       tre1_1_1 = tre2_0_0 - tre2_1_0;
	       tim1_1_1 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = c_re(in[19 * istride]);
	       tim2_0_0 = c_im(in[19 * istride]);
	       tre2_1_0 = c_re(in[51 * istride]);
	       tim2_1_0 = c_im(in[51 * istride]);
	       tre1_0_2 = tre2_0_0 + tre2_1_0;
	       tim1_0_2 = tim2_0_0 + tim2_1_0;
	       tre1_1_2 = tre2_0_0 - tre2_1_0;
	       tim1_1_2 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = c_re(in[27 * istride]);
	       tim2_0_0 = c_im(in[27 * istride]);
	       tre2_1_0 = c_re(in[59 * istride]);
	       tim2_1_0 = c_im(in[59 * istride]);
	       tre1_0_3 = tre2_0_0 + tre2_1_0;
	       tim1_0_3 = tim2_0_0 + tim2_1_0;
	       tre1_1_3 = tre2_0_0 - tre2_1_0;
	       tim1_1_3 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_0_1;
	       FFTW_REAL tim2_0_1;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       FFTW_REAL tre2_1_1;
	       FFTW_REAL tim2_1_1;
	       tre2_0_0 = tre1_0_0 + tre1_0_2;
	       tim2_0_0 = tim1_0_0 + tim1_0_2;
	       tre2_1_0 = tre1_0_0 - tre1_0_2;
	       tim2_1_0 = tim1_0_0 - tim1_0_2;
	       tre2_0_1 = tre1_0_1 + tre1_0_3;
	       tim2_0_1 = tim1_0_1 + tim1_0_3;
	       tre2_1_1 = tre1_0_1 - tre1_0_3;
	       tim2_1_1 = tim1_0_1 - tim1_0_3;
	       tre0_0_3 = tre2_0_0 + tre2_0_1;
	       tim0_0_3 = tim2_0_0 + tim2_0_1;
	       tre0_4_3 = tre2_0_0 - tre2_0_1;
	       tim0_4_3 = tim2_0_0 - tim2_0_1;
	       tre0_2_3 = tre2_1_0 - tim2_1_1;
	       tim0_2_3 = tim2_1_0 + tre2_1_1;
	       tre0_6_3 = tre2_1_0 + tim2_1_1;
	       tim0_6_3 = tim2_1_0 - tre2_1_1;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_0_1;
	       FFTW_REAL tim2_0_1;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       FFTW_REAL tre2_1_1;
	       FFTW_REAL tim2_1_1;
	       tre2_0_0 = tre1_1_0 - tim1_1_2;
	       tim2_0_0 = tim1_1_0 + tre1_1_2;
	       tre2_1_0 = tre1_1_0 + tim1_1_2;
	       tim2_1_0 = tim1_1_0 - tre1_1_2;
	       {
		    FFTW_REAL tre3_0_0;
		    FFTW_REAL tim3_0_0;
		    FFTW_REAL tre3_1_0;
		    FFTW_REAL tim3_1_0;
		    tre3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_1 - tim1_1_1);
		    tim3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tim1_1_1 + tre1_1_1);
		    tre3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 + tim1_1_3);
		    tim3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 - tim1_1_3);
		    tre2_0_1 = tre3_0_0 - tre3_1_0;
		    tim2_0_1 = tim3_0_0 + tim3_1_0;
		    tre2_1_1 = tre3_0_0 + tre3_1_0;
		    tim2_1_1 = tim3_0_0 - tim3_1_0;
	       }
	       tre0_1_3 = tre2_0_0 + tre2_0_1;
	       tim0_1_3 = tim2_0_0 + tim2_0_1;
	       tre0_5_3 = tre2_0_0 - tre2_0_1;
	       tim0_5_3 = tim2_0_0 - tim2_0_1;
	       tre0_3_3 = tre2_1_0 - tim2_1_1;
	       tim0_3_3 = tim2_1_0 + tre2_1_1;
	       tre0_7_3 = tre2_1_0 + tim2_1_1;
	       tim0_7_3 = tim2_1_0 - tre2_1_1;
	  }
     }
     {
	  FFTW_REAL tre1_0_0;
	  FFTW_REAL tim1_0_0;
	  FFTW_REAL tre1_0_1;
	  FFTW_REAL tim1_0_1;
	  FFTW_REAL tre1_0_2;
	  FFTW_REAL tim1_0_2;
	  FFTW_REAL tre1_0_3;
	  FFTW_REAL tim1_0_3;
	  FFTW_REAL tre1_1_0;
	  FFTW_REAL tim1_1_0;
	  FFTW_REAL tre1_1_1;
	  FFTW_REAL tim1_1_1;
	  FFTW_REAL tre1_1_2;
	  FFTW_REAL tim1_1_2;
	  FFTW_REAL tre1_1_3;
	  FFTW_REAL tim1_1_3;
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = c_re(in[4 * istride]);
	       tim2_0_0 = c_im(in[4 * istride]);
	       tre2_1_0 = c_re(in[36 * istride]);
	       tim2_1_0 = c_im(in[36 * istride]);
	       tre1_0_0 = tre2_0_0 + tre2_1_0;
	       tim1_0_0 = tim2_0_0 + tim2_1_0;
	       tre1_1_0 = tre2_0_0 - tre2_1_0;
	       tim1_1_0 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = c_re(in[12 * istride]);
	       tim2_0_0 = c_im(in[12 * istride]);
	       tre2_1_0 = c_re(in[44 * istride]);
	       tim2_1_0 = c_im(in[44 * istride]);
	       tre1_0_1 = tre2_0_0 + tre2_1_0;
	       tim1_0_1 = tim2_0_0 + tim2_1_0;
	       tre1_1_1 = tre2_0_0 - tre2_1_0;
	       tim1_1_1 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = c_re(in[20 * istride]);
	       tim2_0_0 = c_im(in[20 * istride]);
	       tre2_1_0 = c_re(in[52 * istride]);
	       tim2_1_0 = c_im(in[52 * istride]);
	       tre1_0_2 = tre2_0_0 + tre2_1_0;
	       tim1_0_2 = tim2_0_0 + tim2_1_0;
	       tre1_1_2 = tre2_0_0 - tre2_1_0;
	       tim1_1_2 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = c_re(in[28 * istride]);
	       tim2_0_0 = c_im(in[28 * istride]);
	       tre2_1_0 = c_re(in[60 * istride]);
	       tim2_1_0 = c_im(in[60 * istride]);
	       tre1_0_3 = tre2_0_0 + tre2_1_0;
	       tim1_0_3 = tim2_0_0 + tim2_1_0;
	       tre1_1_3 = tre2_0_0 - tre2_1_0;
	       tim1_1_3 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_0_1;
	       FFTW_REAL tim2_0_1;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       FFTW_REAL tre2_1_1;
	       FFTW_REAL tim2_1_1;
	       tre2_0_0 = tre1_0_0 + tre1_0_2;
	       tim2_0_0 = tim1_0_0 + tim1_0_2;
	       tre2_1_0 = tre1_0_0 - tre1_0_2;
	       tim2_1_0 = tim1_0_0 - tim1_0_2;
	       tre2_0_1 = tre1_0_1 + tre1_0_3;
	       tim2_0_1 = tim1_0_1 + tim1_0_3;
	       tre2_1_1 = tre1_0_1 - tre1_0_3;
	       tim2_1_1 = tim1_0_1 - tim1_0_3;
	       tre0_0_4 = tre2_0_0 + tre2_0_1;
	       tim0_0_4 = tim2_0_0 + tim2_0_1;
	       tre0_4_4 = tre2_0_0 - tre2_0_1;
	       tim0_4_4 = tim2_0_0 - tim2_0_1;
	       tre0_2_4 = tre2_1_0 - tim2_1_1;
	       tim0_2_4 = tim2_1_0 + tre2_1_1;
	       tre0_6_4 = tre2_1_0 + tim2_1_1;
	       tim0_6_4 = tim2_1_0 - tre2_1_1;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_0_1;
	       FFTW_REAL tim2_0_1;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       FFTW_REAL tre2_1_1;
	       FFTW_REAL tim2_1_1;
	       tre2_0_0 = tre1_1_0 - tim1_1_2;
	       tim2_0_0 = tim1_1_0 + tre1_1_2;
	       tre2_1_0 = tre1_1_0 + tim1_1_2;
	       tim2_1_0 = tim1_1_0 - tre1_1_2;
	       {
		    FFTW_REAL tre3_0_0;
		    FFTW_REAL tim3_0_0;
		    FFTW_REAL tre3_1_0;
		    FFTW_REAL tim3_1_0;
		    tre3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_1 - tim1_1_1);
		    tim3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tim1_1_1 + tre1_1_1);
		    tre3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 + tim1_1_3);
		    tim3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 - tim1_1_3);
		    tre2_0_1 = tre3_0_0 - tre3_1_0;
		    tim2_0_1 = tim3_0_0 + tim3_1_0;
		    tre2_1_1 = tre3_0_0 + tre3_1_0;
		    tim2_1_1 = tim3_0_0 - tim3_1_0;
	       }
	       tre0_1_4 = tre2_0_0 + tre2_0_1;
	       tim0_1_4 = tim2_0_0 + tim2_0_1;
	       tre0_5_4 = tre2_0_0 - tre2_0_1;
	       tim0_5_4 = tim2_0_0 - tim2_0_1;
	       tre0_3_4 = tre2_1_0 - tim2_1_1;
	       tim0_3_4 = tim2_1_0 + tre2_1_1;
	       tre0_7_4 = tre2_1_0 + tim2_1_1;
	       tim0_7_4 = tim2_1_0 - tre2_1_1;
	  }
     }
     {
	  FFTW_REAL tre1_0_0;
	  FFTW_REAL tim1_0_0;
	  FFTW_REAL tre1_0_1;
	  FFTW_REAL tim1_0_1;
	  FFTW_REAL tre1_0_2;
	  FFTW_REAL tim1_0_2;
	  FFTW_REAL tre1_0_3;
	  FFTW_REAL tim1_0_3;
	  FFTW_REAL tre1_1_0;
	  FFTW_REAL tim1_1_0;
	  FFTW_REAL tre1_1_1;
	  FFTW_REAL tim1_1_1;
	  FFTW_REAL tre1_1_2;
	  FFTW_REAL tim1_1_2;
	  FFTW_REAL tre1_1_3;
	  FFTW_REAL tim1_1_3;
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = c_re(in[5 * istride]);
	       tim2_0_0 = c_im(in[5 * istride]);
	       tre2_1_0 = c_re(in[37 * istride]);
	       tim2_1_0 = c_im(in[37 * istride]);
	       tre1_0_0 = tre2_0_0 + tre2_1_0;
	       tim1_0_0 = tim2_0_0 + tim2_1_0;
	       tre1_1_0 = tre2_0_0 - tre2_1_0;
	       tim1_1_0 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = c_re(in[13 * istride]);
	       tim2_0_0 = c_im(in[13 * istride]);
	       tre2_1_0 = c_re(in[45 * istride]);
	       tim2_1_0 = c_im(in[45 * istride]);
	       tre1_0_1 = tre2_0_0 + tre2_1_0;
	       tim1_0_1 = tim2_0_0 + tim2_1_0;
	       tre1_1_1 = tre2_0_0 - tre2_1_0;
	       tim1_1_1 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = c_re(in[21 * istride]);
	       tim2_0_0 = c_im(in[21 * istride]);
	       tre2_1_0 = c_re(in[53 * istride]);
	       tim2_1_0 = c_im(in[53 * istride]);
	       tre1_0_2 = tre2_0_0 + tre2_1_0;
	       tim1_0_2 = tim2_0_0 + tim2_1_0;
	       tre1_1_2 = tre2_0_0 - tre2_1_0;
	       tim1_1_2 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = c_re(in[29 * istride]);
	       tim2_0_0 = c_im(in[29 * istride]);
	       tre2_1_0 = c_re(in[61 * istride]);
	       tim2_1_0 = c_im(in[61 * istride]);
	       tre1_0_3 = tre2_0_0 + tre2_1_0;
	       tim1_0_3 = tim2_0_0 + tim2_1_0;
	       tre1_1_3 = tre2_0_0 - tre2_1_0;
	       tim1_1_3 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_0_1;
	       FFTW_REAL tim2_0_1;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       FFTW_REAL tre2_1_1;
	       FFTW_REAL tim2_1_1;
	       tre2_0_0 = tre1_0_0 + tre1_0_2;
	       tim2_0_0 = tim1_0_0 + tim1_0_2;
	       tre2_1_0 = tre1_0_0 - tre1_0_2;
	       tim2_1_0 = tim1_0_0 - tim1_0_2;
	       tre2_0_1 = tre1_0_1 + tre1_0_3;
	       tim2_0_1 = tim1_0_1 + tim1_0_3;
	       tre2_1_1 = tre1_0_1 - tre1_0_3;
	       tim2_1_1 = tim1_0_1 - tim1_0_3;
	       tre0_0_5 = tre2_0_0 + tre2_0_1;
	       tim0_0_5 = tim2_0_0 + tim2_0_1;
	       tre0_4_5 = tre2_0_0 - tre2_0_1;
	       tim0_4_5 = tim2_0_0 - tim2_0_1;
	       tre0_2_5 = tre2_1_0 - tim2_1_1;
	       tim0_2_5 = tim2_1_0 + tre2_1_1;
	       tre0_6_5 = tre2_1_0 + tim2_1_1;
	       tim0_6_5 = tim2_1_0 - tre2_1_1;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_0_1;
	       FFTW_REAL tim2_0_1;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       FFTW_REAL tre2_1_1;
	       FFTW_REAL tim2_1_1;
	       tre2_0_0 = tre1_1_0 - tim1_1_2;
	       tim2_0_0 = tim1_1_0 + tre1_1_2;
	       tre2_1_0 = tre1_1_0 + tim1_1_2;
	       tim2_1_0 = tim1_1_0 - tre1_1_2;
	       {
		    FFTW_REAL tre3_0_0;
		    FFTW_REAL tim3_0_0;
		    FFTW_REAL tre3_1_0;
		    FFTW_REAL tim3_1_0;
		    tre3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_1 - tim1_1_1);
		    tim3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tim1_1_1 + tre1_1_1);
		    tre3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 + tim1_1_3);
		    tim3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 - tim1_1_3);
		    tre2_0_1 = tre3_0_0 - tre3_1_0;
		    tim2_0_1 = tim3_0_0 + tim3_1_0;
		    tre2_1_1 = tre3_0_0 + tre3_1_0;
		    tim2_1_1 = tim3_0_0 - tim3_1_0;
	       }
	       tre0_1_5 = tre2_0_0 + tre2_0_1;
	       tim0_1_5 = tim2_0_0 + tim2_0_1;
	       tre0_5_5 = tre2_0_0 - tre2_0_1;
	       tim0_5_5 = tim2_0_0 - tim2_0_1;
	       tre0_3_5 = tre2_1_0 - tim2_1_1;
	       tim0_3_5 = tim2_1_0 + tre2_1_1;
	       tre0_7_5 = tre2_1_0 + tim2_1_1;
	       tim0_7_5 = tim2_1_0 - tre2_1_1;
	  }
     }
     {
	  FFTW_REAL tre1_0_0;
	  FFTW_REAL tim1_0_0;
	  FFTW_REAL tre1_0_1;
	  FFTW_REAL tim1_0_1;
	  FFTW_REAL tre1_0_2;
	  FFTW_REAL tim1_0_2;
	  FFTW_REAL tre1_0_3;
	  FFTW_REAL tim1_0_3;
	  FFTW_REAL tre1_1_0;
	  FFTW_REAL tim1_1_0;
	  FFTW_REAL tre1_1_1;
	  FFTW_REAL tim1_1_1;
	  FFTW_REAL tre1_1_2;
	  FFTW_REAL tim1_1_2;
	  FFTW_REAL tre1_1_3;
	  FFTW_REAL tim1_1_3;
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = c_re(in[6 * istride]);
	       tim2_0_0 = c_im(in[6 * istride]);
	       tre2_1_0 = c_re(in[38 * istride]);
	       tim2_1_0 = c_im(in[38 * istride]);
	       tre1_0_0 = tre2_0_0 + tre2_1_0;
	       tim1_0_0 = tim2_0_0 + tim2_1_0;
	       tre1_1_0 = tre2_0_0 - tre2_1_0;
	       tim1_1_0 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = c_re(in[14 * istride]);
	       tim2_0_0 = c_im(in[14 * istride]);
	       tre2_1_0 = c_re(in[46 * istride]);
	       tim2_1_0 = c_im(in[46 * istride]);
	       tre1_0_1 = tre2_0_0 + tre2_1_0;
	       tim1_0_1 = tim2_0_0 + tim2_1_0;
	       tre1_1_1 = tre2_0_0 - tre2_1_0;
	       tim1_1_1 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = c_re(in[22 * istride]);
	       tim2_0_0 = c_im(in[22 * istride]);
	       tre2_1_0 = c_re(in[54 * istride]);
	       tim2_1_0 = c_im(in[54 * istride]);
	       tre1_0_2 = tre2_0_0 + tre2_1_0;
	       tim1_0_2 = tim2_0_0 + tim2_1_0;
	       tre1_1_2 = tre2_0_0 - tre2_1_0;
	       tim1_1_2 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = c_re(in[30 * istride]);
	       tim2_0_0 = c_im(in[30 * istride]);
	       tre2_1_0 = c_re(in[62 * istride]);
	       tim2_1_0 = c_im(in[62 * istride]);
	       tre1_0_3 = tre2_0_0 + tre2_1_0;
	       tim1_0_3 = tim2_0_0 + tim2_1_0;
	       tre1_1_3 = tre2_0_0 - tre2_1_0;
	       tim1_1_3 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_0_1;
	       FFTW_REAL tim2_0_1;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       FFTW_REAL tre2_1_1;
	       FFTW_REAL tim2_1_1;
	       tre2_0_0 = tre1_0_0 + tre1_0_2;
	       tim2_0_0 = tim1_0_0 + tim1_0_2;
	       tre2_1_0 = tre1_0_0 - tre1_0_2;
	       tim2_1_0 = tim1_0_0 - tim1_0_2;
	       tre2_0_1 = tre1_0_1 + tre1_0_3;
	       tim2_0_1 = tim1_0_1 + tim1_0_3;
	       tre2_1_1 = tre1_0_1 - tre1_0_3;
	       tim2_1_1 = tim1_0_1 - tim1_0_3;
	       tre0_0_6 = tre2_0_0 + tre2_0_1;
	       tim0_0_6 = tim2_0_0 + tim2_0_1;
	       tre0_4_6 = tre2_0_0 - tre2_0_1;
	       tim0_4_6 = tim2_0_0 - tim2_0_1;
	       tre0_2_6 = tre2_1_0 - tim2_1_1;
	       tim0_2_6 = tim2_1_0 + tre2_1_1;
	       tre0_6_6 = tre2_1_0 + tim2_1_1;
	       tim0_6_6 = tim2_1_0 - tre2_1_1;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_0_1;
	       FFTW_REAL tim2_0_1;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       FFTW_REAL tre2_1_1;
	       FFTW_REAL tim2_1_1;
	       tre2_0_0 = tre1_1_0 - tim1_1_2;
	       tim2_0_0 = tim1_1_0 + tre1_1_2;
	       tre2_1_0 = tre1_1_0 + tim1_1_2;
	       tim2_1_0 = tim1_1_0 - tre1_1_2;
	       {
		    FFTW_REAL tre3_0_0;
		    FFTW_REAL tim3_0_0;
		    FFTW_REAL tre3_1_0;
		    FFTW_REAL tim3_1_0;
		    tre3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_1 - tim1_1_1);
		    tim3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tim1_1_1 + tre1_1_1);
		    tre3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 + tim1_1_3);
		    tim3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 - tim1_1_3);
		    tre2_0_1 = tre3_0_0 - tre3_1_0;
		    tim2_0_1 = tim3_0_0 + tim3_1_0;
		    tre2_1_1 = tre3_0_0 + tre3_1_0;
		    tim2_1_1 = tim3_0_0 - tim3_1_0;
	       }
	       tre0_1_6 = tre2_0_0 + tre2_0_1;
	       tim0_1_6 = tim2_0_0 + tim2_0_1;
	       tre0_5_6 = tre2_0_0 - tre2_0_1;
	       tim0_5_6 = tim2_0_0 - tim2_0_1;
	       tre0_3_6 = tre2_1_0 - tim2_1_1;
	       tim0_3_6 = tim2_1_0 + tre2_1_1;
	       tre0_7_6 = tre2_1_0 + tim2_1_1;
	       tim0_7_6 = tim2_1_0 - tre2_1_1;
	  }
     }
     {
	  FFTW_REAL tre1_0_0;
	  FFTW_REAL tim1_0_0;
	  FFTW_REAL tre1_0_1;
	  FFTW_REAL tim1_0_1;
	  FFTW_REAL tre1_0_2;
	  FFTW_REAL tim1_0_2;
	  FFTW_REAL tre1_0_3;
	  FFTW_REAL tim1_0_3;
	  FFTW_REAL tre1_1_0;
	  FFTW_REAL tim1_1_0;
	  FFTW_REAL tre1_1_1;
	  FFTW_REAL tim1_1_1;
	  FFTW_REAL tre1_1_2;
	  FFTW_REAL tim1_1_2;
	  FFTW_REAL tre1_1_3;
	  FFTW_REAL tim1_1_3;
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = c_re(in[7 * istride]);
	       tim2_0_0 = c_im(in[7 * istride]);
	       tre2_1_0 = c_re(in[39 * istride]);
	       tim2_1_0 = c_im(in[39 * istride]);
	       tre1_0_0 = tre2_0_0 + tre2_1_0;
	       tim1_0_0 = tim2_0_0 + tim2_1_0;
	       tre1_1_0 = tre2_0_0 - tre2_1_0;
	       tim1_1_0 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = c_re(in[15 * istride]);
	       tim2_0_0 = c_im(in[15 * istride]);
	       tre2_1_0 = c_re(in[47 * istride]);
	       tim2_1_0 = c_im(in[47 * istride]);
	       tre1_0_1 = tre2_0_0 + tre2_1_0;
	       tim1_0_1 = tim2_0_0 + tim2_1_0;
	       tre1_1_1 = tre2_0_0 - tre2_1_0;
	       tim1_1_1 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = c_re(in[23 * istride]);
	       tim2_0_0 = c_im(in[23 * istride]);
	       tre2_1_0 = c_re(in[55 * istride]);
	       tim2_1_0 = c_im(in[55 * istride]);
	       tre1_0_2 = tre2_0_0 + tre2_1_0;
	       tim1_0_2 = tim2_0_0 + tim2_1_0;
	       tre1_1_2 = tre2_0_0 - tre2_1_0;
	       tim1_1_2 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = c_re(in[31 * istride]);
	       tim2_0_0 = c_im(in[31 * istride]);
	       tre2_1_0 = c_re(in[63 * istride]);
	       tim2_1_0 = c_im(in[63 * istride]);
	       tre1_0_3 = tre2_0_0 + tre2_1_0;
	       tim1_0_3 = tim2_0_0 + tim2_1_0;
	       tre1_1_3 = tre2_0_0 - tre2_1_0;
	       tim1_1_3 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_0_1;
	       FFTW_REAL tim2_0_1;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       FFTW_REAL tre2_1_1;
	       FFTW_REAL tim2_1_1;
	       tre2_0_0 = tre1_0_0 + tre1_0_2;
	       tim2_0_0 = tim1_0_0 + tim1_0_2;
	       tre2_1_0 = tre1_0_0 - tre1_0_2;
	       tim2_1_0 = tim1_0_0 - tim1_0_2;
	       tre2_0_1 = tre1_0_1 + tre1_0_3;
	       tim2_0_1 = tim1_0_1 + tim1_0_3;
	       tre2_1_1 = tre1_0_1 - tre1_0_3;
	       tim2_1_1 = tim1_0_1 - tim1_0_3;
	       tre0_0_7 = tre2_0_0 + tre2_0_1;
	       tim0_0_7 = tim2_0_0 + tim2_0_1;
	       tre0_4_7 = tre2_0_0 - tre2_0_1;
	       tim0_4_7 = tim2_0_0 - tim2_0_1;
	       tre0_2_7 = tre2_1_0 - tim2_1_1;
	       tim0_2_7 = tim2_1_0 + tre2_1_1;
	       tre0_6_7 = tre2_1_0 + tim2_1_1;
	       tim0_6_7 = tim2_1_0 - tre2_1_1;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_0_1;
	       FFTW_REAL tim2_0_1;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       FFTW_REAL tre2_1_1;
	       FFTW_REAL tim2_1_1;
	       tre2_0_0 = tre1_1_0 - tim1_1_2;
	       tim2_0_0 = tim1_1_0 + tre1_1_2;
	       tre2_1_0 = tre1_1_0 + tim1_1_2;
	       tim2_1_0 = tim1_1_0 - tre1_1_2;
	       {
		    FFTW_REAL tre3_0_0;
		    FFTW_REAL tim3_0_0;
		    FFTW_REAL tre3_1_0;
		    FFTW_REAL tim3_1_0;
		    tre3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_1 - tim1_1_1);
		    tim3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tim1_1_1 + tre1_1_1);
		    tre3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 + tim1_1_3);
		    tim3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 - tim1_1_3);
		    tre2_0_1 = tre3_0_0 - tre3_1_0;
		    tim2_0_1 = tim3_0_0 + tim3_1_0;
		    tre2_1_1 = tre3_0_0 + tre3_1_0;
		    tim2_1_1 = tim3_0_0 - tim3_1_0;
	       }
	       tre0_1_7 = tre2_0_0 + tre2_0_1;
	       tim0_1_7 = tim2_0_0 + tim2_0_1;
	       tre0_5_7 = tre2_0_0 - tre2_0_1;
	       tim0_5_7 = tim2_0_0 - tim2_0_1;
	       tre0_3_7 = tre2_1_0 - tim2_1_1;
	       tim0_3_7 = tim2_1_0 + tre2_1_1;
	       tre0_7_7 = tre2_1_0 + tim2_1_1;
	       tim0_7_7 = tim2_1_0 - tre2_1_1;
	  }
     }
     {
	  FFTW_REAL tre1_0_0;
	  FFTW_REAL tim1_0_0;
	  FFTW_REAL tre1_0_1;
	  FFTW_REAL tim1_0_1;
	  FFTW_REAL tre1_0_2;
	  FFTW_REAL tim1_0_2;
	  FFTW_REAL tre1_0_3;
	  FFTW_REAL tim1_0_3;
	  FFTW_REAL tre1_1_0;
	  FFTW_REAL tim1_1_0;
	  FFTW_REAL tre1_1_1;
	  FFTW_REAL tim1_1_1;
	  FFTW_REAL tre1_1_2;
	  FFTW_REAL tim1_1_2;
	  FFTW_REAL tre1_1_3;
	  FFTW_REAL tim1_1_3;
	  tre1_0_0 = tre0_0_0 + tre0_0_4;
	  tim1_0_0 = tim0_0_0 + tim0_0_4;
	  tre1_1_0 = tre0_0_0 - tre0_0_4;
	  tim1_1_0 = tim0_0_0 - tim0_0_4;
	  tre1_0_1 = tre0_0_1 + tre0_0_5;
	  tim1_0_1 = tim0_0_1 + tim0_0_5;
	  tre1_1_1 = tre0_0_1 - tre0_0_5;
	  tim1_1_1 = tim0_0_1 - tim0_0_5;
	  tre1_0_2 = tre0_0_2 + tre0_0_6;
	  tim1_0_2 = tim0_0_2 + tim0_0_6;
	  tre1_1_2 = tre0_0_2 - tre0_0_6;
	  tim1_1_2 = tim0_0_2 - tim0_0_6;
	  tre1_0_3 = tre0_0_3 + tre0_0_7;
	  tim1_0_3 = tim0_0_3 + tim0_0_7;
	  tre1_1_3 = tre0_0_3 - tre0_0_7;
	  tim1_1_3 = tim0_0_3 - tim0_0_7;
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_0_1;
	       FFTW_REAL tim2_0_1;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       FFTW_REAL tre2_1_1;
	       FFTW_REAL tim2_1_1;
	       tre2_0_0 = tre1_0_0 + tre1_0_2;
	       tim2_0_0 = tim1_0_0 + tim1_0_2;
	       tre2_1_0 = tre1_0_0 - tre1_0_2;
	       tim2_1_0 = tim1_0_0 - tim1_0_2;
	       tre2_0_1 = tre1_0_1 + tre1_0_3;
	       tim2_0_1 = tim1_0_1 + tim1_0_3;
	       tre2_1_1 = tre1_0_1 - tre1_0_3;
	       tim2_1_1 = tim1_0_1 - tim1_0_3;
	       c_re(out[0]) = tre2_0_0 + tre2_0_1;
	       c_im(out[0]) = tim2_0_0 + tim2_0_1;
	       c_re(out[32 * ostride]) = tre2_0_0 - tre2_0_1;
	       c_im(out[32 * ostride]) = tim2_0_0 - tim2_0_1;
	       c_re(out[16 * ostride]) = tre2_1_0 - tim2_1_1;
	       c_im(out[16 * ostride]) = tim2_1_0 + tre2_1_1;
	       c_re(out[48 * ostride]) = tre2_1_0 + tim2_1_1;
	       c_im(out[48 * ostride]) = tim2_1_0 - tre2_1_1;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_0_1;
	       FFTW_REAL tim2_0_1;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       FFTW_REAL tre2_1_1;
	       FFTW_REAL tim2_1_1;
	       tre2_0_0 = tre1_1_0 - tim1_1_2;
	       tim2_0_0 = tim1_1_0 + tre1_1_2;
	       tre2_1_0 = tre1_1_0 + tim1_1_2;
	       tim2_1_0 = tim1_1_0 - tre1_1_2;
	       {
		    FFTW_REAL tre3_0_0;
		    FFTW_REAL tim3_0_0;
		    FFTW_REAL tre3_1_0;
		    FFTW_REAL tim3_1_0;
		    tre3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_1 - tim1_1_1);
		    tim3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tim1_1_1 + tre1_1_1);
		    tre3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 + tim1_1_3);
		    tim3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 - tim1_1_3);
		    tre2_0_1 = tre3_0_0 - tre3_1_0;
		    tim2_0_1 = tim3_0_0 + tim3_1_0;
		    tre2_1_1 = tre3_0_0 + tre3_1_0;
		    tim2_1_1 = tim3_0_0 - tim3_1_0;
	       }
	       c_re(out[8 * ostride]) = tre2_0_0 + tre2_0_1;
	       c_im(out[8 * ostride]) = tim2_0_0 + tim2_0_1;
	       c_re(out[40 * ostride]) = tre2_0_0 - tre2_0_1;
	       c_im(out[40 * ostride]) = tim2_0_0 - tim2_0_1;
	       c_re(out[24 * ostride]) = tre2_1_0 - tim2_1_1;
	       c_im(out[24 * ostride]) = tim2_1_0 + tre2_1_1;
	       c_re(out[56 * ostride]) = tre2_1_0 + tim2_1_1;
	       c_im(out[56 * ostride]) = tim2_1_0 - tre2_1_1;
	  }
     }
     {
	  FFTW_REAL tre1_0_0;
	  FFTW_REAL tim1_0_0;
	  FFTW_REAL tre1_0_1;
	  FFTW_REAL tim1_0_1;
	  FFTW_REAL tre1_0_2;
	  FFTW_REAL tim1_0_2;
	  FFTW_REAL tre1_0_3;
	  FFTW_REAL tim1_0_3;
	  FFTW_REAL tre1_1_0;
	  FFTW_REAL tim1_1_0;
	  FFTW_REAL tre1_1_1;
	  FFTW_REAL tim1_1_1;
	  FFTW_REAL tre1_1_2;
	  FFTW_REAL tim1_1_2;
	  FFTW_REAL tre1_1_3;
	  FFTW_REAL tim1_1_3;
	  {
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_1_0 = (((FFTW_REAL) FFTW_K923879532) * tre0_1_4) - (((FFTW_REAL) FFTW_K382683432) * tim0_1_4);
	       tim2_1_0 = (((FFTW_REAL) FFTW_K923879532) * tim0_1_4) + (((FFTW_REAL) FFTW_K382683432) * tre0_1_4);
	       tre1_0_0 = tre0_1_0 + tre2_1_0;
	       tim1_0_0 = tim0_1_0 + tim2_1_0;
	       tre1_1_0 = tre0_1_0 - tre2_1_0;
	       tim1_1_0 = tim0_1_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = (((FFTW_REAL) FFTW_K995184726) * tre0_1_1) - (((FFTW_REAL) FFTW_K098017140) * tim0_1_1);
	       tim2_0_0 = (((FFTW_REAL) FFTW_K995184726) * tim0_1_1) + (((FFTW_REAL) FFTW_K098017140) * tre0_1_1);
	       tre2_1_0 = (((FFTW_REAL) FFTW_K881921264) * tre0_1_5) - (((FFTW_REAL) FFTW_K471396736) * tim0_1_5);
	       tim2_1_0 = (((FFTW_REAL) FFTW_K881921264) * tim0_1_5) + (((FFTW_REAL) FFTW_K471396736) * tre0_1_5);
	       tre1_0_1 = tre2_0_0 + tre2_1_0;
	       tim1_0_1 = tim2_0_0 + tim2_1_0;
	       tre1_1_1 = tre2_0_0 - tre2_1_0;
	       tim1_1_1 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = (((FFTW_REAL) FFTW_K980785280) * tre0_1_2) - (((FFTW_REAL) FFTW_K195090322) * tim0_1_2);
	       tim2_0_0 = (((FFTW_REAL) FFTW_K980785280) * tim0_1_2) + (((FFTW_REAL) FFTW_K195090322) * tre0_1_2);
	       tre2_1_0 = (((FFTW_REAL) FFTW_K831469612) * tre0_1_6) - (((FFTW_REAL) FFTW_K555570233) * tim0_1_6);
	       tim2_1_0 = (((FFTW_REAL) FFTW_K831469612) * tim0_1_6) + (((FFTW_REAL) FFTW_K555570233) * tre0_1_6);
	       tre1_0_2 = tre2_0_0 + tre2_1_0;
	       tim1_0_2 = tim2_0_0 + tim2_1_0;
	       tre1_1_2 = tre2_0_0 - tre2_1_0;
	       tim1_1_2 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = (((FFTW_REAL) FFTW_K956940335) * tre0_1_3) - (((FFTW_REAL) FFTW_K290284677) * tim0_1_3);
	       tim2_0_0 = (((FFTW_REAL) FFTW_K956940335) * tim0_1_3) + (((FFTW_REAL) FFTW_K290284677) * tre0_1_3);
	       tre2_1_0 = (((FFTW_REAL) FFTW_K773010453) * tre0_1_7) - (((FFTW_REAL) FFTW_K634393284) * tim0_1_7);
	       tim2_1_0 = (((FFTW_REAL) FFTW_K773010453) * tim0_1_7) + (((FFTW_REAL) FFTW_K634393284) * tre0_1_7);
	       tre1_0_3 = tre2_0_0 + tre2_1_0;
	       tim1_0_3 = tim2_0_0 + tim2_1_0;
	       tre1_1_3 = tre2_0_0 - tre2_1_0;
	       tim1_1_3 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_0_1;
	       FFTW_REAL tim2_0_1;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       FFTW_REAL tre2_1_1;
	       FFTW_REAL tim2_1_1;
	       tre2_0_0 = tre1_0_0 + tre1_0_2;
	       tim2_0_0 = tim1_0_0 + tim1_0_2;
	       tre2_1_0 = tre1_0_0 - tre1_0_2;
	       tim2_1_0 = tim1_0_0 - tim1_0_2;
	       tre2_0_1 = tre1_0_1 + tre1_0_3;
	       tim2_0_1 = tim1_0_1 + tim1_0_3;
	       tre2_1_1 = tre1_0_1 - tre1_0_3;
	       tim2_1_1 = tim1_0_1 - tim1_0_3;
	       c_re(out[ostride]) = tre2_0_0 + tre2_0_1;
	       c_im(out[ostride]) = tim2_0_0 + tim2_0_1;
	       c_re(out[33 * ostride]) = tre2_0_0 - tre2_0_1;
	       c_im(out[33 * ostride]) = tim2_0_0 - tim2_0_1;
	       c_re(out[17 * ostride]) = tre2_1_0 - tim2_1_1;
	       c_im(out[17 * ostride]) = tim2_1_0 + tre2_1_1;
	       c_re(out[49 * ostride]) = tre2_1_0 + tim2_1_1;
	       c_im(out[49 * ostride]) = tim2_1_0 - tre2_1_1;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_0_1;
	       FFTW_REAL tim2_0_1;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       FFTW_REAL tre2_1_1;
	       FFTW_REAL tim2_1_1;
	       tre2_0_0 = tre1_1_0 - tim1_1_2;
	       tim2_0_0 = tim1_1_0 + tre1_1_2;
	       tre2_1_0 = tre1_1_0 + tim1_1_2;
	       tim2_1_0 = tim1_1_0 - tre1_1_2;
	       {
		    FFTW_REAL tre3_0_0;
		    FFTW_REAL tim3_0_0;
		    FFTW_REAL tre3_1_0;
		    FFTW_REAL tim3_1_0;
		    tre3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_1 - tim1_1_1);
		    tim3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tim1_1_1 + tre1_1_1);
		    tre3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 + tim1_1_3);
		    tim3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 - tim1_1_3);
		    tre2_0_1 = tre3_0_0 - tre3_1_0;
		    tim2_0_1 = tim3_0_0 + tim3_1_0;
		    tre2_1_1 = tre3_0_0 + tre3_1_0;
		    tim2_1_1 = tim3_0_0 - tim3_1_0;
	       }
	       c_re(out[9 * ostride]) = tre2_0_0 + tre2_0_1;
	       c_im(out[9 * ostride]) = tim2_0_0 + tim2_0_1;
	       c_re(out[41 * ostride]) = tre2_0_0 - tre2_0_1;
	       c_im(out[41 * ostride]) = tim2_0_0 - tim2_0_1;
	       c_re(out[25 * ostride]) = tre2_1_0 - tim2_1_1;
	       c_im(out[25 * ostride]) = tim2_1_0 + tre2_1_1;
	       c_re(out[57 * ostride]) = tre2_1_0 + tim2_1_1;
	       c_im(out[57 * ostride]) = tim2_1_0 - tre2_1_1;
	  }
     }
     {
	  FFTW_REAL tre1_0_0;
	  FFTW_REAL tim1_0_0;
	  FFTW_REAL tre1_0_1;
	  FFTW_REAL tim1_0_1;
	  FFTW_REAL tre1_0_2;
	  FFTW_REAL tim1_0_2;
	  FFTW_REAL tre1_0_3;
	  FFTW_REAL tim1_0_3;
	  FFTW_REAL tre1_1_0;
	  FFTW_REAL tim1_1_0;
	  FFTW_REAL tre1_1_1;
	  FFTW_REAL tim1_1_1;
	  FFTW_REAL tre1_1_2;
	  FFTW_REAL tim1_1_2;
	  FFTW_REAL tre1_1_3;
	  FFTW_REAL tim1_1_3;
	  {
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre0_2_4 - tim0_2_4);
	       tim2_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tim0_2_4 + tre0_2_4);
	       tre1_0_0 = tre0_2_0 + tre2_1_0;
	       tim1_0_0 = tim0_2_0 + tim2_1_0;
	       tre1_1_0 = tre0_2_0 - tre2_1_0;
	       tim1_1_0 = tim0_2_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = (((FFTW_REAL) FFTW_K980785280) * tre0_2_1) - (((FFTW_REAL) FFTW_K195090322) * tim0_2_1);
	       tim2_0_0 = (((FFTW_REAL) FFTW_K980785280) * tim0_2_1) + (((FFTW_REAL) FFTW_K195090322) * tre0_2_1);
	       tre2_1_0 = (((FFTW_REAL) FFTW_K555570233) * tre0_2_5) - (((FFTW_REAL) FFTW_K831469612) * tim0_2_5);
	       tim2_1_0 = (((FFTW_REAL) FFTW_K555570233) * tim0_2_5) + (((FFTW_REAL) FFTW_K831469612) * tre0_2_5);
	       tre1_0_1 = tre2_0_0 + tre2_1_0;
	       tim1_0_1 = tim2_0_0 + tim2_1_0;
	       tre1_1_1 = tre2_0_0 - tre2_1_0;
	       tim1_1_1 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = (((FFTW_REAL) FFTW_K923879532) * tre0_2_2) - (((FFTW_REAL) FFTW_K382683432) * tim0_2_2);
	       tim2_0_0 = (((FFTW_REAL) FFTW_K923879532) * tim0_2_2) + (((FFTW_REAL) FFTW_K382683432) * tre0_2_2);
	       tre2_1_0 = (((FFTW_REAL) FFTW_K382683432) * tre0_2_6) - (((FFTW_REAL) FFTW_K923879532) * tim0_2_6);
	       tim2_1_0 = (((FFTW_REAL) FFTW_K382683432) * tim0_2_6) + (((FFTW_REAL) FFTW_K923879532) * tre0_2_6);
	       tre1_0_2 = tre2_0_0 + tre2_1_0;
	       tim1_0_2 = tim2_0_0 + tim2_1_0;
	       tre1_1_2 = tre2_0_0 - tre2_1_0;
	       tim1_1_2 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = (((FFTW_REAL) FFTW_K831469612) * tre0_2_3) - (((FFTW_REAL) FFTW_K555570233) * tim0_2_3);
	       tim2_0_0 = (((FFTW_REAL) FFTW_K831469612) * tim0_2_3) + (((FFTW_REAL) FFTW_K555570233) * tre0_2_3);
	       tre2_1_0 = (((FFTW_REAL) FFTW_K195090322) * tre0_2_7) - (((FFTW_REAL) FFTW_K980785280) * tim0_2_7);
	       tim2_1_0 = (((FFTW_REAL) FFTW_K195090322) * tim0_2_7) + (((FFTW_REAL) FFTW_K980785280) * tre0_2_7);
	       tre1_0_3 = tre2_0_0 + tre2_1_0;
	       tim1_0_3 = tim2_0_0 + tim2_1_0;
	       tre1_1_3 = tre2_0_0 - tre2_1_0;
	       tim1_1_3 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_0_1;
	       FFTW_REAL tim2_0_1;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       FFTW_REAL tre2_1_1;
	       FFTW_REAL tim2_1_1;
	       tre2_0_0 = tre1_0_0 + tre1_0_2;
	       tim2_0_0 = tim1_0_0 + tim1_0_2;
	       tre2_1_0 = tre1_0_0 - tre1_0_2;
	       tim2_1_0 = tim1_0_0 - tim1_0_2;
	       tre2_0_1 = tre1_0_1 + tre1_0_3;
	       tim2_0_1 = tim1_0_1 + tim1_0_3;
	       tre2_1_1 = tre1_0_1 - tre1_0_3;
	       tim2_1_1 = tim1_0_1 - tim1_0_3;
	       c_re(out[2 * ostride]) = tre2_0_0 + tre2_0_1;
	       c_im(out[2 * ostride]) = tim2_0_0 + tim2_0_1;
	       c_re(out[34 * ostride]) = tre2_0_0 - tre2_0_1;
	       c_im(out[34 * ostride]) = tim2_0_0 - tim2_0_1;
	       c_re(out[18 * ostride]) = tre2_1_0 - tim2_1_1;
	       c_im(out[18 * ostride]) = tim2_1_0 + tre2_1_1;
	       c_re(out[50 * ostride]) = tre2_1_0 + tim2_1_1;
	       c_im(out[50 * ostride]) = tim2_1_0 - tre2_1_1;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_0_1;
	       FFTW_REAL tim2_0_1;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       FFTW_REAL tre2_1_1;
	       FFTW_REAL tim2_1_1;
	       tre2_0_0 = tre1_1_0 - tim1_1_2;
	       tim2_0_0 = tim1_1_0 + tre1_1_2;
	       tre2_1_0 = tre1_1_0 + tim1_1_2;
	       tim2_1_0 = tim1_1_0 - tre1_1_2;
	       {
		    FFTW_REAL tre3_0_0;
		    FFTW_REAL tim3_0_0;
		    FFTW_REAL tre3_1_0;
		    FFTW_REAL tim3_1_0;
		    tre3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_1 - tim1_1_1);
		    tim3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tim1_1_1 + tre1_1_1);
		    tre3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 + tim1_1_3);
		    tim3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 - tim1_1_3);
		    tre2_0_1 = tre3_0_0 - tre3_1_0;
		    tim2_0_1 = tim3_0_0 + tim3_1_0;
		    tre2_1_1 = tre3_0_0 + tre3_1_0;
		    tim2_1_1 = tim3_0_0 - tim3_1_0;
	       }
	       c_re(out[10 * ostride]) = tre2_0_0 + tre2_0_1;
	       c_im(out[10 * ostride]) = tim2_0_0 + tim2_0_1;
	       c_re(out[42 * ostride]) = tre2_0_0 - tre2_0_1;
	       c_im(out[42 * ostride]) = tim2_0_0 - tim2_0_1;
	       c_re(out[26 * ostride]) = tre2_1_0 - tim2_1_1;
	       c_im(out[26 * ostride]) = tim2_1_0 + tre2_1_1;
	       c_re(out[58 * ostride]) = tre2_1_0 + tim2_1_1;
	       c_im(out[58 * ostride]) = tim2_1_0 - tre2_1_1;
	  }
     }
     {
	  FFTW_REAL tre1_0_0;
	  FFTW_REAL tim1_0_0;
	  FFTW_REAL tre1_0_1;
	  FFTW_REAL tim1_0_1;
	  FFTW_REAL tre1_0_2;
	  FFTW_REAL tim1_0_2;
	  FFTW_REAL tre1_0_3;
	  FFTW_REAL tim1_0_3;
	  FFTW_REAL tre1_1_0;
	  FFTW_REAL tim1_1_0;
	  FFTW_REAL tre1_1_1;
	  FFTW_REAL tim1_1_1;
	  FFTW_REAL tre1_1_2;
	  FFTW_REAL tim1_1_2;
	  FFTW_REAL tre1_1_3;
	  FFTW_REAL tim1_1_3;
	  {
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_1_0 = (((FFTW_REAL) FFTW_K382683432) * tre0_3_4) - (((FFTW_REAL) FFTW_K923879532) * tim0_3_4);
	       tim2_1_0 = (((FFTW_REAL) FFTW_K382683432) * tim0_3_4) + (((FFTW_REAL) FFTW_K923879532) * tre0_3_4);
	       tre1_0_0 = tre0_3_0 + tre2_1_0;
	       tim1_0_0 = tim0_3_0 + tim2_1_0;
	       tre1_1_0 = tre0_3_0 - tre2_1_0;
	       tim1_1_0 = tim0_3_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = (((FFTW_REAL) FFTW_K956940335) * tre0_3_1) - (((FFTW_REAL) FFTW_K290284677) * tim0_3_1);
	       tim2_0_0 = (((FFTW_REAL) FFTW_K956940335) * tim0_3_1) + (((FFTW_REAL) FFTW_K290284677) * tre0_3_1);
	       tre2_1_0 = (((FFTW_REAL) FFTW_K098017140) * tre0_3_5) - (((FFTW_REAL) FFTW_K995184726) * tim0_3_5);
	       tim2_1_0 = (((FFTW_REAL) FFTW_K098017140) * tim0_3_5) + (((FFTW_REAL) FFTW_K995184726) * tre0_3_5);
	       tre1_0_1 = tre2_0_0 + tre2_1_0;
	       tim1_0_1 = tim2_0_0 + tim2_1_0;
	       tre1_1_1 = tre2_0_0 - tre2_1_0;
	       tim1_1_1 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = (((FFTW_REAL) FFTW_K831469612) * tre0_3_2) - (((FFTW_REAL) FFTW_K555570233) * tim0_3_2);
	       tim2_0_0 = (((FFTW_REAL) FFTW_K831469612) * tim0_3_2) + (((FFTW_REAL) FFTW_K555570233) * tre0_3_2);
	       tre2_1_0 = (((FFTW_REAL) FFTW_K195090322) * tre0_3_6) + (((FFTW_REAL) FFTW_K980785280) * tim0_3_6);
	       tim2_1_0 = (((FFTW_REAL) FFTW_K980785280) * tre0_3_6) - (((FFTW_REAL) FFTW_K195090322) * tim0_3_6);
	       tre1_0_2 = tre2_0_0 - tre2_1_0;
	       tim1_0_2 = tim2_0_0 + tim2_1_0;
	       tre1_1_2 = tre2_0_0 + tre2_1_0;
	       tim1_1_2 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = (((FFTW_REAL) FFTW_K634393284) * tre0_3_3) - (((FFTW_REAL) FFTW_K773010453) * tim0_3_3);
	       tim2_0_0 = (((FFTW_REAL) FFTW_K634393284) * tim0_3_3) + (((FFTW_REAL) FFTW_K773010453) * tre0_3_3);
	       tre2_1_0 = (((FFTW_REAL) FFTW_K471396736) * tre0_3_7) + (((FFTW_REAL) FFTW_K881921264) * tim0_3_7);
	       tim2_1_0 = (((FFTW_REAL) FFTW_K881921264) * tre0_3_7) - (((FFTW_REAL) FFTW_K471396736) * tim0_3_7);
	       tre1_0_3 = tre2_0_0 - tre2_1_0;
	       tim1_0_3 = tim2_0_0 + tim2_1_0;
	       tre1_1_3 = tre2_0_0 + tre2_1_0;
	       tim1_1_3 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_0_1;
	       FFTW_REAL tim2_0_1;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       FFTW_REAL tre2_1_1;
	       FFTW_REAL tim2_1_1;
	       tre2_0_0 = tre1_0_0 + tre1_0_2;
	       tim2_0_0 = tim1_0_0 + tim1_0_2;
	       tre2_1_0 = tre1_0_0 - tre1_0_2;
	       tim2_1_0 = tim1_0_0 - tim1_0_2;
	       tre2_0_1 = tre1_0_1 + tre1_0_3;
	       tim2_0_1 = tim1_0_1 + tim1_0_3;
	       tre2_1_1 = tre1_0_1 - tre1_0_3;
	       tim2_1_1 = tim1_0_1 - tim1_0_3;
	       c_re(out[3 * ostride]) = tre2_0_0 + tre2_0_1;
	       c_im(out[3 * ostride]) = tim2_0_0 + tim2_0_1;
	       c_re(out[35 * ostride]) = tre2_0_0 - tre2_0_1;
	       c_im(out[35 * ostride]) = tim2_0_0 - tim2_0_1;
	       c_re(out[19 * ostride]) = tre2_1_0 - tim2_1_1;
	       c_im(out[19 * ostride]) = tim2_1_0 + tre2_1_1;
	       c_re(out[51 * ostride]) = tre2_1_0 + tim2_1_1;
	       c_im(out[51 * ostride]) = tim2_1_0 - tre2_1_1;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_0_1;
	       FFTW_REAL tim2_0_1;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       FFTW_REAL tre2_1_1;
	       FFTW_REAL tim2_1_1;
	       tre2_0_0 = tre1_1_0 - tim1_1_2;
	       tim2_0_0 = tim1_1_0 + tre1_1_2;
	       tre2_1_0 = tre1_1_0 + tim1_1_2;
	       tim2_1_0 = tim1_1_0 - tre1_1_2;
	       {
		    FFTW_REAL tre3_0_0;
		    FFTW_REAL tim3_0_0;
		    FFTW_REAL tre3_1_0;
		    FFTW_REAL tim3_1_0;
		    tre3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_1 - tim1_1_1);
		    tim3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tim1_1_1 + tre1_1_1);
		    tre3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 + tim1_1_3);
		    tim3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 - tim1_1_3);
		    tre2_0_1 = tre3_0_0 - tre3_1_0;
		    tim2_0_1 = tim3_0_0 + tim3_1_0;
		    tre2_1_1 = tre3_0_0 + tre3_1_0;
		    tim2_1_1 = tim3_0_0 - tim3_1_0;
	       }
	       c_re(out[11 * ostride]) = tre2_0_0 + tre2_0_1;
	       c_im(out[11 * ostride]) = tim2_0_0 + tim2_0_1;
	       c_re(out[43 * ostride]) = tre2_0_0 - tre2_0_1;
	       c_im(out[43 * ostride]) = tim2_0_0 - tim2_0_1;
	       c_re(out[27 * ostride]) = tre2_1_0 - tim2_1_1;
	       c_im(out[27 * ostride]) = tim2_1_0 + tre2_1_1;
	       c_re(out[59 * ostride]) = tre2_1_0 + tim2_1_1;
	       c_im(out[59 * ostride]) = tim2_1_0 - tre2_1_1;
	  }
     }
     {
	  FFTW_REAL tre1_0_0;
	  FFTW_REAL tim1_0_0;
	  FFTW_REAL tre1_0_1;
	  FFTW_REAL tim1_0_1;
	  FFTW_REAL tre1_0_2;
	  FFTW_REAL tim1_0_2;
	  FFTW_REAL tre1_0_3;
	  FFTW_REAL tim1_0_3;
	  FFTW_REAL tre1_1_0;
	  FFTW_REAL tim1_1_0;
	  FFTW_REAL tre1_1_1;
	  FFTW_REAL tim1_1_1;
	  FFTW_REAL tre1_1_2;
	  FFTW_REAL tim1_1_2;
	  FFTW_REAL tre1_1_3;
	  FFTW_REAL tim1_1_3;
	  tre1_0_0 = tre0_4_0 - tim0_4_4;
	  tim1_0_0 = tim0_4_0 + tre0_4_4;
	  tre1_1_0 = tre0_4_0 + tim0_4_4;
	  tim1_1_0 = tim0_4_0 - tre0_4_4;
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = (((FFTW_REAL) FFTW_K923879532) * tre0_4_1) - (((FFTW_REAL) FFTW_K382683432) * tim0_4_1);
	       tim2_0_0 = (((FFTW_REAL) FFTW_K923879532) * tim0_4_1) + (((FFTW_REAL) FFTW_K382683432) * tre0_4_1);
	       tre2_1_0 = (((FFTW_REAL) FFTW_K382683432) * tre0_4_5) + (((FFTW_REAL) FFTW_K923879532) * tim0_4_5);
	       tim2_1_0 = (((FFTW_REAL) FFTW_K923879532) * tre0_4_5) - (((FFTW_REAL) FFTW_K382683432) * tim0_4_5);
	       tre1_0_1 = tre2_0_0 - tre2_1_0;
	       tim1_0_1 = tim2_0_0 + tim2_1_0;
	       tre1_1_1 = tre2_0_0 + tre2_1_0;
	       tim1_1_1 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tre0_4_2 - tim0_4_2);
	       tim2_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tim0_4_2 + tre0_4_2);
	       tre2_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre0_4_6 + tim0_4_6);
	       tim2_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre0_4_6 - tim0_4_6);
	       tre1_0_2 = tre2_0_0 - tre2_1_0;
	       tim1_0_2 = tim2_0_0 + tim2_1_0;
	       tre1_1_2 = tre2_0_0 + tre2_1_0;
	       tim1_1_2 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = (((FFTW_REAL) FFTW_K382683432) * tre0_4_3) - (((FFTW_REAL) FFTW_K923879532) * tim0_4_3);
	       tim2_0_0 = (((FFTW_REAL) FFTW_K382683432) * tim0_4_3) + (((FFTW_REAL) FFTW_K923879532) * tre0_4_3);
	       tre2_1_0 = (((FFTW_REAL) FFTW_K923879532) * tre0_4_7) + (((FFTW_REAL) FFTW_K382683432) * tim0_4_7);
	       tim2_1_0 = (((FFTW_REAL) FFTW_K382683432) * tre0_4_7) - (((FFTW_REAL) FFTW_K923879532) * tim0_4_7);
	       tre1_0_3 = tre2_0_0 - tre2_1_0;
	       tim1_0_3 = tim2_0_0 + tim2_1_0;
	       tre1_1_3 = tre2_0_0 + tre2_1_0;
	       tim1_1_3 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_0_1;
	       FFTW_REAL tim2_0_1;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       FFTW_REAL tre2_1_1;
	       FFTW_REAL tim2_1_1;
	       tre2_0_0 = tre1_0_0 + tre1_0_2;
	       tim2_0_0 = tim1_0_0 + tim1_0_2;
	       tre2_1_0 = tre1_0_0 - tre1_0_2;
	       tim2_1_0 = tim1_0_0 - tim1_0_2;
	       tre2_0_1 = tre1_0_1 + tre1_0_3;
	       tim2_0_1 = tim1_0_1 + tim1_0_3;
	       tre2_1_1 = tre1_0_1 - tre1_0_3;
	       tim2_1_1 = tim1_0_1 - tim1_0_3;
	       c_re(out[4 * ostride]) = tre2_0_0 + tre2_0_1;
	       c_im(out[4 * ostride]) = tim2_0_0 + tim2_0_1;
	       c_re(out[36 * ostride]) = tre2_0_0 - tre2_0_1;
	       c_im(out[36 * ostride]) = tim2_0_0 - tim2_0_1;
	       c_re(out[20 * ostride]) = tre2_1_0 - tim2_1_1;
	       c_im(out[20 * ostride]) = tim2_1_0 + tre2_1_1;
	       c_re(out[52 * ostride]) = tre2_1_0 + tim2_1_1;
	       c_im(out[52 * ostride]) = tim2_1_0 - tre2_1_1;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_0_1;
	       FFTW_REAL tim2_0_1;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       FFTW_REAL tre2_1_1;
	       FFTW_REAL tim2_1_1;
	       tre2_0_0 = tre1_1_0 - tim1_1_2;
	       tim2_0_0 = tim1_1_0 + tre1_1_2;
	       tre2_1_0 = tre1_1_0 + tim1_1_2;
	       tim2_1_0 = tim1_1_0 - tre1_1_2;
	       {
		    FFTW_REAL tre3_0_0;
		    FFTW_REAL tim3_0_0;
		    FFTW_REAL tre3_1_0;
		    FFTW_REAL tim3_1_0;
		    tre3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_1 - tim1_1_1);
		    tim3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tim1_1_1 + tre1_1_1);
		    tre3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 + tim1_1_3);
		    tim3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 - tim1_1_3);
		    tre2_0_1 = tre3_0_0 - tre3_1_0;
		    tim2_0_1 = tim3_0_0 + tim3_1_0;
		    tre2_1_1 = tre3_0_0 + tre3_1_0;
		    tim2_1_1 = tim3_0_0 - tim3_1_0;
	       }
	       c_re(out[12 * ostride]) = tre2_0_0 + tre2_0_1;
	       c_im(out[12 * ostride]) = tim2_0_0 + tim2_0_1;
	       c_re(out[44 * ostride]) = tre2_0_0 - tre2_0_1;
	       c_im(out[44 * ostride]) = tim2_0_0 - tim2_0_1;
	       c_re(out[28 * ostride]) = tre2_1_0 - tim2_1_1;
	       c_im(out[28 * ostride]) = tim2_1_0 + tre2_1_1;
	       c_re(out[60 * ostride]) = tre2_1_0 + tim2_1_1;
	       c_im(out[60 * ostride]) = tim2_1_0 - tre2_1_1;
	  }
     }
     {
	  FFTW_REAL tre1_0_0;
	  FFTW_REAL tim1_0_0;
	  FFTW_REAL tre1_0_1;
	  FFTW_REAL tim1_0_1;
	  FFTW_REAL tre1_0_2;
	  FFTW_REAL tim1_0_2;
	  FFTW_REAL tre1_0_3;
	  FFTW_REAL tim1_0_3;
	  FFTW_REAL tre1_1_0;
	  FFTW_REAL tim1_1_0;
	  FFTW_REAL tre1_1_1;
	  FFTW_REAL tim1_1_1;
	  FFTW_REAL tre1_1_2;
	  FFTW_REAL tim1_1_2;
	  FFTW_REAL tre1_1_3;
	  FFTW_REAL tim1_1_3;
	  {
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_1_0 = (((FFTW_REAL) FFTW_K382683432) * tre0_5_4) + (((FFTW_REAL) FFTW_K923879532) * tim0_5_4);
	       tim2_1_0 = (((FFTW_REAL) FFTW_K923879532) * tre0_5_4) - (((FFTW_REAL) FFTW_K382683432) * tim0_5_4);
	       tre1_0_0 = tre0_5_0 - tre2_1_0;
	       tim1_0_0 = tim0_5_0 + tim2_1_0;
	       tre1_1_0 = tre0_5_0 + tre2_1_0;
	       tim1_1_0 = tim0_5_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = (((FFTW_REAL) FFTW_K881921264) * tre0_5_1) - (((FFTW_REAL) FFTW_K471396736) * tim0_5_1);
	       tim2_0_0 = (((FFTW_REAL) FFTW_K881921264) * tim0_5_1) + (((FFTW_REAL) FFTW_K471396736) * tre0_5_1);
	       tre2_1_0 = (((FFTW_REAL) FFTW_K773010453) * tre0_5_5) + (((FFTW_REAL) FFTW_K634393284) * tim0_5_5);
	       tim2_1_0 = (((FFTW_REAL) FFTW_K634393284) * tre0_5_5) - (((FFTW_REAL) FFTW_K773010453) * tim0_5_5);
	       tre1_0_1 = tre2_0_0 - tre2_1_0;
	       tim1_0_1 = tim2_0_0 + tim2_1_0;
	       tre1_1_1 = tre2_0_0 + tre2_1_0;
	       tim1_1_1 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = (((FFTW_REAL) FFTW_K555570233) * tre0_5_2) - (((FFTW_REAL) FFTW_K831469612) * tim0_5_2);
	       tim2_0_0 = (((FFTW_REAL) FFTW_K555570233) * tim0_5_2) + (((FFTW_REAL) FFTW_K831469612) * tre0_5_2);
	       tre2_1_0 = (((FFTW_REAL) FFTW_K980785280) * tre0_5_6) + (((FFTW_REAL) FFTW_K195090322) * tim0_5_6);
	       tim2_1_0 = (((FFTW_REAL) FFTW_K195090322) * tre0_5_6) - (((FFTW_REAL) FFTW_K980785280) * tim0_5_6);
	       tre1_0_2 = tre2_0_0 - tre2_1_0;
	       tim1_0_2 = tim2_0_0 + tim2_1_0;
	       tre1_1_2 = tre2_0_0 + tre2_1_0;
	       tim1_1_2 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = (((FFTW_REAL) FFTW_K098017140) * tre0_5_3) - (((FFTW_REAL) FFTW_K995184726) * tim0_5_3);
	       tim2_0_0 = (((FFTW_REAL) FFTW_K098017140) * tim0_5_3) + (((FFTW_REAL) FFTW_K995184726) * tre0_5_3);
	       tre2_1_0 = (((FFTW_REAL) FFTW_K290284677) * tim0_5_7) - (((FFTW_REAL) FFTW_K956940335) * tre0_5_7);
	       tim2_1_0 = (((FFTW_REAL) FFTW_K956940335) * tim0_5_7) + (((FFTW_REAL) FFTW_K290284677) * tre0_5_7);
	       tre1_0_3 = tre2_0_0 + tre2_1_0;
	       tim1_0_3 = tim2_0_0 - tim2_1_0;
	       tre1_1_3 = tre2_0_0 - tre2_1_0;
	       tim1_1_3 = tim2_0_0 + tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_0_1;
	       FFTW_REAL tim2_0_1;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       FFTW_REAL tre2_1_1;
	       FFTW_REAL tim2_1_1;
	       tre2_0_0 = tre1_0_0 + tre1_0_2;
	       tim2_0_0 = tim1_0_0 + tim1_0_2;
	       tre2_1_0 = tre1_0_0 - tre1_0_2;
	       tim2_1_0 = tim1_0_0 - tim1_0_2;
	       tre2_0_1 = tre1_0_1 + tre1_0_3;
	       tim2_0_1 = tim1_0_1 + tim1_0_3;
	       tre2_1_1 = tre1_0_1 - tre1_0_3;
	       tim2_1_1 = tim1_0_1 - tim1_0_3;
	       c_re(out[5 * ostride]) = tre2_0_0 + tre2_0_1;
	       c_im(out[5 * ostride]) = tim2_0_0 + tim2_0_1;
	       c_re(out[37 * ostride]) = tre2_0_0 - tre2_0_1;
	       c_im(out[37 * ostride]) = tim2_0_0 - tim2_0_1;
	       c_re(out[21 * ostride]) = tre2_1_0 - tim2_1_1;
	       c_im(out[21 * ostride]) = tim2_1_0 + tre2_1_1;
	       c_re(out[53 * ostride]) = tre2_1_0 + tim2_1_1;
	       c_im(out[53 * ostride]) = tim2_1_0 - tre2_1_1;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_0_1;
	       FFTW_REAL tim2_0_1;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       FFTW_REAL tre2_1_1;
	       FFTW_REAL tim2_1_1;
	       tre2_0_0 = tre1_1_0 - tim1_1_2;
	       tim2_0_0 = tim1_1_0 + tre1_1_2;
	       tre2_1_0 = tre1_1_0 + tim1_1_2;
	       tim2_1_0 = tim1_1_0 - tre1_1_2;
	       {
		    FFTW_REAL tre3_0_0;
		    FFTW_REAL tim3_0_0;
		    FFTW_REAL tre3_1_0;
		    FFTW_REAL tim3_1_0;
		    tre3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_1 - tim1_1_1);
		    tim3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tim1_1_1 + tre1_1_1);
		    tre3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 + tim1_1_3);
		    tim3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 - tim1_1_3);
		    tre2_0_1 = tre3_0_0 - tre3_1_0;
		    tim2_0_1 = tim3_0_0 + tim3_1_0;
		    tre2_1_1 = tre3_0_0 + tre3_1_0;
		    tim2_1_1 = tim3_0_0 - tim3_1_0;
	       }
	       c_re(out[13 * ostride]) = tre2_0_0 + tre2_0_1;
	       c_im(out[13 * ostride]) = tim2_0_0 + tim2_0_1;
	       c_re(out[45 * ostride]) = tre2_0_0 - tre2_0_1;
	       c_im(out[45 * ostride]) = tim2_0_0 - tim2_0_1;
	       c_re(out[29 * ostride]) = tre2_1_0 - tim2_1_1;
	       c_im(out[29 * ostride]) = tim2_1_0 + tre2_1_1;
	       c_re(out[61 * ostride]) = tre2_1_0 + tim2_1_1;
	       c_im(out[61 * ostride]) = tim2_1_0 - tre2_1_1;
	  }
     }
     {
	  FFTW_REAL tre1_0_0;
	  FFTW_REAL tim1_0_0;
	  FFTW_REAL tre1_0_1;
	  FFTW_REAL tim1_0_1;
	  FFTW_REAL tre1_0_2;
	  FFTW_REAL tim1_0_2;
	  FFTW_REAL tre1_0_3;
	  FFTW_REAL tim1_0_3;
	  FFTW_REAL tre1_1_0;
	  FFTW_REAL tim1_1_0;
	  FFTW_REAL tre1_1_1;
	  FFTW_REAL tim1_1_1;
	  FFTW_REAL tre1_1_2;
	  FFTW_REAL tim1_1_2;
	  FFTW_REAL tre1_1_3;
	  FFTW_REAL tim1_1_3;
	  {
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre0_6_4 + tim0_6_4);
	       tim2_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre0_6_4 - tim0_6_4);
	       tre1_0_0 = tre0_6_0 - tre2_1_0;
	       tim1_0_0 = tim0_6_0 + tim2_1_0;
	       tre1_1_0 = tre0_6_0 + tre2_1_0;
	       tim1_1_0 = tim0_6_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = (((FFTW_REAL) FFTW_K831469612) * tre0_6_1) - (((FFTW_REAL) FFTW_K555570233) * tim0_6_1);
	       tim2_0_0 = (((FFTW_REAL) FFTW_K831469612) * tim0_6_1) + (((FFTW_REAL) FFTW_K555570233) * tre0_6_1);
	       tre2_1_0 = (((FFTW_REAL) FFTW_K980785280) * tre0_6_5) + (((FFTW_REAL) FFTW_K195090322) * tim0_6_5);
	       tim2_1_0 = (((FFTW_REAL) FFTW_K195090322) * tre0_6_5) - (((FFTW_REAL) FFTW_K980785280) * tim0_6_5);
	       tre1_0_1 = tre2_0_0 - tre2_1_0;
	       tim1_0_1 = tim2_0_0 + tim2_1_0;
	       tre1_1_1 = tre2_0_0 + tre2_1_0;
	       tim1_1_1 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = (((FFTW_REAL) FFTW_K382683432) * tre0_6_2) - (((FFTW_REAL) FFTW_K923879532) * tim0_6_2);
	       tim2_0_0 = (((FFTW_REAL) FFTW_K382683432) * tim0_6_2) + (((FFTW_REAL) FFTW_K923879532) * tre0_6_2);
	       tre2_1_0 = (((FFTW_REAL) FFTW_K382683432) * tim0_6_6) - (((FFTW_REAL) FFTW_K923879532) * tre0_6_6);
	       tim2_1_0 = (((FFTW_REAL) FFTW_K923879532) * tim0_6_6) + (((FFTW_REAL) FFTW_K382683432) * tre0_6_6);
	       tre1_0_2 = tre2_0_0 + tre2_1_0;
	       tim1_0_2 = tim2_0_0 - tim2_1_0;
	       tre1_1_2 = tre2_0_0 - tre2_1_0;
	       tim1_1_2 = tim2_0_0 + tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = (((FFTW_REAL) FFTW_K195090322) * tre0_6_3) + (((FFTW_REAL) FFTW_K980785280) * tim0_6_3);
	       tim2_0_0 = (((FFTW_REAL) FFTW_K980785280) * tre0_6_3) - (((FFTW_REAL) FFTW_K195090322) * tim0_6_3);
	       tre2_1_0 = (((FFTW_REAL) FFTW_K831469612) * tim0_6_7) - (((FFTW_REAL) FFTW_K555570233) * tre0_6_7);
	       tim2_1_0 = (((FFTW_REAL) FFTW_K555570233) * tim0_6_7) + (((FFTW_REAL) FFTW_K831469612) * tre0_6_7);
	       tre1_0_3 = tre2_1_0 - tre2_0_0;
	       tim1_0_3 = tim2_0_0 - tim2_1_0;
	       tre1_1_3 = (-(tre2_0_0 + tre2_1_0));
	       tim1_1_3 = tim2_0_0 + tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_0_1;
	       FFTW_REAL tim2_0_1;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       FFTW_REAL tre2_1_1;
	       FFTW_REAL tim2_1_1;
	       tre2_0_0 = tre1_0_0 + tre1_0_2;
	       tim2_0_0 = tim1_0_0 + tim1_0_2;
	       tre2_1_0 = tre1_0_0 - tre1_0_2;
	       tim2_1_0 = tim1_0_0 - tim1_0_2;
	       tre2_0_1 = tre1_0_1 + tre1_0_3;
	       tim2_0_1 = tim1_0_1 + tim1_0_3;
	       tre2_1_1 = tre1_0_1 - tre1_0_3;
	       tim2_1_1 = tim1_0_1 - tim1_0_3;
	       c_re(out[6 * ostride]) = tre2_0_0 + tre2_0_1;
	       c_im(out[6 * ostride]) = tim2_0_0 + tim2_0_1;
	       c_re(out[38 * ostride]) = tre2_0_0 - tre2_0_1;
	       c_im(out[38 * ostride]) = tim2_0_0 - tim2_0_1;
	       c_re(out[22 * ostride]) = tre2_1_0 - tim2_1_1;
	       c_im(out[22 * ostride]) = tim2_1_0 + tre2_1_1;
	       c_re(out[54 * ostride]) = tre2_1_0 + tim2_1_1;
	       c_im(out[54 * ostride]) = tim2_1_0 - tre2_1_1;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_0_1;
	       FFTW_REAL tim2_0_1;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       FFTW_REAL tre2_1_1;
	       FFTW_REAL tim2_1_1;
	       tre2_0_0 = tre1_1_0 - tim1_1_2;
	       tim2_0_0 = tim1_1_0 + tre1_1_2;
	       tre2_1_0 = tre1_1_0 + tim1_1_2;
	       tim2_1_0 = tim1_1_0 - tre1_1_2;
	       {
		    FFTW_REAL tre3_0_0;
		    FFTW_REAL tim3_0_0;
		    FFTW_REAL tre3_1_0;
		    FFTW_REAL tim3_1_0;
		    tre3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_1 - tim1_1_1);
		    tim3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tim1_1_1 + tre1_1_1);
		    tre3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 + tim1_1_3);
		    tim3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 - tim1_1_3);
		    tre2_0_1 = tre3_0_0 - tre3_1_0;
		    tim2_0_1 = tim3_0_0 + tim3_1_0;
		    tre2_1_1 = tre3_0_0 + tre3_1_0;
		    tim2_1_1 = tim3_0_0 - tim3_1_0;
	       }
	       c_re(out[14 * ostride]) = tre2_0_0 + tre2_0_1;
	       c_im(out[14 * ostride]) = tim2_0_0 + tim2_0_1;
	       c_re(out[46 * ostride]) = tre2_0_0 - tre2_0_1;
	       c_im(out[46 * ostride]) = tim2_0_0 - tim2_0_1;
	       c_re(out[30 * ostride]) = tre2_1_0 - tim2_1_1;
	       c_im(out[30 * ostride]) = tim2_1_0 + tre2_1_1;
	       c_re(out[62 * ostride]) = tre2_1_0 + tim2_1_1;
	       c_im(out[62 * ostride]) = tim2_1_0 - tre2_1_1;
	  }
     }
     {
	  FFTW_REAL tre1_0_0;
	  FFTW_REAL tim1_0_0;
	  FFTW_REAL tre1_0_1;
	  FFTW_REAL tim1_0_1;
	  FFTW_REAL tre1_0_2;
	  FFTW_REAL tim1_0_2;
	  FFTW_REAL tre1_0_3;
	  FFTW_REAL tim1_0_3;
	  FFTW_REAL tre1_1_0;
	  FFTW_REAL tim1_1_0;
	  FFTW_REAL tre1_1_1;
	  FFTW_REAL tim1_1_1;
	  FFTW_REAL tre1_1_2;
	  FFTW_REAL tim1_1_2;
	  FFTW_REAL tre1_1_3;
	  FFTW_REAL tim1_1_3;
	  {
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_1_0 = (((FFTW_REAL) FFTW_K923879532) * tre0_7_4) + (((FFTW_REAL) FFTW_K382683432) * tim0_7_4);
	       tim2_1_0 = (((FFTW_REAL) FFTW_K382683432) * tre0_7_4) - (((FFTW_REAL) FFTW_K923879532) * tim0_7_4);
	       tre1_0_0 = tre0_7_0 - tre2_1_0;
	       tim1_0_0 = tim0_7_0 + tim2_1_0;
	       tre1_1_0 = tre0_7_0 + tre2_1_0;
	       tim1_1_0 = tim0_7_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = (((FFTW_REAL) FFTW_K773010453) * tre0_7_1) - (((FFTW_REAL) FFTW_K634393284) * tim0_7_1);
	       tim2_0_0 = (((FFTW_REAL) FFTW_K773010453) * tim0_7_1) + (((FFTW_REAL) FFTW_K634393284) * tre0_7_1);
	       tre2_1_0 = (((FFTW_REAL) FFTW_K290284677) * tim0_7_5) - (((FFTW_REAL) FFTW_K956940335) * tre0_7_5);
	       tim2_1_0 = (((FFTW_REAL) FFTW_K956940335) * tim0_7_5) + (((FFTW_REAL) FFTW_K290284677) * tre0_7_5);
	       tre1_0_1 = tre2_0_0 + tre2_1_0;
	       tim1_0_1 = tim2_0_0 - tim2_1_0;
	       tre1_1_1 = tre2_0_0 - tre2_1_0;
	       tim1_1_1 = tim2_0_0 + tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = (((FFTW_REAL) FFTW_K195090322) * tre0_7_2) - (((FFTW_REAL) FFTW_K980785280) * tim0_7_2);
	       tim2_0_0 = (((FFTW_REAL) FFTW_K195090322) * tim0_7_2) + (((FFTW_REAL) FFTW_K980785280) * tre0_7_2);
	       tre2_1_0 = (((FFTW_REAL) FFTW_K831469612) * tim0_7_6) - (((FFTW_REAL) FFTW_K555570233) * tre0_7_6);
	       tim2_1_0 = (((FFTW_REAL) FFTW_K555570233) * tim0_7_6) + (((FFTW_REAL) FFTW_K831469612) * tre0_7_6);
	       tre1_0_2 = tre2_0_0 + tre2_1_0;
	       tim1_0_2 = tim2_0_0 - tim2_1_0;
	       tre1_1_2 = tre2_0_0 - tre2_1_0;
	       tim1_1_2 = tim2_0_0 + tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       tre2_0_0 = (((FFTW_REAL) FFTW_K471396736) * tre0_7_3) + (((FFTW_REAL) FFTW_K881921264) * tim0_7_3);
	       tim2_0_0 = (((FFTW_REAL) FFTW_K881921264) * tre0_7_3) - (((FFTW_REAL) FFTW_K471396736) * tim0_7_3);
	       tre2_1_0 = (((FFTW_REAL) FFTW_K098017140) * tre0_7_7) + (((FFTW_REAL) FFTW_K995184726) * tim0_7_7);
	       tim2_1_0 = (((FFTW_REAL) FFTW_K098017140) * tim0_7_7) - (((FFTW_REAL) FFTW_K995184726) * tre0_7_7);
	       tre1_0_3 = tre2_1_0 - tre2_0_0;
	       tim1_0_3 = tim2_0_0 + tim2_1_0;
	       tre1_1_3 = (-(tre2_0_0 + tre2_1_0));
	       tim1_1_3 = tim2_0_0 - tim2_1_0;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_0_1;
	       FFTW_REAL tim2_0_1;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       FFTW_REAL tre2_1_1;
	       FFTW_REAL tim2_1_1;
	       tre2_0_0 = tre1_0_0 + tre1_0_2;
	       tim2_0_0 = tim1_0_0 + tim1_0_2;
	       tre2_1_0 = tre1_0_0 - tre1_0_2;
	       tim2_1_0 = tim1_0_0 - tim1_0_2;
	       tre2_0_1 = tre1_0_1 + tre1_0_3;
	       tim2_0_1 = tim1_0_1 + tim1_0_3;
	       tre2_1_1 = tre1_0_1 - tre1_0_3;
	       tim2_1_1 = tim1_0_1 - tim1_0_3;
	       c_re(out[7 * ostride]) = tre2_0_0 + tre2_0_1;
	       c_im(out[7 * ostride]) = tim2_0_0 + tim2_0_1;
	       c_re(out[39 * ostride]) = tre2_0_0 - tre2_0_1;
	       c_im(out[39 * ostride]) = tim2_0_0 - tim2_0_1;
	       c_re(out[23 * ostride]) = tre2_1_0 - tim2_1_1;
	       c_im(out[23 * ostride]) = tim2_1_0 + tre2_1_1;
	       c_re(out[55 * ostride]) = tre2_1_0 + tim2_1_1;
	       c_im(out[55 * ostride]) = tim2_1_0 - tre2_1_1;
	  }
	  {
	       FFTW_REAL tre2_0_0;
	       FFTW_REAL tim2_0_0;
	       FFTW_REAL tre2_0_1;
	       FFTW_REAL tim2_0_1;
	       FFTW_REAL tre2_1_0;
	       FFTW_REAL tim2_1_0;
	       FFTW_REAL tre2_1_1;
	       FFTW_REAL tim2_1_1;
	       tre2_0_0 = tre1_1_0 - tim1_1_2;
	       tim2_0_0 = tim1_1_0 + tre1_1_2;
	       tre2_1_0 = tre1_1_0 + tim1_1_2;
	       tim2_1_0 = tim1_1_0 - tre1_1_2;
	       {
		    FFTW_REAL tre3_0_0;
		    FFTW_REAL tim3_0_0;
		    FFTW_REAL tre3_1_0;
		    FFTW_REAL tim3_1_0;
		    tre3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_1 - tim1_1_1);
		    tim3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tim1_1_1 + tre1_1_1);
		    tre3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 + tim1_1_3);
		    tim3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 - tim1_1_3);
		    tre2_0_1 = tre3_0_0 - tre3_1_0;
		    tim2_0_1 = tim3_0_0 + tim3_1_0;
		    tre2_1_1 = tre3_0_0 + tre3_1_0;
		    tim2_1_1 = tim3_0_0 - tim3_1_0;
	       }
	       c_re(out[15 * ostride]) = tre2_0_0 + tre2_0_1;
	       c_im(out[15 * ostride]) = tim2_0_0 + tim2_0_1;
	       c_re(out[47 * ostride]) = tre2_0_0 - tre2_0_1;
	       c_im(out[47 * ostride]) = tim2_0_0 - tim2_0_1;
	       c_re(out[31 * ostride]) = tre2_1_0 - tim2_1_1;
	       c_im(out[31 * ostride]) = tim2_1_0 + tre2_1_1;
	       c_re(out[63 * ostride]) = tre2_1_0 + tim2_1_1;
	       c_im(out[63 * ostride]) = tim2_1_0 - tre2_1_1;
	  }
     }
}
