/***********************************************************************/
/*                                                                     */
/*                           Objective Caml                            */
/*                                                                     */
/*  Xavier Leroy and Pascal Cuoq, projet Cristal, INRIA Rocquencourt   */
/*                                                                     */
/*  Copyright 1996 Institut National de Recherche en Informatique et   */
/*  Automatique.  Distributed only by permission.                      */
/*                                                                     */
/***********************************************************************/

/* $Id: getpeername.c,v 1.1 1996/09/04 14:17:29 xleroy Exp $ */

#include <mlvalues.h>
#include "unixsupport.h"
#include "socketaddr.h"

value unix_getpeername(sock)          /* ML */
     value sock;
{
  int retcode;

  sock_addr_len = sizeof(sock_addr);
  retcode = getpeername(_get_osfhandle(Int_val(sock)), 
                        &sock_addr.s_gen, &sock_addr_len);
  if (retcode == -1) {
    _dosmaperr(WSAGetLastError());
    uerror("getpeername", Nothing);
  }
  return alloc_sockaddr();
}
