/***********************************************************************/
/*                                                                     */
/*                           Objective Caml                            */
/*                                                                     */
/*            Xavier Leroy, projet Cristal, INRIA Rocquencourt         */
/*                                                                     */
/*  Copyright 1996 Institut National de Recherche en Informatique et   */
/*  Automatique.  Distributed only by permission.                      */
/*                                                                     */
/***********************************************************************/

/* $Id: read.c,v 1.5 1996/09/04 14:15:03 xleroy Exp $ */

#include <mlvalues.h>
#include "unixsupport.h"

value unix_read(fd, buf, ofs, len) /* ML */
     value fd, buf, ofs, len;
{
  int ret;
  buf = unix_freeze_buffer(buf);
  enter_blocking_section();
  ret = read(Int_val(fd), &Byte(buf, Long_val(ofs)), Int_val(len));
  leave_blocking_section();
  if (ret == -1) uerror("read", Nothing);
  return Val_int(ret);
}
