/* --------------------------------------------------------------------*/
/*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \   /  '                               */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome. Send them to                                          */
/*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
/*-------------------------------------------------------------------- */
/*=====================================================================*/
/*    serrano/prgm/project/bigloo/tools/if_mach.c                      */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Tue Aug  8 08:17:21 1995                          */
/*    Last change :  Fri Aug 23 09:16:22 1996 (serrano)                */
/*    -------------------------------------------------------------    */
/*    Execute a command on specific architecture.                      */
/*=====================================================================*/

/*---------------------------------------------------------------------*/
/*    Sparc ...                                                        */
/*---------------------------------------------------------------------*/
#if( defined( sparc ) )
#   define MACH_TYPE "sparc"
#   include <errno.h>
#   if( defined( ECHRNG ) )
#      define OS_TYPE "sunos5"
#   else
#      define OS_TYPE "sunos4"
#   endif
#endif

/*---------------------------------------------------------------------*/
/*    Alpha                                                            */
/*---------------------------------------------------------------------*/
#if( defined( __alpha ) )
#  define MACH_TYPE "alpha"
#  if( defined( __osf__ ) )
#     define OS_TYPE "osf"
#  endif
#endif

#if( !defined( MACH_TYPE ) )
#   define MACH_TYPE ""
#endif

#if( !defined( OS_TYPE ) )
#   define OS_TYPE ""
#endif

/*---------------------------------------------------------------------*/
/*    void                                                             */
/*    usage ...                                                        */
/*---------------------------------------------------------------------*/
void
usage()
{
   fputs( "Usage: if_mach <mach-type> <os-type> <command>" );
}

/*---------------------------------------------------------------------*/
/*    int                                                              */
/*    main ...                                                         */
/*---------------------------------------------------------------------*/
int
main( int argc, char **argv )
{
   if( argc < 4 )
   {
      usage();
      exit( -1 );
   }
   else
   {
      if( strcmp( MACH_TYPE, argv[1] ) )
         exit( 0 );
      else
      if( strcmp( OS_TYPE, "" ) &&
	  strcmp( argv[2], "" ) &&
	  strcmp( OS_TYPE, argv[2] ) )
         exit( 0 );
      else
      {
	 execvp( argv[3], argv+3 );
	 perror( "Couldn't execute" );
      }
   }
}

