;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime1.9/Rgc/tree.scm              */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Apr  3 14:24:53 1992                          */
;*    Last change :  Wed Feb 19 13:19:23 1997 (serrano)                */
;*                                                                     */
;*    L'evaluation de l'arbre syntaxique                               */
;*---------------------------------------------------------------------*/
 
;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __rgc_tree
   
   (include "Rgc/tree.sch")

   (import  (__error                   "Llib/error.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__structure               "Llib/struct.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__r4_numbers_6_5          "Ieee/number.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_numbers_6_5_flonum   "Ieee/flonum.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_input_6_10_2         "Ieee/input.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_ports_6_10_1         "Ieee/port.scm")
	    (__r4_output_6_10_3        "Ieee/output.scm")
	    (__rgc                     "Rgc/runtime.scm")
   	    (__evenv                   "Eval/evenv.scm"))

   (export  (eval-tree   tree na)
	    (vector-grow vec len)))

(define *pos* '())

;*---------------------------------------------------------------------*/
;*    eval-tree ...                                                    */
;*    tree x int --> pos x pos* x store x env x vector x vector        */ 
;*    -------------------------------------------------------------    */
;*    Les structures de constructions de l'arbre et du dfa sont:       */
;*        pos: position dans l'arbre syntaxique                        */
;*        position:   pos       --->  lettre                           */
;*        f-env:      pos       --->  location                         */
;*        f-store:    location  --->  pos*                             */
;*    La plus part des fonctions reg-??? font des effets de bords sur  */
;*    walk. La valeur de walk est juste en entree et doit etre         */
;*    ajustee a la sortie. Toutes fois certaines fonctions ne font     */
;*    que consulter cette variable.                                    */
;*    -------------------------------------------------------------    */
;*    fast-union, comme son nom l'indique calcule l'union entre 2      */
;*    listes. fast-union utilise fast-union-v. fast-union-v croit      */
;*    comme f-env.                                                     */
;*---------------------------------------------------------------------*/
(define (eval-tree tree nb-usr-action)
   (let* ((store-indice -1)
	  (env-indice   -1)
	  (walk         #f)
	  (store-len    1024)
	  (env-len      1200)
	  (union-vect   (make-vector env-len #f))
	  (position     (make-vector env-len '()))
	  (f-env        (make-vector env-len '()))
	  (f-store      (make-vector store-len '()))
	  (t-trap       (make-vector nb-usr-action '()))
	  (*rule-num*   (-fx nb-usr-action 1)))
;*--- double-position! ------------------------------------------------*/
      (define (double-position!)
	 (let ((old-env-len env-len))
	    (set! env-len (*fx 2 env-len))
	    (set! position (vector-grow position env-len))
	    (set! *pos* position)
	    (set! f-env (vector-grow f-env env-len))
	    (set! union-vect (vector-grow/filler union-vect env-len #f))))
;*--- get-new-pos -----------------------------------------------------*/
      (define (get-new-pos)
	 (set! env-indice (+fx 1 env-indice))
	 (if (=fx env-indice env-len)
	     (double-position!))
	 env-indice)
;*--- get-location ----------------------------------------------------*/
      (define (get-location)
	 (set! store-indice (+fx 1 store-indice))
	 (if (=fx store-indice store-len)
	     (begin
		(set! f-store (vector-grow f-store (*fx 2 store-len)))
		(let loop ((i store-len))
		   (if (=fx i (*fx 2 store-len))
		       '()
		       (begin
			  (vector-set! f-store i '())
			  (loop (+fx i 1)))))
		(set! store-len (*fx 2 store-len))))
	 store-indice)
;*--- meaning-tree ----------------------------------------------------*/
      (define (meaning-tree exp)
	 (case (car exp)
	    ((or)
	     (let* ((a1 (meaning-tree (cadr exp)))
		    (a2 (meaning-tree (caddr exp))))
		(reg-or a1 a2)))
	    ((concat)
	     (let ((a1 'dummy)
		   (a2 'dummy)
		   (waux walk))
		(set! walk #f)
		(set! a1 (meaning-tree (cadr exp)))
		(set! walk waux)
		(set! a2 (meaning-tree (caddr exp)))
		(concat a1 a2)))
	    ((concat-char)
	     (let ((a1 'dummy)
		   (a2 'dummy)
		   (waux walk))
		(set! walk #f)
		(set! a1 (meaning-tree (cadr exp)))
		(set! walk waux)
		(set! a2 (meaning-tree (caddr exp)))
		(concat-char a1 a2)))		
	    ((in)
	     (reg-in (cadr exp)))
	    ((char)
	     (reg-char (cadr exp)))
	    ((*)
	     (set! walk #f)
	     (reg-* (meaning-tree (cadr exp))))
	    ((+)
	     (set! walk #f)
	     (reg-+ (meaning-tree (cadr exp))))
	    ((epsilon)
	     (reg-epsilon))
	    ((end)
	     (reg-end (cadr exp)))
	    ((trap)
	     (reg-trap (cadr exp)
		       (meaning-tree (caddr exp))))
	    (else
	     (error "regular-grammar" "Unknown function" (car exp)))))
;*--- reg-or ----------------------------------------------------------*/
      (define (reg-or n1 n2)
	 (let ((node (make-node)))
	    (node-set! node
		       (append (node-firstpos n1) (node-firstpos n2))
		       (append (node-lastpos n1) (node-lastpos n2))
		       (or (node-nullable? n1) (node-nullable? n2))
		       (append (node-f-for-f n1) (node-f-for-f n2))
		       (append (node-l-for-f n1) (node-l-for-f n2)))
	    node))
;*--- concat ----------------------------------------------------------*/
      (define (concat n1 n2)
	 (let ((node (make-node)))
	    ;; we compute follow
	    (for-each (lambda (i)
			 (let ( (location (vector-ref f-env i)) )
			    (vector-set! f-store
					 location
					 (append (vector-ref f-store location)
						 (node-firstpos n2)))))
		      (node-l-for-f n1))
	    ;; we compute the result root
	    (node-set! node
		       (if (node-nullable? n1)
			   (append (node-firstpos n1) (node-firstpos n2))
			   (node-firstpos n1))
		       (if (node-nullable? n2)
			   (append (node-lastpos n2) (node-lastpos n1))
			   (node-lastpos n2))
		       (and (node-nullable? n1) (node-nullable? n2))
		       (if (node-nullable? n1)
			   (append (node-f-for-f n1) (node-f-for-f n2))
			   (node-f-for-f n1))
		       (if (node-nullable? n2)
			   (append (node-l-for-f n2) (node-l-for-f n1))
			   (node-l-for-f n2)))
	    node))
;*--- concat-char -----------------------------------------------------*/
      (define (concat-char n1 n2)
	 (let ((node (make-node)))
	    ;; we compute follow
	    (let ((i (car (node-l-for-f n1))))
	       (let ((location (vector-ref f-env i)))
		  (vector-set! f-store
			       location
			       (append (vector-ref f-store location)
				       (node-firstpos n2)))))
	    ;; we compute the resulting root
	    (node-set! node (node-firstpos n1) 
		       (node-lastpos n2) 
		       #f
		       (node-f-for-f n1)
		       (node-l-for-f n2))
	    node))
;*--- reg-in ----------------------------------------------------------*/
      (define (reg-in char*)
	 (if (null? (cdr char*))
	     (reg-char (car char*))
	     (let* ((node (reg-char (car char*)))
		    (pos* (let l ((c   (cdr char*))
				  (acc '()))
			     (if (null? c)
				 (reverse! acc)
				 (l (cdr c) (cons (get-new-pos) acc))))))
		(node-firstpos-set! node (append (node-firstpos node) pos*))
		(node-lastpos-set!  node (append (node-lastpos node) pos*))
		(let loop ((c*   (cdr char*))
			   (pos* pos*))
		   (if (null? c*)
		       node
		       (begin
			  (let ((pos (car pos*)))
			     (vector-set! position pos (car c*))
			     (vector-set! f-env pos walk))
			  (loop (cdr c*) (cdr pos*))))))))
;*--- reg-char --------------------------------------------------------*/
      (define (reg-char char)
	 (let ((node (make-node))
	       (pos  (get-new-pos)))
	    (vector-set! position pos char)
	    (if walk
		(begin
		   (vector-set! f-env pos walk)
		   (node-set! node (list pos) (list pos) #f '() '()))
		(let ((location (get-location)))
		   (vector-set! f-env pos location)
		   (vector-set! f-store location '())
		   (set! walk location)
		   (node-set! node
			      (list pos)
			      (list pos)
			      #f
			      (list pos)
			      (list pos))))
	    node))
;*--- compute-follow-*+01 ---------------------------------------------*/
      (define (compute-follow-*+01 node)
	 (let ((firstpos (node-firstpos node)))
	    (for-each 
	     (lambda (i)
		(let ((location (vector-ref f-env i)))
		   (vector-set! f-store
				location
				(fast-union (vector-ref f-store location)
					    firstpos
					    union-vect))))
	     (node-l-for-f node))))
;*--- reg-* -----------------------------------------------------------*/
      (define (reg-* n) 
	 (let ((node (make-node)))
	    (compute-follow-*+01 n)
	    (set! walk #f)
	    (node-set! node (node-firstpos n) 
		       (node-lastpos n) 
		       #t 
		       (node-f-for-f n)
		       (node-l-for-f n))
	    node))
;*--- reg-+ -----------------------------------------------------------*/
      (define (reg-+ n)
	 (let ((node (make-node)))
	    (compute-follow-*+01 n)
	    (set! walk #f)
	    (node-set! node (node-firstpos n) 
		       (node-lastpos n) 
		       (node-nullable? n)
		       (node-f-for-f n)
		       (node-l-for-f n))
	    node))
;*--- reg-epsilon -----------------------------------------------------*/
      (define (reg-epsilon)
	 (let ((node (make-node))
	       (pos  (get-new-pos)))
	    (vector-set! position pos 'epsilon)
	    (if walk
		(begin
		   (vector-set! f-env  pos walk)
		   (node-set! node (list pos) (list pos) #t '() '()))
		(let ((location (get-location)))
		   (vector-set! f-env pos location)
		   (vector-set! f-store location '())
		   (set! walk location)
		   (node-set! node
			      (list pos)
			      (list pos)
			      #t
			      (list pos)
			      (list pos))))
	    node))
;*--- reg-end ---------------------------------------------------------*/
      (define (reg-end num)
	 (set! *rule-num* (-fx *rule-num* 1))
	 (reg-char num))
;*--- reg-trap --------------------------------------------------------*/
;*     C'est tres crade mais le numero de la regle qu'on examine est   */
;*     ++ le numero de la regle precedante. Donc des qu'on tombe sur   */
;*     red-end on sauve le nb dans une var globale.                    */
;*     Deplus, comme l'eval se fait de gauche a droite et qu'une regle */
;*     est de la forme (concat exp (marker num)). Il ajouter un pour   */
;*     avoir la vraie valeur de *rule-num*.                            */
;*---------------------------------------------------------------------*/
      (define (reg-trap trap e)
	 (vector-set! t-trap 
		      *rule-num*
		      (cons trap (vector-ref t-trap *rule-num*)))
	 e)
      ;; Attention le let est indispensable car tree
      ;; fait des effets de bords
      ;; sur position f-store...
      (set! *pos* position)
      (let ((tree! (meaning-tree tree)))
	 (vector (node-firstpos tree!)
		 position 
		 f-store 
		 f-env 
		 union-vect
		 t-trap))))


;*---------------------------------------------------------------------*/
;*    node-set! ...                                                    */
;*---------------------------------------------------------------------*/
(define (node-set! node first last nullable? f-for-f l-for-f)
   (begin
      (node-firstpos-set!  node first)
      (node-lastpos-set!   node last)
      (node-nullable?-set! node nullable?) 
      (node-f-for-f-set!   node f-for-f)
      (node-l-for-f-set!   node l-for-f)))

;*---------------------------------------------------------------------*/
;*    vector-grow ...                                                  */
;*---------------------------------------------------------------------*/
(define (vector-grow vector len)
   (let ((res     (make-vector len '()))
	 (old-len (vector-length vector)))
      (let loop ((i 0))
	 (if (=fx i old-len)
	     res
	     (begin
		(vector-set! res i (vector-ref vector i))
		(loop (+fx i 1)))))))

;*---------------------------------------------------------------------*/
;*    vector-grow/filler ...                                           */
;*---------------------------------------------------------------------*/
(define (vector-grow/filler vector len filler)
   (let ((res     (make-vector len filler))
	 (old-len (vector-length vector)))
      (let loop ((i 0))
	 (if (=fx i old-len)
	     res
	     (begin
		(vector-set! res i (vector-ref vector i))
		(loop (+fx i 1)))))))

;*---------------------------------------------------------------------*/
;*    fast-union ...                                                   */
;*    -------------------------------------------------------------    */
;*    We compute the union of two lists using a pre-allocated          */
;*    vector (filled with #f).                                         */
;*---------------------------------------------------------------------*/
(define (fast-union l1 l2 vect)
   (debug-check-vect? vect)
   (cond
      ((null? l1)
       l2)
      ((null? l2)
       l1)
      (else
       (let ((max (car l1))
	     (min (car l1)))
	  ;; we set the min and max of the two lists and fill the
	  ;; vect vector with #t
	  (labels ((min-max! (l) (if (null? l)
				     '()
				     (let ((c (car l)))
					(cond
					   ((<fx c min)
					    (set! min c))
					   ((>fx c max)
					    (set! max c)))
					(vector-set! vect c #t)
					(min-max! (cdr l))))))
	     (min-max! l1)
	     (min-max! l2))
	  ;; we scan the lists
	  (let loop ((i   max)
		     (acc '()))
	     (if (<fx i min)
		 acc
		 (if (vector-ref vect i)
		     (begin
			(vector-set! vect i #f)
			(loop (-fx i 1) (cons i acc)))
		     (loop (-fx i 1) acc))))))))

(define (my-vector-set! vect o val)
   (if (and (eq? vect *pos*) (=fx o 2400))
       (print "Je set a 2400: " val))
   (vector-set! vect o val))
       
;*---------------------------------------------------------------------*/
;*    check-vect? ...                                                  */
;*---------------------------------------------------------------------*/
(define (debug-check-vect? vect)
   (let loop ((i (-fx (vector-length vect) 1)))
      (cond
	 ((=fx i -1)
	  'done)
	 ((vector-ref vect i)
	  (warning "debug-check-vect?:" "non #f vector:" vect))
	 (else
	  (loop (-fx i 1))))))
      
