;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;; ---------------------------------------------------------------------- ;;
;; FICHIER               : util.scm                                       ;;
;; DATE DE CREATION      : Thu Jun 29 15:11:17 1995                       ;;
;; DERNIERE MODIFICATION : Thu Jun 29 15:12:47 1995                       ;;
;; ---------------------------------------------------------------------- ;;
;; Copyright (c) 1995 Dominique Boucher                                   ;;
;; ---------------------------------------------------------------------- ;;
;; Quelques fonctions utilitaires ....                                    ;;
;; ---------------------------------------------------------------------- ;;

(module __lalr_util

   (import (__error                   "Llib/error.scm"))

   (use    (__type                    "Llib/type.scm")
		
	   (__bigloo                  "Llib/bigloo.scm")
	   (__tvector                 "Llib/tvector.scm")
	   (__structure               "Llib/struct.scm")
	   (__tvector                 "Llib/tvector.scm")
	   (__rgc                     "Rgc/runtime.scm")
	   (__r4_numbers_6_5          "Ieee/number.scm")
	   (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	   (__r4_numbers_6_5_flonum   "Ieee/flonum.scm")
	   (__r4_characters_6_6       "Ieee/char.scm")
	   (__r4_equivalence_6_2      "Ieee/equiv.scm")
	   (__r4_booleans_6_1         "Ieee/boolean.scm")
	   (__r4_symbols_6_4          "Ieee/symbol.scm")
	   (__r4_strings_6_7          "Ieee/string.scm")
	   (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	   (__r4_input_6_10_2         "Ieee/input.scm")
	   (__r4_control_features_6_9 "Ieee/control.scm")
	   (__r4_vectors_6_8          "Ieee/vector.scm")
	   (__r4_ports_6_10_1         "Ieee/port.scm")
	   (__r4_output_6_10_3        "Ieee/output.scm")
	   (__evenv                   "Eval/evenv.scm"))
	
   (export (pos-in-list x lst)
	   (sunion lst1 lst2)
	   (sinsert elem lst)
	   (filter p lst)))

(define (pos-in-list x lst)
  (let loop ((lst lst) (i 0))
    (cond ((not (pair? lst))    #f)
	  ((equal? (car lst) x) i)
	  (else                 (loop (cdr lst) (+fx i 1))))))

(define (sunion lst1 lst2)		; union of sorted lists
  (let loop ((L1 lst1)
	     (L2 lst2))
    (cond ((null? L1)    L2)
	  ((null? L2)    L1)
	  (else 
	   (let ((x (car L1)) (y (car L2)))
	     (cond
	      ((>fx x y)
	       (cons y (loop L1 (cdr L2))))
	      ((<fx x y)
	       (cons x (loop (cdr L1) L2)))
	      (else
	       (loop (cdr L1) L2))
	      ))))))

(define (sinsert elem lst)
  (let loop ((l1 lst))
    (if (null? l1) 
	(cons elem l1)
	(let ((x (car l1)))
	  (cond ((<fx elem x)
		 (cons elem l1))
		((>fx elem x)
		 (cons x (loop (cdr l1))))
		(else 
		 l1))))))

(define (filter p lst)
  (let loop ((l lst))
    (if (null? l)
	'()
	(let ((x (car l)) (y (cdr l)))
	(if (p x)
	    (cons x (loop y))
	    (loop y))))))

;------------------------------------------------------------------------------
