;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime1.9/Ieee/symbol.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Jul  4 15:05:26 1992                          */
;*    Last change :  Fri Sep  6 15:03:40 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    6.4. Symbols (page 18, r4)                                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __r4_symbols_6_4

   (import  (__error                   "Llib/error.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")

	    (__evenv                   "Eval/evenv.scm"))

   (foreign (macro bool    c-symbol?        (obj)        "SYMBOLP")
	    (symbol        c-string->symbol (string)     "string_to_symbol")
	    (macro bstring c-symbol->string (symbol)     "SYMBOL_TO_STRING")
	    (macro obj     c-symbol-plist   (symbol)     "GET_SYMBOL_PLIST")
	    (macro obj     set-symbol-plist (symbol obj) "SET_SYMBOL_PLIST")
	    (macro bool    symbol-exists?   (string)     "symbol_exists_p"))
   
   (export  (inline symbol?::bool           ::obj)
	    (inline symbol->string::bstring ::symbol)
	    (inline string->symbol::symbol  ::bstring)
	    (symbol-append::symbol          . symbols)
	    (symbol-plist::obj              ::symbol)
	    (getprop                        ::symbol ::symbol)
	    (putprop!                       ::symbol ::symbol ::obj)
	    (remprop!                       ::symbol ::symbol)
	    gensym)
   
   (pragma  (c-symbol? (predicate-of symbol) no-cfa-top)
	    (symbol? side-effect-free)
	    (c-string->symbol no-cfa-top)
	    (string->symbol no-cfa-top)
	    (getprop side-effect-free)))
 
;*---------------------------------------------------------------------*/
;*    symbol? ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (symbol? obj)
   (c-symbol? obj))

;*---------------------------------------------------------------------*/
;*    symbol->string ...                                               */
;*---------------------------------------------------------------------*/
(define-inline (symbol->string symbol)
   (c-symbol->string symbol))

;*---------------------------------------------------------------------*/
;*    string->symbol ...                                               */
;*---------------------------------------------------------------------*/
(define-inline (string->symbol string)
   (c-string->symbol string))

;*---------------------------------------------------------------------*/
;*    symbol-append ...                                                */
;*---------------------------------------------------------------------*/
(define (symbol-append . list)
   (string->symbol (if (null? list)
		       ""
		       (let loop ((list list))
			  (if (null? (cdr list))
			      (symbol->string (car list))
			      (c-string-append (symbol->string (car list))
					       (loop (cdr list))))))))

;*---------------------------------------------------------------------*/
;*    gensym ...                                                       */
;*---------------------------------------------------------------------*/
(define gensym
   (let ((counter 999))
      (lambda string
	 (let ((string (cond
			  ((null? string)
			   "g")
			  ((symbol? (car string))
			   (symbol->string (car string)))
			  ((string? (car string))
			   (car string))
			  (else
			   (error "gensym"
				  "Illegal argument"
				  (car string))))))
	    (let loop ()
	       (set! counter (+fx counter 1))
	       (let ((name (string-append string (integer->string counter))))
		  (if (not (symbol-exists? name))
		      (string->symbol name)
		      (loop))))))))

;*---------------------------------------------------------------------*/
;*    symbol-plist ...                                                 */
;*---------------------------------------------------------------------*/
(define (symbol-plist symbol)
   (c-symbol-plist symbol))

;*---------------------------------------------------------------------*/
;*    getprop ...                                                      */
;*---------------------------------------------------------------------*/
(define (getprop symbol key)
   (let loop ((pl (symbol-plist symbol)))
      (cond
	 ((null? pl)
	  #f)
	 ((eq? (car pl) key)
	  (cadr pl))
	 (else
	  (loop (cddr pl))))))

;*---------------------------------------------------------------------*/
;*    putprop ...                                                      */
;*---------------------------------------------------------------------*/
(define (putprop! symbol key val)
   (let loop ((pl (symbol-plist symbol)))
      (cond
	 ((null? pl)
	  (let ((new (cons* key val (symbol-plist symbol))))
	     (set-symbol-plist symbol new)
	     new))
	 ((eq? (car pl) key)
	  (set-car! (cdr pl) val))
	 (else
	  (loop (cddr pl))))))

;*---------------------------------------------------------------------*/
;*    remprop! ...                                                     */
;*---------------------------------------------------------------------*/
(define (remprop! symbol key)
   (let loop ((old '())
	      (l   (symbol-plist symbol)))
      (cond
	 ((null? l)
	  #f)
	 ((eq? (car l) key)
	  (cond
	     ((pair? old)
	      (set-cdr! (cdr old) (cddr l)))
	     (else
	      (set-symbol-plist symbol (cddr l)))))
	 (else
	  (loop l (cddr l))))))

