;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime1.9/Ieee/char.scm             */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jul 21 10:09:50 1992                          */
;*    Last change :  Tue Mar 18 10:22:45 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    6.6 Characters (page 24, r4)                                     */
;*=====================================================================*/
 
;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __r4_characters_6_6
   
   (import  (__error                   "Llib/error.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")

	    (__evenv                   "Eval/evenv.scm"))

   (foreign (macro bool  c-char?                (obj)         "CHARP")
	    (macro       uchar  c-char-upcase   (uchar)       "toupper")
	    (macro       uchar  c-char-downcase (uchar)       "tolower")
	    (infix macro bool  c-char=?         (uchar uchar) "==")
	    (infix macro bool  c-char<?         (uchar uchar) "<")
	    (infix macro bool  c-char>?         (uchar uchar) ">")
	    (infix macro bool  c-char<=?        (uchar uchar) "<=")
	    (infix macro bool  c-char>=?        (uchar uchar) ">=")
	    (macro long  c-char->integer        (uchar)       "")
	    (macro uchar  c-integer->char       (long)        "")
	    (infix macro uchar  c-char-or       (uchar uchar) "|"))
   
   (export  (inline char?::bool             ::obj)
	    (inline char=?::bool            ::uchar ::uchar)
	    (inline char<?::bool            ::uchar ::uchar)
	    (inline char>?::bool            ::uchar ::uchar)
	    (inline char<=?::bool           ::uchar ::uchar)
	    (inline char>=?::bool           ::uchar ::uchar) 
	    (inline char-ci=?::bool         ::uchar ::uchar)
	    (inline char-ci<?::bool         ::uchar ::uchar)
	    (inline char-ci>?::bool         ::uchar ::uchar)
	    (inline char-ci<=?::bool        ::uchar ::uchar)
	    (inline char-ci>=?::bool        ::uchar ::uchar)
	    (inline char-alphabetic?::bool  ::uchar)
	    (inline char-numeric?::bool     ::uchar)
	    (inline char-whitespace?::bool  ::uchar)
	    (inline char-upper-case?::bool  ::uchar)
	    (inline char-lower-case?::bool  ::uchar)
	    (inline char->integer::long     ::uchar)
	    (integer->char::uchar           ::long)
	    (inline integer->char-ur::uchar ::long)
	    (inline char-upcase::uchar      ::uchar)
	    (inline char-downcase::uchar    ::uchar)
	    (inline char-or::uchar          ::uchar ::uchar))
   
   (pragma  (c-char? (predicate-of bchar) no-cfa-top)
	    (char? side-effect-free no-cfa-top)
	    (c-char-upcase side-effect-free)
	    (c-char-downcase side-effect-free)
	    (c-char=? side-effect-free)
	    (c-char<? side-effect-free)
	    (c-char>? side-effect-free)
	    (c-char<=? side-effect-free)
	    (c-char>=? side-effect-free)
	    (c-char->integer side-effect-free)
	    (c-integer->char side-effect-free)
	    (c-char-or side-effect-free)
	    (char=? side-effect-free)
	    (char<? side-effect-free)
	    (char>? side-effect-free)
	    (char<=? side-effect-free)
	    (char>=? side-effect-free)
	    (char-ci=? side-effect-free)
	    (char-ci<? side-effect-free)
	    (char-ci>? side-effect-free)
	    (char-ci<=? side-effect-free)
	    (char-ci>=? side-effect-free)
	    (char-alphabetic? side-effect-free)
	    (char-numeric? side-effect-free)
	    (char-whitespace? side-effect-free)
	    (char-upper-case? side-effect-free)
	    (char-lower-case? side-effect-free)
	    (char->integer side-effect-free)
	    (integer->char side-effect-free)
	    (integer->char-ur side-effect-free)
	    (char-upcase side-effect-free)
	    (char-downcase side-effect-free)
	    (char-or side-effect-free)))
 
;*---------------------------------------------------------------------*/
;*    char? ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (char? obj)
   (c-char? obj))

;*---------------------------------------------------------------------*/
;*    char=? ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (char=? char1 char2)
   (c-char=? char1 char2))

;*---------------------------------------------------------------------*/
;*    char<? ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (char<? char1 char2)
   (c-char<? char1 char2))

;*---------------------------------------------------------------------*/
;*    char>? ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline  (char>? char1 char2)
   (c-char>? char1 char2))

;*---------------------------------------------------------------------*/
;*    char<=? ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (char<=? char1 char2)
   (c-char<=? char1 char2))

;*---------------------------------------------------------------------*/
;*    char>=? ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (char>=? char1 char2)
   (c-char>=? char1 char2))

;*---------------------------------------------------------------------*/
;*    char-ci=? ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (char-ci=? char1 char2)
   (char=? (char-upcase char1) (char-upcase char2)))

;*---------------------------------------------------------------------*/
;*    char-ci<? ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (char-ci<? char1 char2)
   (c-char<? (char-upcase char1) (char-upcase char2))) 

;*---------------------------------------------------------------------*/
;*    char-ci>? ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline  (char-ci>? char1 char2)
   (c-char>? (char-upcase char1) (char-upcase char2)))

;*---------------------------------------------------------------------*/
;*    char-ci<=? ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (char-ci<=? char1 char2)
   (c-char<=? (char-upcase char1) (char-upcase char2)))

;*---------------------------------------------------------------------*/
;*    char-ci>=? ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (char-ci>=? char1 char2)
   (c-char>=? (char-upcase char1) (char-upcase char2)))

;*---------------------------------------------------------------------*/
;*    char-alphabetic? ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (char-alphabetic? char)
   (let ((c (char-upcase char)))
      (if (char>=? c #\A)
	  (char<=? c #\Z)
	  #f)))

;*---------------------------------------------------------------------*/
;*    char-numeric? ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (char-numeric? char)
   (if (char>=? char #\0)
       (char<=? char #\9)
       #f))

;*---------------------------------------------------------------------*/
;*    char-withespace? ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (char-whitespace? char)
   (or (char=? char #\space)
       (char=? char #\tab)
       (char=? char #\return)
       (char=? char #\Newline)))

;*---------------------------------------------------------------------*/
;*    char-upper-case? ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (char-upper-case? char)
   (if (char>=? char #\A)
       (char<=? char #\Z)
       #f))

;*---------------------------------------------------------------------*/
;*    char-lower-case? ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (char-lower-case? char)
   (if (char>=? char #\a)
       (char<=? char #\z)
       #f))

;*---------------------------------------------------------------------*/
;*    char->integer ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (char->integer char)
   (c-char->integer char))

;*---------------------------------------------------------------------*/
;*    integer->char ...                                                */
;*---------------------------------------------------------------------*/
(define (integer->char int)
   (if (and (>=fx int 0) (<=fx int 255))
       (c-integer->char int)
       (error "integer->char" "integer out of range" int)))

;*---------------------------------------------------------------------*/
;*    integer->char-ur ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (integer->char-ur int)
   (c-integer->char int))

;*---------------------------------------------------------------------*/
;*    char-upcase ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline  (char-upcase char)
   (c-char-upcase char))

;*---------------------------------------------------------------------*/
;*    char-downcase ...                                                */
;*---------------------------------------------------------------------*/
(define-inline  (char-downcase char)
   (c-char-downcase char))
		     
;*---------------------------------------------------------------------*/
;*    char-or ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (char-or char1 char2)
   (c-char-or char1 char2))
