;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/recette/0cfa.scm                     */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Jul  7 11:13:48 1993                          */
;*    Last change :  Wed Dec 17 21:06:03 1997 (serrano)                */
;*                                                                     */
;*    Quelques tests sur la 0cfa                                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module 0cfa
   (import  (main "main.scm")
	    (module "module.scm")
	    (cfa2 "cfa2.scm"))
   (include "test.sch")
   (export  (test-0cfa)
	    sc-vm))

(define-macro (O4)
   (set! *optim* 4)
   (set! *unsafe-type* #t)
   (set! *unsafe-range* #t)
   '#unspecified)

(O4)

;*---------------------------------------------------------------------*/
;*    Un test qui ne se compilait pas                                  */
;*---------------------------------------------------------------------*/
(define (foo x)
   (begin 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 1 2 3 4 5 6 7 8 9
	  0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 1 2 3 4 5 6 7 8 9)
   (labels ((bar () gee)
            (gee (y) (+fx y 1)))
      ((bar) 5)))

(foo 1)

;*---------------------------------------------------------------------*/
;*    set-car ...                                                      */
;*---------------------------------------------------------------------*/
(define (set-car)
   (let ((l (cons 1 2)))
      (let ((y (car l)))
	 (set-car! l '())
	 (integer? (car l)))))

;*---------------------------------------------------------------------*/
;*    extra-light ...                                                  */
;*---------------------------------------------------------------------*/
(define (foo-of-extra-light f)
   (begin 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 1 2 3 4 5 6 7 8 9
	  0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 1 2 3 4 5 6 7 8 9)
   (f))

(define (extra-light x)
   (labels ((f1 () x)
	    (f2 () (f1)))
      (foo-of-extra-light f2)))

;*---------------------------------------------------------------------*/
;*    Va args in -O4 mode ...                                          */
;*---------------------------------------------------------------------*/
(define va-args
    (lambda (name . default)
       ((lambda (scan)
           (begin
	      (set! scan
		    (lambda (i)
		       (let ((class i))
			  (if (pair? default)
			      (let ((fun (car default)))
				 (fun name))))))
	      (scan 1)))
	(unspecified))))


(define (va-args-main)
   (let ((gee (lambda (name) (begin #t))))
      (va-args 0 gee)))

;*---------------------------------------------------------------------*/
;*    parse ...                                                        */
;*---------------------------------------------------------------------*/
(define (parse iport)
   (let ((body1017 (lambda () (let ((lalr::procedure fun))
				 (let ((v (lalr 4)))
				    v))))
	 (result1019 '()))
      (set! result1019 (body1017))))

;*---------------------------------------------------------------------*/
;*    X-bug ...                                                        */
;*---------------------------------------------------------------------*/
(define (X-bug x)
   (let ((f (lambda (y) x)))
      (cfa2 f)))

;*---------------------------------------------------------------------*/
;*    Another compiler error                                           */
;*---------------------------------------------------------------------*/
(define my-fetch-byte
   (lambda (max-pc prgm)
      0 1 2 3 4 5 6 7 8 9
      0 1 2 3 4 5 6 7 8 9
      0 1 2 3 4 5 6 7 8 9
      (if (=fx max-pc 0)
          #f
          (let ((bug (vector-ref prgm 0)))
             bug))))

(define (sc-vm . action)
   (+fx 1 (my-fetch-byte 0 (cdr action))))

;*---------------------------------------------------------------------*/
;*    test-0cfa ...                                                    */
;*---------------------------------------------------------------------*/
(define (test-0cfa)
   (test-module "0cfa" "0cfa.scm" #f)
   (test "set-car!" (set-car) #f)
   (test "extra-light" (extra-light 1) 1)
   (test "va-args" (va-args-main) #t)
   (test "funcall" (parse #t) #unspecified)
   (test "X" (X-bug 4) 4))
 
