;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Tools/shape.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Dec 27 17:02:04 1994                          */
;*    Last change :  Fri Sep  6 14:23:17 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    In order to print human readable messages, we designed this      */
;*    tool.                                                            */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module tools_shape
   (include "Ast/node.sch"
	    "Tvector/tvector.sch")
   (import  ast_dump
	    ast_env
	    engine_param
	    tools_error)
   (export  (generic shape ::obj)))

;*---------------------------------------------------------------------*/
;*    local-string-downcase ...                                        */
;*---------------------------------------------------------------------*/
(define (local-string-downcase string)
   (if *case-sensitive*
       string
       (string-downcase string)))

;*---------------------------------------------------------------------*/
;*    shape ...                                                        */
;*---------------------------------------------------------------------*/
(define-generic (shape exp::obj)
   (cond
      ((pair? exp)
       (let loop ((exp exp))
	  (cond
	     ((null? exp)
	      '())
	     ((not (pair? exp))
	      (shape exp))
	     (else
	      (cons (shape (car exp)) (loop (cdr exp)))))))
      ((vector? exp)
       (let* ((len (vector-length exp))
	      (res (make-vector len '())))
	  (let loop ((indice 0))
	     (if (=fx indice len)
		 res
		 (begin
		    (vector-set! res
				 indice
				 (shape (vector-ref exp indice)))
		    (loop (+fx indice 1)))))))
      ((a-tvector? exp)
       (a-tvector (shape (a-tvector-type exp)) (shape (a-tvector-vector exp))))
      (else
       exp)))

;*---------------------------------------------------------------------*/
;*    shape ::global                                                   */
;*---------------------------------------------------------------------*/
(define-method (shape var::global)
   (let* ((str-id (local-string-downcase (symbol->string (global-id var))))
	  (id     (string->symbol str-id))
	  (module (local-string-downcase (symbol->string (global-module var))))
	  (type   (global-type var))
	  (tshape (if (not *type-shape?*)
		      ""
		      (string-append "::" (shape type))))
	  (ashape (cond
		     ((not *access-shape?*)
		      "")
		     (else
		      (string-append "{" (local-string-downcase
					  (symbol->string
					   (global-access var)))
				     "}")))))
      (cond
	 (*module-shape?*
	  (string->symbol (string-append str-id
					 "@"
					 module
					 tshape
					 ashape)))
	 (else
	  (case (global-bucket-position (global-id var) (global-module var))
	     ((-1)
	      (internal-error "global-shape"
			      "Can't find global any more"
			      `(@ ,id ,(global-module var))))
	     ((0)
	      (symbol-append id
			     (string->symbol tshape)
			     (string->symbol ashape)))
	     (else
	      (let ((sym (symbol-append id
					(string->symbol tshape)
					(string->symbol ashape))))
		 `(@ ,sym ,(string->symbol module)))))))))

;*---------------------------------------------------------------------*/
;*    shape ::local                                                    */
;*---------------------------------------------------------------------*/
(define-method (shape var::local)
   (let* ((sym    (if *key-shape?*
		      (symbol-append (local-id var)
				     '_
				     (string->symbol
				      (integer->string (local-key var))))
		      (local-id var)))
	  (sym    (local-string-downcase (symbol->string sym)))
	  (type   (local-type var))
	  (tshape (if (not *type-shape?*)
		      ""
		      (string-append "::" (shape type))))
	  (ashape (cond
		     ((not *access-shape?*)
		      "")
		     (else
		      (string-append "{" (local-string-downcase
					  (symbol->string
					   (local-access var)))
				     "}")))))
      (string->symbol (string-append sym tshape ashape))))
   
;*---------------------------------------------------------------------*/
;*    shape ::type ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (shape type::type)
   (local-string-downcase (symbol->string (type-id type))))

;*---------------------------------------------------------------------*/
;*    shape ::node ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (shape node::node)
   (node->sexp node))
   
