;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9c/Object/tools.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jun 18 12:52:24 1996                          */
;*    Last change :  Wed Sep 10 09:11:35 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Some tools for builing the class accessors                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module object_tools
   (include "Object/class.sch")
   (import  tools_misc
	    type_type
	    type_env
	    type_tools
	    ast_var
	    object_class)
   (export  (class->obj-id::symbol             ::symbol)
	    (obj->class-id::symbol             ::symbol)
	    (class?-id::symbol                 ::symbol)
	    (class->super-id::symbol           ::symbol ::symbol)
	    (super->class-id::symbol           ::symbol ::symbol)
	    (make-pragma-direct-set!           ::type slot obj val)
	    (make-pragma-indexed-set!          ::type slot obj val index)
	    (make-pragma-indexed-init-set!     ::type slot obj val)
	    (make-pragma-indexed-ref/widening  ::type slot obj index w)
	    (make-pragma-indexed-set!/widening ::type slot obj val index w)
	    (make-pragma-direct-ref/widening   ::type slot obj obj)
	    (make-pragma-direct-set!/widening  ::type slot obj val w)
	    (malloc                            ::type ::obj)
	    (alloca                            ::type ::obj)))

;*---------------------------------------------------------------------*/
;*    class->obj-id ...                                                */
;*---------------------------------------------------------------------*/
(define (class->obj-id id)
   (symbol-append id '->obj))
	   
;*---------------------------------------------------------------------*/
;*    obj->class-id ...                                                */
;*---------------------------------------------------------------------*/
(define (obj->class-id id)
   (symbol-append 'obj-> id))

;*---------------------------------------------------------------------*/
;*    class?-id ...                                                    */
;*---------------------------------------------------------------------*/
(define (class?-id id)
   (symbol-append id '?))

;*---------------------------------------------------------------------*/
;*    class->super-id ...                                              */
;*---------------------------------------------------------------------*/
(define (class->super-id class super)
   (symbol-append class '-> super))

;*---------------------------------------------------------------------*/
;*    super->class-id ...                                              */
;*---------------------------------------------------------------------*/
(define (super->class-id super class)
   (symbol-append super '-> class))

;*---------------------------------------------------------------------*/
;*    make-pragma-direct-ref ...                                       */
;*---------------------------------------------------------------------*/
(define (make-pragma-direct-ref type slot obj)
   `(,(symbol-append 'free-pragma 4dots (type-id (slot-type slot)))
     ,(string-append "(((" (type-name type) ")CREF($1))->"
		     (slot-name slot) ")")
     ,obj))

;*---------------------------------------------------------------------*/
;*    make-pragma-direct-ref/widening ...                              */
;*---------------------------------------------------------------------*/
(define (make-pragma-direct-ref/widening type slot obj widening)
   (if (not widening)
       (make-pragma-direct-ref type slot obj)
       (make-pragma-direct-ref type slot `(object-widening ,obj))))

;*---------------------------------------------------------------------*/
;*    make-pragma-indexed-ref ...                                      */
;*---------------------------------------------------------------------*/
(define (make-pragma-indexed-ref type slot obj index)
   `(,(symbol-append 'free-pragma 4dots (type-id (slot-type slot)))
     ,(string-append "(((" (type-name type) ")CREF($1))->" (slot-name slot)
		     ")[ $2 ]")
     ,obj
     ,index))

;*---------------------------------------------------------------------*/
;*    make-pragma-indexed-ref/widening ...                             */
;*---------------------------------------------------------------------*/
(define (make-pragma-indexed-ref/widening type slot obj index widening)
   (if (not widening)
       (make-pragma-indexed-ref type slot obj index)
       (make-pragma-indexed-ref type slot `(object-widening ,obj) index)))

;*---------------------------------------------------------------------*/
;*    make-pragma-direct-set! ...                                      */
;*---------------------------------------------------------------------*/
(define (make-pragma-direct-set! type slot obj val)
   `(pragma::obj
     ,(string-append "((((" (type-name type) ")CREF($1))->" (slot-name slot)
		    ") = ((" (type-name (slot-type slot)) ")$2), BUNSPEC)")
     ,obj
     ,val))

;*---------------------------------------------------------------------*/
;*    make-pragma-direct-set!/widening ...                             */
;*---------------------------------------------------------------------*/
(define (make-pragma-direct-set!/widening type slot obj val widening)
   (if (not widening)
       (make-pragma-direct-set! type slot obj val)
       (make-pragma-direct-set! type slot `(object-widening ,obj) val)))

;*---------------------------------------------------------------------*/
;*    make-pragma-indexed-init-set! ...                                */
;*---------------------------------------------------------------------*/
(define (make-pragma-indexed-init-set! type slot obj val)
   `(pragma::obj
     ,(string-append "((((" (type-name type) ")CREF($1))->" (slot-name slot)
		    ") = ((" (type-name (slot-type slot)) " *)$2), BUNSPEC)")
     ,obj
     ,val))

;*---------------------------------------------------------------------*/
;*    make-pragma-indexed-set! ...                                     */
;*---------------------------------------------------------------------*/
(define (make-pragma-indexed-set! type slot obj val index)
   `(pragma::obj
     ,(string-append "((((" (type-name type) ")CREF($1))->" (slot-name slot)
		    ")[ $2 ] = ((" (type-name (slot-type slot))
		    ")$3), BUNSPEC)")
     ,obj
     ,index
     ,val))

;*---------------------------------------------------------------------*/
;*    make-pragma-indexed-set!/widening ...                            */
;*---------------------------------------------------------------------*/
(define (make-pragma-indexed-set!/widening type slot obj val index widening)
   (if (not widening)
       (make-pragma-indexed-set! type slot obj val index)
       (make-pragma-indexed-set! type slot `(object-widening ,obj) val index)))
      
;*---------------------------------------------------------------------*/
;*    malloc/allocator ...                                             */
;*---------------------------------------------------------------------*/
(define (malloc/allocator allocator::bstring type size)
   (let ((tid    (type-id type))
	 (tname  (string-sans-$ (type-name type)))
	 (sizeof (if (string? (type-size type))
		     (type-size type)
		     (type-name type))))
      (if (not (symbol? size))
	  `(,(symbol-append 'free-pragma 4dots tid)
	    ,(string-append "((" tname ")BREF( " allocator "( sizeof("
			    sizeof ") )))"))
	  (let* ((void*      (find-type 'void*))
		 (void*-id   (type-id void*))
		 (void*-name (type-name void*)))
	     `(,(symbol-append 'free-pragma 4dots void*-id)
	       ,(string-append allocator "( sizeof(" sizeof ") * $1 )")
	       ,size)))))

;*---------------------------------------------------------------------*/
;*    malloc ...                                                       */
;*---------------------------------------------------------------------*/
(define (malloc type size)
   (malloc/allocator "GC_MALLOC" type size))

;*---------------------------------------------------------------------*/
;*    alloca ...                                                       */
;*---------------------------------------------------------------------*/
(define (alloca type size)
   (malloc/allocator "STACK_ALLOC" type size))
   

