;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Expand/case.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jul  3 10:13:16 1992                          */
;*    Last change :  Thu Oct  3 16:45:45 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    On macro-expanse ce satane `case'                                */
;*=====================================================================*/
 
;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module expand_case
   (include "Tools/trace.sch")
   (import  tools_progn
	    tools_error
	    engine_param)
   (export  (expand-case ::obj ::procedure)))
	   
;*---------------------------------------------------------------------*/
;*    expand-case ...                                                  */
;*    -------------------------------------------------------------    */
;*    Le case des constantes a ete rajoute en partie pour la           */
;*    compilation de ML car je ne pense pas que lors d'une compilation */
;*    Scheme cela serve beaucoup. Neanmoins, je n'ai pas voulu trop    */
;*    cabler que les caracteres sont des constantes, c'est pourquoi    */
;*    j'ai fait un effort pour laisser le case des char (meme s'il     */
;*    pourrait etre inclus dans celui des constantes).                 */
;*---------------------------------------------------------------------*/
(define (expand-case x e)
   (trace expand "expand-case: " x #\Newline)
   (match-case x
      ((?- ?value . ?clauses)
       (case (case-type clauses)
	  ((integer)
	   (trace expand "expand-case [integer]" #\Newline)
	   (do-typed-case 'long value clauses e))
	  ((char)
	   (trace expand "expand-case [char]" #\Newline)
	   (do-typed-case 'char value clauses e))
	  ((cnst)
	   (trace expand "expand-case [cnst]" #\Newline)
	   (do-cnst-case value clauses e))
	  (else
	   (trace expand "expand-case [else]" #\Newline)
	   (do-generic-case value clauses e))))
   (else
    (error "case" "Illegal `case' form" x))))

;*---------------------------------------------------------------------*/
;*    case-type ...                                                    */
;*    < datum+ x sexp+ >+ --> integer @ char @ symbol @ etherogeneous  */
;*    -------------------------------------------------------------    */
;*    On cherche a savoir si on va poouvoir coder ce case comme un     */
;*    `switch' ou s'il va falloir le coder comme un `if'. On ne peut   */
;*    utiliser un `switch' que si tous les datums sont des constantes. */
;*    -------------------------------------------------------------    */
;*    On profite de cette fonction pour s'assurer que chacune des      */
;*    clauses a la bonne syntaxe.                                      */
;*---------------------------------------------------------------------*/
(define (case-type clauses)
   (labels ((type-match? (type1 type2) (or (null? type1)
					   (null? type2)
					   (and (not (eq? type1 'fail-type))
						(or (eq? type1 type2)
						    (and (eq? type1 'cnst)
							 (eq? type2 'char))
						    (and (eq? type1 'char)
							 (eq? type2 'cnst))))))
	    (general     (type1 type2)  (cond
					   ((eq? type1 type2)
					    type1)
					   ((eq? type1 'cnst)
					    type1)
					   ((null? type2)
					    type1)
					   (else
					    type2)))
	    (one-type    (datum) (cond
				    ((integer? datum)
				     'integer)
				    ((char? datum)
				     'char)
				    ((cnst? datum)
				     'cnst)
				    (else
				     'fail-type)))
	    (datum-type  (datums) (let loop ((datums datums)
					     (type   '()))
				     (cond
					((null? datums)
					 type)
					((not (pair? datums))
					 (error "case"
						"Illegal `case' form"
						clauses)
					 #f)
					(else
					 (let ((dtype (one-type (car datums))))
					    (if (type-match? dtype type)
						(loop (cdr datums)
						      (general dtype type))
						'fail-type)))))))
      (let loop ((clauses clauses)
		 (type    '()))
	 (if (null? clauses)
	     type
	     (match-case (car clauses)
		((else . ?exps)
		 (if (not (null? (cdr clauses)))
		     (error "case" "Illegal `case' form" clauses)
		     type))
		(((and (not ()) ?datum) . ?exps)
		 (let ((dtype (datum-type datum)))
		    (if (type-match? dtype type)
			(loop (cdr clauses) (general dtype type))
			'etherogeneous)))
		(else
		 (error "case" "Illegal `case' form" clauses)))))))

;*---------------------------------------------------------------------*/
;*    do-typed-case ...                                                */
;*    type x sexp x < datum+ x sexp+ >+ x (sexp x sexp --> sexp)       */    
;*---------------------------------------------------------------------*/
(define (do-typed-case type value clauses e)
   (let* ((else-body (let loop ((clauses clauses))
			(if (null? clauses)
			    (list #f)
			    (match-case (car clauses)
					(()
					 #f)
					((else . ?body)
					 (map (lambda (x) (e x e)) body))
					(else
					 (loop (cdr clauses)))))))
	  (else-name (gensym "case-else"))
	  (aux       (gensym 'aux)))
      (let ((case `(case ,aux
		      ,@(let loop ((clauses clauses))
			   (if (null? clauses)
			       (begin
				  `((else ,#f)))
			       (match-case (car clauses)
				  (() 
				   `((else #f)))
				  ((else . ?body)
				   `((else (,else-name))))
				  ((?datums . ?body)
				   (cons `(,datums ,@(map (lambda (x)
							     (e x e))
							  body))
					 (loop (cdr clauses))))
				  (else
				   (error "case"
					  "Illegal `case' form"
					  clauses))))))))
	 (type-test aux type value case else-body else-name e))))

;*---------------------------------------------------------------------*/
;*    do-cnst-case ...                                                 */
;*    sexp x < datum+ x sexp+ >+ x (sexp x sexp --> sexp)              */    
;*    -------------------------------------------------------------    */
;*    On transforme un case sur des constantes en case sur des         */
;*    entiers.                                                         */
;*---------------------------------------------------------------------*/
(define (do-cnst-case value clauses e)
   (let* ((aux   (gensym 'aux))
	  (value `(let ((,aux ,value))
		    (if (cnst? ,aux)
			(cnst->integer ,aux)
			;; on met -1 car les constantes ne peuvent
			;; pas avoir des valeurs negatives.
			-1))))
      (let loop ((c clauses))
	 (if (null? c)
	     (do-typed-case 'long value clauses e)
	     (let ((clause (car c)))
		(if (not (eq? (car clause) 'else))
		    (set-car! clause (map cnst->integer (car clause))))
		(loop (cdr c)))))))

;*---------------------------------------------------------------------*/
;*    type-test ...                                                    */
;*---------------------------------------------------------------------*/
(define (type-test aux type value case else-body else-name e)
   (cond
      ((eq? type 'char)
       `(labels ((,else-name () ,@else-body))
	   (let ((,aux ,(e value e)))
	      (if (c-char? ,aux)
		  ,case
		  (,else-name)))))
      ((eq? type 'long)
       `(labels ((,else-name () ,@else-body))
	   (let ((,aux ,(e value e)))
	      (if (c-fixnum? ,aux)
		  ,case
		  (,else-name)))))
      (else
       (error "type-test" "Unknown `case' type" type))))

;*---------------------------------------------------------------------*/
;*    do-generic-case ...                                              */
;*    sexp x < datum+ x sexp+ >+ x (sexp x sexp --> sexp)              */  
;*---------------------------------------------------------------------*/
(define (do-generic-case value clauses e)
   (e `(let ((case-value ,value))
	  ,(let loop ((clauses clauses))
	      (if (null? clauses)
		  #f
		  (match-case (car clauses)
		     (()
		      #f)
		     ((else . ?body)
		      (normalize-progn body))
		     (((and ?datums (?- . (?- ???-))) . ?body)
		      `(if (memq case-value ',datums)
			   ,(normalize-progn body)
			   ,(loop (cdr clauses))))
		     (((?datums) . ?body)
		      `(if (eq? case-value ',datums)
			   ,(normalize-progn body)
			   ,(loop (cdr clauses))))))))
      e))



	  
