;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Expand/assert.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Nov  9 16:41:17 1993                          */
;*    Last change :  Fri Jan 30 10:25:28 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    L'expansion des formes `assert'                                  */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module expand_assert
   (include "Tools/location.sch")
   (import  engine_param
	    tools_misc
	    tools_progn
	    tools_location)
   (export  (expand-assert ::obj ::procedure)))

;*---------------------------------------------------------------------*/
;*    expand-assert ...                                                */
;*---------------------------------------------------------------------*/
(define (expand-assert x e)
   (match-case x
      ((?- check (and ?vars (? pair?)) . ?body)
       ;; this is the old (1.7) style to introduce assertion
       (let ((new `(assert ,vars ,@body)))
	  (replace! x new)
	  (e x e)))
      ((?- (and ?vars (? list?)) . ?pred)
       (if (and (integer? *compiler-debug*) (>=fx *compiler-debug* 3))
	   (let ((new (make-one-assert e x vars pred)))
	      (replace! x new))
	   #unspecified))
      (else
       (error #f "Illegal `assert' form" x))))
 
;*---------------------------------------------------------------------*/
;*    make-one-assert ...                                              */
;*---------------------------------------------------------------------*/
(define (make-one-assert e exp vars pred)
   (let ((old-pred (dup pred)))
      `(if ,(e (normalize-progn pred) e)
	   #unspecified
	   (begin
	      ;; we send all vars to the interpreters
	      ,@(let loop ((vars vars)
			   (defs '()))
		   (if (null? vars)
		       defs
		       (loop (cdr vars)
			     (cons `(define-primop-ref! ',(car vars)
				       ((@ __evmeaning_address foreign)
					,(car vars)))
				   defs))))
	      ,(let ((loc (let ((loc (find-location exp)))
			     (if (location? loc)
				 loc
				 (find-location pred)))))
		  `(notify-assert-fail ',vars
				       ',(cons 'begin old-pred)
				       ,(if (location? loc)
					    `',(cons (location-full-fname loc)
						     (location-pos loc))
					    #f)))
	      ,@(let loop ((vars vars)
			   (defs '()))
		   (if (null? vars)
		       defs
		       (loop (cdr vars)
			     (cons `(unbind-primop! ',(car vars))
				   defs))))))))

;*---------------------------------------------------------------------*/
;*    dup ...                                                          */
;*---------------------------------------------------------------------*/
(define (dup pred)
   (cond
      ((pair? pred)
       (cons (dup (car pred)) (dup (cdr pred))))
      (else
       pred)))


