;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Engine/pass.sch          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Dec 25 10:29:06 1994                          */
;*    Last change :  Tue Jun 11 13:16:44 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The pass prelude                                                 */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The directives clause                                            */
;*---------------------------------------------------------------------*/
(directives
   (import  tools_speek
	    (*nb-error-on-pass* tools_error)
	    engine_pass))
 
;*---------------------------------------------------------------------*/
;*    pass-prelude ...                                                 */
;*    -------------------------------------------------------------    */
;*    The pass prelude.                                                */
;*---------------------------------------------------------------------*/
(define-macro (pass-prelude name . hooks)
   `(begin
       (verbose 1 "   . " ,name #\newline)
       (set! *nb-error-on-pass* 0)
       (set! *current-pass*  ,name)
       (let loop ((hooks ,(cons 'list hooks))
		  (hnames ',hooks))
	  (cond
	     ((null? hooks)
	      'pass-started)
	     (((car hooks))
	      (loop (cdr hooks) (cdr hnames)))
	     (else
	      (internal-error ,name
			      "failure during prelude hook"
			      (car hnames)))))))

;*---------------------------------------------------------------------*/
;*    pass-postlude ...                                                */
;*---------------------------------------------------------------------*/
(define-macro (pass-postlude value . hooks)
   `(let ((value ,value))
       (if (>fx *nb-error-on-pass* 0)
	   (begin
	      (fprint (current-error-port)
		      *nb-error-on-pass*
		      " error"
		      (if (and (integer? *nb-error-on-pass*)
			       (> *nb-error-on-pass* 1))
			  "s"
			  "")
		      " occured, ending ...")
	      (exit -1))
	   (let loop ((hooks  ,(cons 'list hooks))
		      (hnames ',hooks))
	      (cond
		 ((null? hooks)
		  value)
		 (((car hooks))
		  (loop (cdr hooks) (cdr hnames)))
		 (else
		  (internal-error *current-pass*
				  "failure during postlude hook"
				  (car hnames))))))))
	      
	       

	   
