;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Engine/param.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Oct  3 12:44:17 1995                          */
;*    Last change :  Mon Mar  2 07:18:18 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Global control of the compiler                                   */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module engine_param
   (import  ;; tools_date is a generated file and hence, it can't be
	    ;; set in the .afile file.
	    (tools_date "Tools/date.scm"))
   (export  *bigloo-version*
	    *bigloo-name*
	    *bigloo-level*
	    *bigloo-cmd-name*
	    *bigloo-args*
	    *rest-args*
	    *bigloo-author*    
	    *bigloo-email*     
	    *bigloo-date*
	    *bigloo-tmp*
	    *bigloo-licensing?*
	    *lib-mode*
	    *init-mode*
	    *max-c-token-length*
	    *max-c-foreign-arity*
	    *verbose*
	    *unsafe-type*      
	    *unsafe-range*     
	    *unsafe-struct*    
	    *unsafe-arity*
	    *unsafe-version*
	    *unsafe-library*
	    *trace-name*
	    *trace-write-length*
	    *additional-traces*
	    *inlining?*
	    *inlining-kfactor*
	    *inlining-reduce-kfactor*
	    *optim*
	    *optim-stack?*
	    *optim-inline-method?*
	    *optim-unroll-loop?*
	    *optim-loop-inlining?*
	    *optim-O-macro?*
	    *max-stack-alloc-size*
	    *genericity*
	    *shared-cnst?*
	    ;; -------------------------------------------------------------
	    ;; warning, any change about this variable name must be reported
	    ;; in the no-trace-no-check macro of Llib/error.scm file
	    *compiler-debug*            
	    ;; -------------------------------------------------------------
	    *c-debug*                   
	    *c-debug-option*            
	    *module-shape?*             
	    *key-shape?*
	    *type-shape?*
	    *access-shape?*
	    *tmp-dest*         
	    *dest*
	    *shell*
	    *cc*
	    *stdc*               
	    *cc-options*       
	    *rm-c-files*       
	    *ld-options*       
	    *strip*            
	    *bigloo-lib*
	    *bigloo-lib-base-name*
	    *gc-lib*
	    *static-bigloo?*
	    *bigloo-user-lib*
	    *default-lib-dir*
	    *lib-dir*
	    *include-foreign*  
	    *indent*
	    *access-file*      
	    *access-table*     
	    *src-files*              
	    *o-files*          
	    *with-files*
	    *interpreter*      
	    *startup-file*     
	    *call/cc?*
	    *reflection?*
	    *garbage-collector*
	    *pass*
	    *heap-base-name*
	    *heap-name*
	    *extend-entry*
	    *auto-mode*
	    *src-suffix*
	    *obj-suffix*
	    *case-sensitive*
	    (bigloo-variables-usage))
   (extern  (macro shell::string "SHELL")
	    (macro c-compiler::string "C_COMPILER")
	    (macro library-directory::string "LIBRARY_DIRECTORY")
	    (macro user-libraries::string "USER_LIBRARIES")
	    (macro c-beautifier::string "C_BEAUTIFIER")
	    (macro library-base-name::string "LIBRARY_BASE_NAME"))
   (eval    (export-all)))

;*---------------------------------------------------------------------*/
;*    *bigloo-variables* ...                                           */
;*    -------------------------------------------------------------    */
;*    This variable hold the list of all the Bigloo control            */
;*    variables with there description. This variable is used by       */
;*    the only function `bigloo-variables-usage'.                      */
;*---------------------------------------------------------------------*/
(define *bigloo-variables* '())

;*---------------------------------------------------------------------*/
;*    add-doc-variable! ...                                            */
;*---------------------------------------------------------------------*/
(define (add-doc-variable! id doc)
   (set! *bigloo-variables* (cons (cons id doc) *bigloo-variables*)))

;*---------------------------------------------------------------------*/
;*    doc-define ...                                                   */
;*---------------------------------------------------------------------*/
(define-macro (doc-define var doc val)
   `(begin
       (define ,var ,val)
       (add-doc-variable! ',var ,doc)))
		    
;*---------------------------------------------------------------------*/
;*    bigloo-variables-usage ...                                       */
;*---------------------------------------------------------------------*/
(define (bigloo-variables-usage)
   (print "   All the Bigloo control variables can be changed from the")
   (print "   interpreter, by the means of the `-eval' option, or using")
   (print "   the module clause `option'. For instance the option")
   (print "   \"-eval '(set! *strip* #t)'\" will set the variable")
   (print "   `*strip*' to the value `#t'.")
   (print "   These variables are:")
   (newline)
   (let loop ((l (reverse *bigloo-variables*)))
      (if (pair? l)
	  (let ((var (car l)))
	     (display* "   - " (car var) " : " (cdr var) " [")
	     (write (eval (car var)))
	     (print "]")
	     (loop (cdr l))))))
   
;*---------------------------------------------------------------------*/
;*    Les auteurs et le nom du soft                                    */
;*---------------------------------------------------------------------*/
;; the bigloo version
(doc-define *bigloo-version*
	    "The Bigloo major release number"
	    "1.9")
;; the bigloo name
(doc-define *bigloo-name*
	    "The Bigloo name"
	    (string-append "Bigloo (" *bigloo-version* ")"))
;; the bigloo minor release number
(doc-define *bigloo-level*
	    "The Bigloo minor release number (#f or a char)"
	    #\c)
(define *bigloo-cmd-name*   'nothing-yet)
(define *bigloo-args*       'nothing-yet)
(define *rest-args*         '())
(define *bigloo-author*     "Manuel Serrano")
(define *bigloo-email*      "Manuel.Serrano@unice.fr")
(define *bigloo-date*       (bigloo-date))
;; the tmp directory
(doc-define *bigloo-tmp*
	    "The tmp directory name"
	    (let ((Venv (getenv "TMPDIR")))
	       (if (string? Venv)
		   Venv
		   (os-tmp))))
;; Shall we include the license in the C files ?
(doc-define *bigloo-licensing?*
	    "Add the Bigloo license ?"
	    #f)
	    
;*---------------------------------------------------------------------*/
;*    Le bavardage ...                                                 */
;*---------------------------------------------------------------------*/
(doc-define *verbose*
	    "The verbosity level"
	    0)

;*---------------------------------------------------------------------*/
;*    Les noms des differents fichiers                                 */
;*---------------------------------------------------------------------*/
;; the source files
(doc-define *src-files*
	    "The sources files"
	    '())
(define *tmp-dest*          #f)
;; the target name
(doc-define *dest*
	    "The target name"
	    #f)

;*---------------------------------------------------------------------*/
;*    Le compilateur C et ses options                                  */
;*---------------------------------------------------------------------*/
;; the shell
(doc-define *shell*
	    "The C compiler"
	    shell)
;; the c compiler
(doc-define *cc*
	    "The C compiler"
	    c-compiler)
;; The C production type
(doc-define *stdc*
	    "Shall we produced ISO C?"
	    #f)
;; the CC option
(doc-define *cc-options*
	    "cc options"
	    "")
;; shall we remove the C produced file?
(doc-define *rm-c-files*
	    "Shall we remove the C produced file?"
	    #t)
;; ld options
(doc-define *ld-options*
	    "ld options"
	    ""))
;; strip ?
(doc-define *strip*
	    "Shall we strip the executable?"
	    #f)
;; the default lib dir path
(doc-define *default-lib-dir*
	    "The default lib dir path (without version)"
	    library-directory)
;; the lib dir path
(doc-define *lib-dir*
	    "The lib dir path"
	    (let ((lib-env (getenv "BIGLOOLIB")))
	       (if (not (string? lib-env))
		   *default-lib-dir*
		   lib-env)))
;; the bigloo library base name
(doc-define *bigloo-lib-base-name*
	    "The Bigloo library base name"
	    library-base-name)
;; the bigloo library
(doc-define *bigloo-lib*
	    "The Bigloo library"
	    (string-append *bigloo-lib-base-name*
			   *bigloo-version*
			   (if (char? *bigloo-level*)
			       (make-string 1 *bigloo-level*)
			       "")))
;; the gc library
(doc-define *gc-lib*
	    "The Gc library"
	    "gc")
;; does we use a static version of the bigloo library?
(doc-define *static-bigloo?*
	    "Do we use the static Bigloo library"
	    #f)
;; the user libraries
(doc-define *bigloo-user-lib*
	    "The user extra libraries"
	    (list user-libraries))
;; the load path
(set! *load-path* (cons *lib-dir* *load-path*))
;; the C include files
(doc-define *include-foreign*
	    "The C included files"
	    (list (string-append "bigloo"
				 *bigloo-version*
				 (if (char? *bigloo-level*)
				     (make-string 1 *bigloo-level*)
				     "")
				 ".h")))
;; the bigloo heap base name
(doc-define *heap-base-name*
	    "The Bigloo heap base name"
	    "bigloo")
;; the heap name
(doc-define *heap-name*
	    "The Bigloo heap file name"
	    (string-append *heap-base-name*
			   *bigloo-version*
			   (if (char? *bigloo-level*)
			       (make-string 1 *bigloo-level*)
			       "")
			   ".heap"))
;; indent
(doc-define *indent*
	    "The name of the C beautifier"
	    c-beautifier)
;; debugging level
(doc-define *compiler-debug*
	    "Debugging level"
	    0)
;; C debugging mode ?
(doc-define *c-debug*
	    "C debugging mode?"
	    #f)
;; C debugging option
(doc-define *c-debug-option*
	    "cc debugging option"
	    "-g")

;*---------------------------------------------------------------------*/
;*    Les fichier de link                                              */
;*---------------------------------------------------------------------*/
(doc-define *access-file*
	    "The access file name"
	    #f)
(define *access-table* '())
(doc-define *o-files*
	    "The additional obect files"
	    '())
(doc-define *with-files*
	    "The additional modules"
	    '())
   
;*---------------------------------------------------------------------*/
;*    Des variables de controle sur `comment on doit compiler'         */
;*---------------------------------------------------------------------*/
(doc-define *interpreter*
	    "Shall we interprete the source file?"
	    #f)
(doc-define *startup-file*
	    "A startup file for the interpreter"
	    #f)
(doc-define *call/cc?*
	    "Shall we enabled call/cc?"
	    #f)
(doc-define *reflection?*
	    "Shall we produce refection code for classes"
	    #t)
(doc-define *pass*
	    "Stop after the pass"
	    'ld)
(doc-define *garbage-collector*
	    "The garbage collector"
	    'boehm)

;*---------------------------------------------------------------------*/
;*    Les modes de compilations                                        */
;*---------------------------------------------------------------------*/
(doc-define *unsafe-type*
	    "Runtime type safety"
	    #f)
(doc-define *unsafe-arity*
	    "Runtime type arity safety"
	    #f)
(doc-define *unsafe-range*
	    "Runtime range safety"
	    #f)
(doc-define *unsafe-struct*
	    "Runtime struct range safety"
	    #f)
(doc-define *unsafe-version*
            "Module version safety"
	    #f)
(doc-define *unsafe-library*
	    "Use the unsafe library version"
	    #f)
(define *module-shape?*             #f)
(define *key-shape?*                #f)
(define *type-shape?*               #f)
(define *access-shape?*             #f)
(doc-define *max-stack-alloc-size*
	    "Maximum size of stack allocated objects"
	    #f)
(define *genericity*                #t)
(doc-define *shared-cnst?*
	    "Shared constant compilation?"
	    #f)
(doc-define *lib-mode*
	    "Lib-mode compilation?"
	    #f)
(doc-define *init-mode*
	    "Module initialization mode"
	    'read)
(doc-define *max-c-token-length*
	    "Max c token length"
	    1024)
(doc-define *max-c-foreign-arity*
	    "Max C function arity"
	    16)
(doc-define *trace-name*
	    "Trace file name"
	    "trace")
(doc-define *trace-write-length*
	    "Trace dumping max level"
	    80)
(define *additional-traces*         '())

;*---------------------------------------------------------------------*/
;*    Optimizations                                                    */
;*---------------------------------------------------------------------*/
(doc-define *optim*
	    "Optimization level"
	    0)
(doc-define *optim-stack?*
	    "Stack allocation optimization"
	    #unspecified)
(doc-define *optim-inline-method?*
	    "Method inlining optimization"
	    #unspecified)
(doc-define *optim-unroll-loop?*
	    "Loop unrolling optimization"
	    #unspecified)
(doc-define *optim-loop-inlining?*
	    "Loop inlining optimization"
	    #t)
(doc-define *optim-O-macro?*
	    "Enable optimization by macro-expansion"
	    #t)
(doc-define *inlining?*
	    "Inlining optimization"
	    #t)
(doc-define *inlining-kfactor*
	    "Inlining growth factor"
	    (lambda (olevel) (*fx 2 olevel)))
(doc-define *inlining-reduce-kfactor*
	    "Inlinine growth factor reductor"
	    (lambda (kfactor) (/fx kfactor 2)))

;*---------------------------------------------------------------------*/
;*    *extend-entry* ...                                               */
;*---------------------------------------------------------------------*/
(doc-define *extend-entry*
	    "Extend entry"
	    #f)

;*---------------------------------------------------------------------*/
;*    *src-suffix* ...                                                 */
;*    -------------------------------------------------------------    */
;*    The list of suffix recognize by the compiler and the linker.     */
;*---------------------------------------------------------------------*/
(doc-define *src-suffix*
	    "Scheme legal suffixes"
	    '("scm" "bgl"))

;*---------------------------------------------------------------------*/
;*    *obj-suffix* ...                                                 */
;*    -------------------------------------------------------------    */
;*    The suffix list of the object file                               */
;*---------------------------------------------------------------------*/
(doc-define *obj-suffix*
	    "Object legal suffixes"
	    '("o"))   

;*---------------------------------------------------------------------*/
;*    Les auto-modes (comme en emacs)                                  */
;*---------------------------------------------------------------------*/
(doc-define *auto-mode*
	    "auto-mode (extend mode) list"
	    '(("ml"  . "caml")
	      ("mli" . "caml")
	      ("oon" . "meroon")
	      ("stk" . "stk")))

;*---------------------------------------------------------------------*/
;*    *case-sensitive* ...                                             */
;*---------------------------------------------------------------------*/
(doc-define *case-sensitive*
	    "Case sensitivity"
	    #f)

;*---------------------------------------------------------------------*/
;*    Other variables that are defined inside the interpreter...       */
;*---------------------------------------------------------------------*/
(add-doc-variable! '*load-path* "The load path")
(add-doc-variable! '*user-pass* "The user specific compilation pass")
(add-doc-variable! '*debug*     "The debugging level")
(add-doc-variable! '*warning*   "The warning level")
(add-doc-variable! '*hygien?*   "Hygienic r5rs macro expansion activation")
