;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Coerce/apply.scm         */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jan 20 17:21:26 1995                          */
;*    Last change :  Fri Jul 19 12:22:56 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The `apply' coercion                                            */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module coerce_apply
   (include "Tools/trace.sch"
	    "Tools/location.sch")
   (import  engine_param
	    tools_shape
	    tools_location
	    tools_error
	    type_type
	    type_cache
	    ast_var
	    ast_node
	    ast_sexp
	    ast_local
	    coerce_coerce
	    coerce_convert))

;*---------------------------------------------------------------------*/
;*    coerce! ::app-ly ...                                              */
;*---------------------------------------------------------------------*/
(define-method (coerce! node::app-ly to)
   (trace coerce "coerce-apply!: " (shape node) #\Newline)
   (let ((error-msg (list 'quote (shape node))))
      ;; we coerce the arguments
      (app-ly-arg-set! node (coerce! (app-ly-arg node) *obj*))
      ;; we coerce the procedure
      (let ((c-fun (coerce! (app-ly-fun node) *procedure*)))
	 ;; we check arity
	 (if *unsafe-arity*
	     (begin
		(if (var? c-fun)
		    (begin
		       (app-ly-fun-set! node c-fun)
		       (convert! node *obj* to))
		    (let ((fun (make-local-svar 'fun *procedure*)))
		       (app-ly-fun-set! node c-fun)
		       (instantiate::let-var
			  (loc (node-loc node))
			  (type (node-type node))
			  (bindings (list (cons fun c-fun)))
			  (body (convert! node *obj* to))))))
	     (let* ((fun   (make-local-svar 'fun *procedure*))
		    (val   (make-local-svar 'val *procedure*))
		    (len   (gensym 'len))
		    (loc   (node-loc node))
		    (lnode (instantiate::let-var
			      (loc loc)
			      (type *obj*)
			      (bindings (list (cons fun c-fun)
					      (cons val (app-ly-arg node))))
			      (body     (top-level-sexp->node
					 `(let ((,(symbol-append len '::long)
						 (length ,val)))
					     (if (correct-arity? ,fun ,len)
						 ,(convert! node *obj* to)
						 ,(make-error-node error-msg
								   loc
								   to)))
					 loc)))))
		   ;; we set the new apply value
		(app-ly-fun-set! node (instantiate::var
					(loc loc)
					(type *procedure*)
					(variable fun)))
		(app-ly-arg-set! node (instantiate::var
					(loc loc)
					(type *obj*)
					(variable val)))
		lnode)))))

;*---------------------------------------------------------------------*/
;*    make-error-node ...                                              */
;*---------------------------------------------------------------------*/
(define (make-error-node error-msg loc to)
   (let ((ut *unsafe-type*))
      (set! *unsafe-type* #t)
      (let ((node (coerce!
		   (top-level-sexp->node 
		    (if (and (>fx *compiler-debug* 0) (location? loc))
			`(begin
			    ((@ error/location __error)
			     ,(list 'quote (current-function))
			     "Wrong number of arguments"
			     ,error-msg
			     ,(location-full-fname loc)
			     ,(location-pos loc))
			    (failure '_ '_ '_))
			`(failure ,(list 'quote (current-function))
				  "Wrong number of arguments"
				  ,error-msg))
		    loc)
		   to)))
	 (set! *unsafe-type* ut)
	 node)))

