;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Cgen/cop.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jul  2 13:53:24 1996                          */
;*    Last change :  Tue Jul  9 09:17:11 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The intermediate structure to emit c code.                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cgen_cop
   
   (import type_type
	   ast_var
	   ast_node)
   
   (export (class cop)

	   (class clabel::cop
	      (name::bstring read-only)
	      (used?::bool (default #f))
	      (body (default #unspecified)))

	   (class cgoto::cop
	      (label::clabel read-only))

	   (class block::cop
	      (body::cop read-only))

	   (class creturn::cop
	      (value::cop read-only))

	   (class cvoid::cop
	      (value::cop read-only))

	   (class catom::cop
	      (value read-only))
	   
	   (class varc::cop
	      (variable::variable read-only))
	   
	   (class cpragma::cop
	      (format::bstring read-only)
	      (args read-only))

	   (class ccast::cop
	      (type::type read-only)
	      (arg::cop read-only))
	   
	   (class csequence::cop
	      (c-exp?::bool read-only (default #f))
	      (cops read-only))

	   (class nop::cop)

	   (class stop::cop
	      (value::cop read-only))

	   (class csetq::cop
	      (var::varc read-only)
	      (value::cop read-only))

	   (class cif::cop
	      (test::cop read-only)
	      (true::cop read-only)
	      (false::cop read-only))
	   
	   (class branch::cop
	      (test::cop read-only)
	      (true::cop read-only)
	      (false::cop read-only)
	      (end::cop read-only))
	   
	   (class local-var::cop
	      (vars read-only))
	   
	   (class cfuncall::cop
	      (fun::cop read-only)
	      (args read-only)
	      (strength::symbol read-only))
	   
	   (class capply::cop
	      (fun::cop read-only)
	      (arg::cop read-only))

	   (class capp::cop
	      (fun::cop read-only)
	      (args read-only))

	   (class cfail::cop
	      (proc::cop read-only)
	      (msg::cop read-only)
	      (obj::cop read-only))

	   (class cswitch::cop
	      (test::cop read-only)
	      (clauses read-only))

	   (class cmake-box::cop
	      (value::cop read-only))

	   (class cbox-ref::cop
	      (var::cop read-only))

	   (class cbox-set!::cop
	      (var::cop read-only)
	      (value::cop read-only))
	   
	   (class cset-ex-it::cop
	      (exit::cop read-only)
	      (jump-value::cop read-only)
	      (body::cop read-only))

	   (class cjump-ex-it::cop
	      (exit::cop read-only)
	      (value::cop read-only))

	   (wide-class sfun/c::sfun
	      (label::clabel read-only)
	      integrated::bool)))
	      

	   


