;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9b/Cfa/walk.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Feb 21 08:37:48 1995                          */
;*    Last change :  Mon Apr 14 09:17:26 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The `control flow analysis' and its optimizations described in:  */
;*                                                                     */
;*    @InProceedings{ sf:icfp96                                        */
;*      author	  = {Serrano, M. and Feeley, M.},                      */
;*      title	  = {{S}orage {U}se {A}nalysis and its {A}pplications},*/
;*      year	  = 1996,                                              */
;*      month	  = may,                                               */
;*      booktitle = "1fst " # icfp,                                    */
;*      address	  = {Philadelphia, Penn, US},                          */
;*    }                                                                */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cfa_walk
   (include "Engine/pass.sch")
   (import  tools_shape
	    tools_error
	    engine_param
	    type_type
	    ast_remove
	    ast_var
	    ast_node
	    ast_shrinkify
	    cfa_collect
	    cfa_setup
	    cfa_iterate
	    cfa_show
	    cfa_info
	    cfa_approx
	    cfa_stack
	    cfa_type
	    cfa_closure
	    cfa_specialize
	    cfa_tvector)
   (export  (cfa-walk! <global>*)))

;*---------------------------------------------------------------------*/
;*    cfa-walk! ...                                                    */
;*    -------------------------------------------------------------    */
;*    This function is the engine of all the cfa based optimizations.  */
;*    First, this function invokes the cfa, then the following         */
;*    optimizations are performed:                                     */
;*       1. dead code remove                                           */
;*       2. closure optimization (mapping to X and T)                  */
;*       3. type setting (a kind of reverse type inference)            */
;*       4. allocation class mapping (stackability)                    */
;*---------------------------------------------------------------------*/
(define (cfa-walk! globals)
   (pass-prelude "Cfa")
   ;; first of all, we scan the global definitions in order
   ;; to collect all used types and allocations.
   (collect-all-approx! globals)
   ;; we have collected all the approximation, we can now declare
   ;; the approximations sets.
   (declare-approx-sets!)
   ;; we have collect all the possible approximation, we now
   ;; prepare the ast to the iteration process.
   (set-initial-approx! globals)
   ;; ok, we can start now the control flow analysis
   (let ((iteration-roots (cfa-iterate-to-fixpoint! globals)))
      ;; the number of iterations
      (show-cfa-nb-iterations)
      ;; dead code removal
      (let ((globals (remove-var '(cfa inline) globals)))
	 ;; we show the result of the approximation (after dead-code-removal!)
	 (show-cfa-results globals)
	 ;; allocation class mapping
	 (heap->stack! iteration-roots globals)
	 ;; tvector optimization
	 (let ((additional (vector->tvector! globals)))
	    ;; type settings
	    (type-settings! globals)
	    ;; we optimize closure allocations
 	    (closure-optimization!)
	    ;; generic arithmetic specialization
	    (specialize! globals)
	    ;; and we are done
	    (pass-postlude (shrinkify! (append additional globals))
			   unpatch-vector-set!)))))
 
 
