;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9b/Cfa/vector.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Apr  5 18:06:51 1995                          */
;*    Last change :  Tue Jun 10 15:53:25 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The vector approximation managment                               */
;*    -------------------------------------------------------------    */
;*    All vectors fields approximation are merger into on single set.  */
;*=====================================================================*/
 
;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cfa_vector
   (include "Tools/trace.sch")
   (import  tools_error
	    tools_shape
	    type_type
	    type_cache
	    ast_var
	    ast_node
	    cfa_info
	    cfa_loose
	    cfa_iterate
	    cfa_cfa
	    cfa_setup
	    cfa_approx
	    cfa_tvector
	    cfa_stack))

;*---------------------------------------------------------------------*/
;*    node-setup! ::pre-make-vector-app ...                            */
;*---------------------------------------------------------------------*/
(define-method (node-setup! node::pre-make-vector-app)
   (add-make-vector! node)
   (with-access::pre-make-vector-app node (fun args)
      (node-setup*! args)
      (let* ((key   (pre-make-vector-app-key node))
	     (owner (pre-make-vector-app-owner node))
	     (node  (shrink! node)))
	 (let ((wnode (widen!::make-vector-app node
			 (key key)
			 (owner owner)
			 (approx (make-empty-approx))
			 (value-approx (make-empty-approx)))))
	    (trace (cfa 3) 
		   "    make-vector-app: " (shape node) #\Newline
		   "                key: " key #\Newline)
	    (make-vector-app-approx-set! wnode
					 (make-type-alloc-approx *vector*
								 node))))))

;*---------------------------------------------------------------------*/
;*    node-setup! ::pre-create-vector-app ...                          */
;*---------------------------------------------------------------------*/
(define-method (node-setup! node::pre-create-vector-app)
   (add-make-vector! node)
   (with-access::pre-create-vector-app node (fun args)
      (node-setup*! args)
      (let* ((key   (pre-create-vector-app-key node))
	     (owner (pre-create-vector-app-owner node))
	     (node  (shrink! node)))
	 (let ((wnode (widen!::create-vector-app node
			 (key key)
			 (owner owner)
			 (approx (make-empty-approx))
			 (value-approx (make-empty-approx)))))
	    (trace (cfa 3) 
		   "  create-vector-app: " (shape node) #\Newline
		   "                key: " key #\Newline)
	    (create-vector-app-approx-set! wnode
					   (make-type-alloc-approx *vector*
								   node))))))

;*---------------------------------------------------------------------*/
;*    node-setup! ::pre-vector-ref-app ...                             */
;*---------------------------------------------------------------------*/
(define-method (node-setup! node::pre-vector-ref-app)
   (with-access::pre-vector-ref-app node (fun args)
      (node-setup*! args)
      (let ((node (shrink! node)))
	 (widen!::vector-ref-app node (approx (make-empty-approx))))))

;*---------------------------------------------------------------------*/
;*    node-setup! ::pre-vector-set!-app ...                            */
;*---------------------------------------------------------------------*/
(define-method (node-setup! node::pre-vector-set!-app)
   (with-access::pre-vector-set!-app node (fun args)
      (node-setup*! args)
      (let ((node (shrink! node)))
	 (widen!::vector-set!-app node (approx (make-type-approx *unspec*))))))

;*---------------------------------------------------------------------*/
;*    cfa! ::make-vector-app ...                                       */
;*---------------------------------------------------------------------*/
(define-method (cfa!::approx node::make-vector-app)
   (with-access::make-vector-app node (args value-approx approx)
      (trace (cfa 4) "   make-vector: " (shape node) #\Newline)
      (cfa! (car args))
      (let ((init-value-approx (cfa! (cadr args))))
	 (union-approx! value-approx init-value-approx)
	 approx)))

;*---------------------------------------------------------------------*/
;*    cfa! ::create-vector-app ...                                     */
;*---------------------------------------------------------------------*/
(define-method (cfa!::approx node::create-vector-app)
   (with-access::create-vector-app node (args approx)
      (trace (cfa 4) " create-vector: " (shape node) #\Newline)
      (for-each cfa! args)
      approx))

;*---------------------------------------------------------------------*/
;*    cfa! ::vector-ref-app ...                                        */
;*---------------------------------------------------------------------*/
(define-method (cfa!::approx node::vector-ref-app)
   (with-access::vector-ref-app node (args approx)
      ;; even if we don't use it we must walk on the 2nd
      ;; argument of a vector ref.
      (cfa! (cadr args))
      (let ((vec-approx (cfa! (car args))))
	 (trace (cfa 4) ">>> vector-ref: " (shape node) " "
		(shape vec-approx) " currently: " (shape approx) #\Newline)
	 ;; we check the type...
	 (if (or (not (eq? (approx-type vec-approx) *vector*))
		 (approx-top? vec-approx))
	     (approx-set-type! approx *obj*))
	 ;; and top
	 (if (approx-top? vec-approx)
	     (approx-set-top! approx))
	 ;; then we scan the allocations.
	 (for-each-approx-alloc
	  (lambda (app)
	     (cond
		((make-vector-app? app)
		 (with-access::make-vector-app app (value-approx seen?)
		    (set! seen? #t)
		    (union-approx! approx value-approx)
		    (approx-set-type! value-approx (approx-type approx))))
		((create-vector-app? app)
		 (with-access::create-vector-app app (value-approx seen?)
		    (set! seen? #t)
		    (union-approx! approx value-approx)
		    (approx-set-type! value-approx (approx-type approx))))))
	  vec-approx))
      approx))

;*---------------------------------------------------------------------*/
;*    cfa! ::vector-set!-app ...                                       */
;*---------------------------------------------------------------------*/
(define-method (cfa!::approx node::vector-set!-app)
   (with-access::vector-set!-app node (args approx)
      ;; even if we don't use it we must walk on the 2nd
      ;; argument of a vector ref.
      (cfa! (cadr args))
      (let ((vec-approx (cfa! (car args)))
	    (val-approx (cfa! (caddr args))))
	 (trace (cfa 4) "   vector-set!: " (shape node) " "
		(shape vec-approx) #\Newline)
	 ;; we check the type...
	 (if (not (eq? (approx-type vec-approx) *vector*))
	     (approx-set-type! val-approx *obj*))
	 ;; we check if we have top on the vector
	 (if (approx-top? vec-approx)
	     ;; yes, we have, hence we loose every thing.
	     (loose! val-approx 'all)
	     ;; no, then we scan the allocations.
	     (for-each-approx-alloc
	      (lambda (app)
		 (cond
		    ((make-vector-app? app)
		     (with-access::make-vector-app app (value-approx seen?)
			(set! seen? #t)
			(union-approx! value-approx val-approx)))
		    ((create-vector-app? app)
		     (with-access::create-vector-app app (value-approx seen?)
			(set! seen? #t)
			(union-approx! value-approx val-approx)))))
	      vec-approx)))
      approx))
      
;*---------------------------------------------------------------------*/
;*    loose-alloc! ...                                                 */
;*    -------------------------------------------------------------    */
;*    Loosing a vector means that vector-ref now returns `obj' and     */
;*    `top' and that all contained allocation are also lost but        */
;*    it does not change anything on the allocation itself.            */
;*---------------------------------------------------------------------*/
(define-method (loose-alloc! alloc::make-vector-app)
   (with-access::make-vector-app alloc (lost-stamp value-approx stackable?)
      (if (=fx lost-stamp *cfa-stamp*)
	  #unspecified
	  (begin
	     (trace (cfa 2) " *** loose: " (shape alloc) #\Newline)
	     (set! lost-stamp *cfa-stamp*)
	     (set! stackable? #f)
	     (for-each-approx-alloc loose-alloc! value-approx)
	     (approx-set-type! value-approx *obj*)
	     (approx-set-top! value-approx)))))
   
;*---------------------------------------------------------------------*/
;*    loose-alloc! ...                                                 */
;*    -------------------------------------------------------------    */
;*    Loosing a vector means that vector-ref now returns `obj' and     */
;*    `top' and that all contained allocation are also lost but        */
;*    it does not change anything on the allocation itself.            */
;*---------------------------------------------------------------------*/
(define-method (loose-alloc! alloc::create-vector-app)
   (with-access::create-vector-app alloc (lost-stamp value-approx stackable?)
      (if (=fx lost-stamp *cfa-stamp*)
	  #unspecified
	  (begin
	     (trace (cfa 2) " *** loose: " (shape alloc) #\Newline)
	     (trace (cfa 3) "     value: " (shape value-approx) #\Newline)
	     (set! lost-stamp *cfa-stamp*)
	     (set! stackable? #f)
	     (for-each-approx-alloc loose-alloc! value-approx)
	     (approx-set-type! value-approx *obj*)
	     (approx-set-top! value-approx)))))
   
;*---------------------------------------------------------------------*/
;*    stack-loose-alloc! ...                                           */
;*---------------------------------------------------------------------*/
(define-method (stack-loose-alloc! alloc::make-vector-app cowner)
   (with-access::make-vector-app alloc
	 (value-approx stackable? owner stack-stamp)
      (if (or (not stackable?) (memq cowner stack-stamp))
	  #unspecified
	  (begin
	     (set! stack-stamp (cons cowner stack-stamp))
	     (if (or (not (variable? cowner)) (eq? owner cowner))
		 (begin
		    (trace (cfa 2)
			   " *** stack-loose: " (shape alloc) #\Newline)
		    (trace (cfa 3)
			   "           value: " (shape value-approx) #\Newline)
		    (set! stackable? #f)
		    (for-each-approx-alloc (lambda (alloc)
					      (stack-loose-alloc! alloc 'all))
					   value-approx))
		 (for-each-approx-alloc (lambda (alloc)
					   (stack-loose-alloc! alloc cowner))
					value-approx))))))
   
;*---------------------------------------------------------------------*/
;*    stack-loose-alloc! ...                                           */
;*---------------------------------------------------------------------*/
(define-method (stack-loose-alloc! alloc::create-vector-app cowner)
   (with-access::create-vector-app alloc
	 (value-approx stackable? owner stack-stamp)
      (if (or (not stackable?) (memq cowner stack-stamp))
	  #unspecified
	  (begin
	     (set! stack-stamp (cons cowner stack-stamp))
	     (if (or (not (variable? cowner)) (eq? owner cowner))
		 (begin
		    (trace (cfa 2)
			   " *** stack-loose: " (shape alloc) #\Newline)
		    (trace (cfa 3)
			   "           value: " (shape value-approx) #\Newline)
		    (set! stackable? #f)
		    (for-each-approx-alloc (lambda (alloc)
					      (stack-loose-alloc! alloc 'all))
					   value-approx))
		 (for-each-approx-alloc (lambda (alloc)
					   (stack-loose-alloc! alloc cowner))
					value-approx))))))
   
;*---------------------------------------------------------------------*/
;*    node-key ...                                                     */
;*---------------------------------------------------------------------*/
(define-method (node-key app::pre-make-vector-app)
   (with-access::pre-make-vector-app app (key)
      key))

;*---------------------------------------------------------------------*/
;*    node-key-set! ...                                                */
;*---------------------------------------------------------------------*/
(define-method (node-key-set! app::pre-make-vector-app new-key)
   (with-access::pre-make-vector-app app (key)
      (set! key new-key)))

;*---------------------------------------------------------------------*/
;*    node-key ...                                                     */
;*---------------------------------------------------------------------*/
(define-method (node-key app::make-vector-app)
   (with-access::make-vector-app app (key)
      key))

;*---------------------------------------------------------------------*/
;*    node-key ...                                                     */
;*---------------------------------------------------------------------*/
(define-method (node-key app::pre-create-vector-app)
   (with-access::pre-create-vector-app app (key)
      key))

;*---------------------------------------------------------------------*/
;*    node-key-set! ...                                                */
;*---------------------------------------------------------------------*/
(define-method (node-key-set! app::pre-create-vector-app new-key)
   (with-access::pre-create-vector-app app (key)
      (set! key new-key)))

;*---------------------------------------------------------------------*/
;*    node-key ...                                                     */
;*---------------------------------------------------------------------*/
(define-method (node-key app::create-vector-app)
   (with-access::create-vector-app app (key)
      key))
 
;*---------------------------------------------------------------------*/
;*    stack! ::make-vector-app ...                                     */
;*---------------------------------------------------------------------*/
(define-method (stack! node::make-vector-app)
   (with-access::make-vector-app node (fun args stackable? lost-stamp)
      (trace (cfa 2)
	     "stack(make-vector-app): s?: " stackable? #\Newline)
      (stack*! args)
      (node-heap->stack! node (and (=fx lost-stamp -1) stackable?))))

;*---------------------------------------------------------------------*/
;*    stack! ::create-vector-app ...                                   */
;*---------------------------------------------------------------------*/
(define-method (stack! node::create-vector-app)
   (with-access::create-vector-app node (fun args stackable? lost-stamp)
      (trace (cfa 2)
	     "stack(create-vector-app): s?: " stackable? #\Newline)
      (stack*! args)
      (node-heap->stack! node (and (=fx lost-stamp -1) stackable?))))


