;; sample test file to be used for STEPPER package
;; see README for a documentation 

;; macros work as well:
(define-macro (plus m n)
  `(+ ,m ,n))


;; just to play a little...
(define (minus x y) (- x y))

;; define-step is like define, except that call to fib 
;; will result in  stepping through the calls to fib
;; note: define-step is superfluous (define would be the same) 
;; if this file is loaded via
;; (loads "fib.scm") 
;;
(define-step (fib n)
  ;; optional breakpoint (is this feature needed at all?)
  (break "break - Enter fib of " n)
  (if (< n 2) 1 
      (plus
       (fib (minus n 1)) 
       (fib (minus n 2)))))

;; here another test:

(define (inc arg)
  (assert (arg) (number? arg))
  (+ arg 1))

(define (fac-iter n)
  (define (ge m n) (>= m n))
  (do ((i 1 (+ i 1))
       (res 1 (* res (inc i)))
       )
      ((ge i n) res)
    ))

