/* _dloac.c
 * (c) Alexandre Frey 1996
 *
 * interface btw dlink and unit.scm
 *
 */

#include "dlink.h"
#include <bigloo.h>
#include <stdlib.h>

#include <sys/stat.h>
#include <unistd.h>

extern void * GC_malloc_uncollectable(size_t size_in_bytes);
extern void GC_free(void * object_addr);
typedef void (*GC_finalization_proc)(void * obj, void * client_data);
void GC_register_finalizer(void * obj,
			   GC_finalization_proc fn, void * cd,
			   GC_finalization_proc *ofn, void ** ocd);

/*
 * Bigloo maintain all foreign objects in an hash table
 * to make eq? work correctly but tha make them unGC'able
 * So we must get around and allocate foreign objects
 * without register them
 * Is there a standard way to replace this hack ???
 */
extern obj_t make_foreign (obj_t id, void* value);

#define to_foreign(c_id, value) \
  (make_foreign (c_string_to_symbol ((c_id)), (value)))

extern void notify_error (char*, char*, char*);

void warning (char* desc, char* hints)
{
  notify_error ("UNIT-WARNING", desc, hints);
  free (hints);
}

void error (char* desc, char* hints)
{
  obj_t bhints = c_string_to_string (hints);
  free (hints);
  the_failure (c_constant_string_to_string("UNIT_ERROR"), 
	       c_string_to_string (desc), bhints);
}

void dload_init (char* static_map_filename) 
{
  dlink_init (malloc, free,
	      GC_malloc_uncollectable, GC_free,
	      error, warning,
	      static_map_filename);
}

/* When a unit is collected, free the associated structures */
static void
finalize_unit (struct dlink_info* info, void* dummy)
{
#ifdef DEBUG
  fprintf (stderr, "Finalizing %lx\n", (long)info);
#endif
  dlink_info_release (info);
}


obj_t make_unit (void) 
{
  /* Create a dlink_info structure */
  struct dlink_info *info 
    = (struct dlink_info*)GC_malloc (sizeof (struct dlink_info));

  /* Register the finalizer */
  GC_register_finalizer (info, (GC_finalization_proc)finalize_unit, 
			 NULL, 0, 0);

  /* Init the structure */
  dlink_info_init (info);
 
  /* and return the foreign object */
  return to_foreign ("UNIT", info);
}

obj_t get_symbol_value (struct dlink_info* info, char* c_name)
{
  return *((obj_t*)dlink_get_symbol_value (info, c_name));
}

void set_symbol_value (struct dlink_info* info, char* c_name, obj_t value)
{
  *((obj_t*)dlink_get_symbol_value (info, c_name)) = value;
}

obj_t call_initialisation_function (struct dlink_info*info, 
				    char* function_name)
{
  return ((obj_t (*)())dlink_get_symbol_value (info, function_name))();
}

/* Imprted from dload.scm */
extern void undefined_walker (const char*);

void walk_on_undefined (struct dlink_info *info)
{
  dlink_info_walk_on_undefined (info, undefined_walker);
}

/* return the difference of modification times btw f1 and f2 */
int file_mtime_compare (char* f1, char* f2) 
{
  struct stat s1, s2;
  stat (f1, &s1);
  stat (f2, &s2);
  return (s1.st_mtime - s2.st_mtime);
}

/* EOF : _dload.c */
