static char qhold_rcsid[]="qhold.c,v 1.2 1994/11/28 16:55:37 kerce Exp";
/***********************************************************
 *
 * Written By: Raju R. Lakhamraju 
 * Date: 7/2/94, 4/01/94, 6/17/94
 *
 * Based on Motif qmon by Jeff Snyder
 *
 * Major modifications: Removed motif calls and replaced
 *                     with athena widget set calls.
 *      Added several modules for new DQS commands.
 *
 * Copyright 1992, 1993, 1994
 *
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 *  SCRI representatives make no claims about the
 *  suitability of this software for any purpose.
 *  It is provided "as is" without express or
 *  implied warranty.
 *
 *  qhold.c,v
 * Revision 1.2  1994/11/28  16:55:37  kerce
 * *** empty log message ***
 *
 * Revision 1.3  1994/09/13  18:03:59  raju
 * *** empty log message ***
 *
 * Revision 1.2  1994/08/21  02:59:18  raju
 * *** empty log message ***
 *
 * Revision 1.1  1994/07/11  15:29:34  raju
 * Initial revision
 *
 *
 *
 **********************************************************/

#include "globals.h"
static Widget           qhold_popup;
static Widget           widget_qholdrc;
static Widget           widget_qholdlabel;
static Widget           widget_qholdframe;
static Widget           widget_qholdmenu;
static Widget           widget_qholdmain;
static Widget           widget_qholdexec;
static Widget           widget_qholdclear;
static Widget           widget_qholdclose;
static Widget           widget_qholdseparator;
static Widget           widget_qholdopt;

struct optionstruct qholdmenu[]={
  0,"Hold User  ","-h u",  FLAGTYPE,"False",NULL,
  0,"Hold System","-h s",  FLAGTYPE,"False",NULL,
  0,"Hold Other ","-h o",  FLAGTYPE,"False",NULL,
  0,"No Hold    ","-h n",  FLAGTYPE,"False",NULL,
  0,"Help       ","-help",FLAGTYPE,"False",NULL,
  0,"Verify     ","-verify",FLAGTYPE,"False",NULL,
  0,"Job ID List",NULL,INPUTTYPE,NULL,NULL,
  0,NULL,NULL,(int)NULL,NULL,NULL
};


/***********************************************************
 * pb_qholdexec - Activate callback for exec
 */
XtCallbackProc pb_qholdexec(Widget w, caddr_t client_data, caddr_t call_data)
{
  buildcommand(QHOLD_BINARY,qholdmenu,0);
  sleep(1);
  UnMapIconWin ();
  refreshicons();
  MapIconWin ();
}


/***********************************************************
 * pb_qholdclear - Activate callback for clear
 */
XtCallbackProc pb_qholdclear(Widget w, caddr_t client_data, caddr_t call_data)
{
  clearsubmenu(qholdmenu);
}


/***********************************************************
 * pb_qholdclose - Activate callback for close
 */

XtCallbackProc pb_qholdclose(Widget w, caddr_t client_data, caddr_t call_data)
{
  closemainmenuwin();
}


/***********************************************************
 * create_qhold_dialog - Create widgets used for the qhold menu
 */
int create_qhold_dialog(Widget w,XtPointer client_data, XtPointer call_data)
{
  int             ii;
  Arg             args[32];
  Widget        qhold_form;
  Position    x, y;
  Dimension   width, height;
  Widget exec, clear, close;

  ii = 0;
  XtSetArg(args[0], XtNwidth, &width); ii++;
  XtSetArg(args[1], XtNheight, &height); ii++;
  XtGetValues(w, args, ii);
  XtTranslateCoords(w, (Position) (width / 2), (Position) (height / 2),
                    &x, &y);

  ii = 0;
  XtSetArg(args[ii], XtNx, x);                         ii++;
  XtSetArg(args[ii], XtNy, y);                         ii++;

  qhold_popup = XtCreatePopupShell("popup", transientShellWidgetClass, w,
                             args, ii);

  ii = 0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  qhold_form = XtCreateManagedWidget("form", formWidgetClass, qhold_popup,args,
ii);

  ii=0;
  XtSetArg(args[ii], XtNborderWidth, (Dimension) 0); ii++;
  widget_qholdlabel=
	XtCreateManagedWidget("Qhold",labelWidgetClass,qhold_form,args,ii);

  ii=0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  XtSetArg(args[ii], XtNfromVert, widget_qholdlabel); ii++;
  widget_qholdmain=XtCreateManagedWidget("box",formWidgetClass,qhold_form,
                                        args,ii);
  exec=QmonAddButtonN(widget_qholdmain,NULL,"Exec",(XtCallbackProc)pb_qholdexec,NULL);
  clear=QmonAddButtonN(widget_qholdmain,exec,"Clear",(XtCallbackProc)pb_qholdclear,NULL);
  close=QmonAddButtonN(widget_qholdmain,clear,"Close",(XtCallbackProc)pb_qholdclose,NULL);

  widget_qholdopt=createmenuoptions(qhold_form,widget_qholdmain,qholdmenu,(XtCallbackProc)NULL);
  
}


/***********************************************************
 * openwidget_qhold - Open the qhold menu
 */
int openwidget_qhold()
{
  XtPopup(qhold_popup,XtGrabNone);
}


/***********************************************************
 * closewidget_qhold - Close the qhold menu
 */
int closewidget_qhold()
{
  XtPopdown(qhold_popup);
}
