static char dqs_doc_rcsid[]="$Id: dqs_doc.c,v 1.1.1.1 1997/04/10 15:10:32 green Exp $";

/*----------------------------------------------------
 * dqs_doc.c Tom Green Mon Jan 31 10:42:42 1994
 *
 * Copyright 1993
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 * SCRI representatives make no claims about the
 * suitability of this software for any purpose.
 * It is provided "as is" without express or
 * implied warranty.
 *
 * $Log: dqs_doc.c,v $
 * Revision 1.1.1.1  1997/04/10 15:10:32  green
 * DQS 3.1.3.4.1 Distribution
 *
 * Revision 3.3  1996/11/20 23:03:32  nrl
 * Several fixes submitted by or as a result of investigations by
 * Ron Lee, Bodo Bechenback, Guntram Wolski and Frank Dwyyer.
 *
 * Revision 3.2  1996/06/27  01:55:47  nrl
 * changes to accomodate osf gcc
 *
 * Revision 3.1  1996/03/22  04:20:16  nrl
 * Added error cataloguing number to all routines
 *
 * Revision 3.0  1994/03/07  04:13:41  green
 * 3.0 freeze
 *
 * Revision 1.1.1.1  1994/02/01  17:57:39  green
 * DQS 3.0 ALPHA
 *
 *--------------------------------------------------*/

 
#define MAINPROGRAM
#include "h.h"
#include "def.h"
#include "dqs.h"
#include "struct.h"
#include "func.h"
#include "globals.h"
#include "dqs_errno.h"

dqs_list_type *Head=NULL;
FILE *fp;

/************************************************************************/
main(argc,argv,envp)
int argc;
char **argv;
char **envp;

{
     char c;
     string str;
     
     DENTER_MAIN((DQS_EVENT,"test"));
     
     argv++;
     
     while (argv[0])
     {
	  fp=fopen(argv[0],"r");
	  if (!fp) 
	  {
	       fprintf(stderr,"couldn't open %s",argv[0]);
	  }
	  
	  while (fscanf(fp,"%[^\n]",str)!=EOF)
	  {
	       if (!strncmp(str,"/**************************",15))
	       {
		    c=getc(fp);
		    if (c==EOF)
		    break;
		    insert(argv[0]);
	       }
	       bzero((char *)str,sizeof(str));
	       c=getc(fp);
	       if (c==EOF)
	       goto next;
	  }
	next:
	  argv++;
     }
     
     printf("writing ASCII version in \"doc\"\n");
     dqs_write_ascii("doc",Head);
     
     printf("writing LATEX version in \"dqs_doc.tex\"\n");
     dqs_write_tex("dqs_doc.tex",Head);
     
     dqs_write_man("../MAN/man3",Head);

     printf("---Done---\n");
     
     exit(0);
     
}

/*********************************************************************/
int insert(file)
char *file;

/*
   insert() sticks shit
   i
   ya know?
   */

{
     
     char          c;
     string type_str,func_str,str;
     char *func_ptr;
     dqs_list_type listel;
     dqs_list_type listel_chain;
     
     DENTER((DQS_EVENT,"insert"));
     
     bzero((char *)type_str,sizeof(type_str));
     bzero((char *)func_str,sizeof(func_str));
     bzero((char *)str,sizeof(str));
     
     fscanf(fp,"%s %s[^\n]",type_str,func_str);
     
     bzero((char *)&listel,sizeof(listel));
     listel.str0=dqs_string_insert(NULL,type_str);
     func_ptr=func_str;
     if (func_str[0]=='*')
     {
	  func_ptr++;
	  listel.str1=dqs_string_insert(NULL,"*");
     }
     else
     listel.str1=dqs_string_insert(NULL,"");
     
     listel.str2=dqs_string_insert(NULL,func_ptr);
     
     listel.str3=dqs_string_insert(NULL,file);
     
     c=getc(fp);
     if (c==EOF)
     return(EOF);
     
     while (fscanf(fp,"%[^\n]",str)!=EOF)
     {
          if (!strncmp(str,"{",1))
          {
	       Head=dqs_insert(DQS_STR2,ASCENDING,Head,&listel);
               c=getc(fp);
               if (c==EOF)
               return(EOF);
	       return(0);
          }
	  bzero((char *)&listel_chain,sizeof(listel_chain));
	  listel_chain.str0=dqs_string_insert(NULL,str);
          bzero((char *)str,sizeof(str));
	  listel.chain=dqs_insert(DQS_STR0,TAIL,listel.chain,&listel_chain);
          c=getc(fp);
          if (c==EOF)
          return(EOF);
     }
     
     return(0);
     
}

/********************************************/
int dqs_write_ascii(file_name,head)
char *file_name;
dqs_list_type *head;

{
     
     FILE *fp;
     dqs_list_type *lp;
     dqs_list_type *lp2;
     
     DENTER((DQS_EVENT,"dqs_write_ascii"));
     
     fp=fopen(file_name,"w");
     if (!fp)
     {
	  CRITICAL((DQS_EVENT,"DQS_ERROR_0208 error: could not open \"%s\"",file_name));
	  exit(-1);
     }
 
     fprintf(fp,"******************************************************\n");
     fprintf(fp,"WARNING! THIS FILE WAS GENERATED AUTOMATICALLY BY dqs_doc\n");
     fprintf(fp,"DO NOT EDIT! CHANGES MADE TO THIS FILE WILL BE LOST!\n");

     while (head)
     {
	  fprintf(fp,"******************************************************\n");
	  fprintf(fp,"%s;\t\t%s\n\n",head->str2,head->str3);
	  fprintf(fp,"%s\t ",head->str0);
	  if (head->str1)
	  fprintf(fp,"%s",head->str1);
	  fprintf(fp,"%s\n",head->str2);
	  lp=head->chain;
	  while (lp)
	  {
               if (lp->str0)
	       {
		    if (strstr(lp->str0,"/*"))
		    {
			 lp=lp->next;
			 continue;
		    }
		    if (strstr(lp->str0,"*/"))
		    {
                         lp=lp->next;
                         continue;
                    }
		    if (lp->str0)
		    fprintf(fp,"%s\n",lp->str0);
	       }
	       lp=lp->next;
	  }
	  head=head->next;
     }
     
     fclose(fp);
     DEXIT;
}

/********************************************/
int dqs_write_tex(file_name,head)
char *file_name;
dqs_list_type *head;

{
     
     int past_args;
     FILE *fp;
     string str;
     dqs_list_type *lp;
     
     DENTER_EXT((DQS_EVENT,"dqs_write_tex"));
     
     fp=fopen(file_name,"w");
     fprintf(fp,"%%******************************************************\n");
     fprintf(fp,"%%WARNING! THIS FILE WAS GENERATED AUTOMATICALLY BY dqs_doc\n");
     fprintf(fp,"%%DO NOT EDIT! CHANGES MADE TO THIS FILE WILL BE LOST!\n");
     
     while (head)
     {
	  fprintf(fp,"%%******************************************************\n");
	  past_args=FALSE;
	  DTRACE;
	  sprintf(str,"\\section{%s}\n",head->str2);
	  tex_printf(fp,str);
	  sprintf(str,"{\\bf~File %s}\n\n",head->str3);
          tex_printf(fp,str);
	  sprintf(str,"{\\bf~%s %s%s}\n\n",
		  head->str0,head->str1,head->str2);
          tex_printf(fp,str);
          lp=head->chain;
          while (lp)
          {
	       if (!lp->str0) 
	       past_args=TRUE;
               if (lp->str0)
               {
		    DTRACE;
                    if (strstr(lp->str0,"/*"))
                    {
                         lp=lp->next;
                         continue;
                    }
                    if (strstr(lp->str0,"*/"))
                    {
                         lp=lp->next;
                         continue;
                    }
		    DTRACE;
	       }
	       if (past_args)
	       {
		    if (lp->str0)
		    sprintf(str,"%s\n\n",lp->str0);
		    else
		    sprintf(str,"\n\n");
	       }
	       else
	       {
		    if (lp->str0)
		    sprintf(str,"{\\sf~%s}\n\n",lp->str0);
		    else
		    sprintf(str,"{\\sf~NULL-NULL}\n\n",lp->str0);
	       }
	       tex_printf(fp,str);
               lp=lp->next;
          }
          head=head->next;
     }
     
     fclose(fp);
}

/***********************************************************/

int tex_printf(fp,str)
FILE *fp;
char *str;

{
     
     char *cp;
     cp=str;
     
     while (cp[0])
     {
	  if (cp[0]=='_')
	  fprintf(fp,"\\_");
	  else
	  fprintf(fp,"%c",cp[0]);
	  cp++;
     }
     
}

/********************************************/
int dqs_write_man(file_prefix,head)
char *file_prefix;
dqs_list_type *head;

{
     
     int           past_args;
     int           synopsis;
     char          *cp;
     FILE          *fp;
     u_long32      now;
     string        str;
     string        name;
     string        fname;
     dqs_list_type *lp;
     dqs_list_type *lp2;
     
     DENTER((DQS_EVENT,"dqs_write_man"));
     
     now=dqs_get_gmt();

     while (head)
     {
	  past_args=FALSE;
	  synopsis=FALSE;
	  bzero((char *)fname,sizeof(fname));
	  sprintf(fname,"%s/",file_prefix);
	  cp=dqs_string_insert(NULL,head->str2);
	  cp=strtok(cp,"(");
	  strcat(fname,cp);
	  strcat(fname,".3");
	  sprintf(name,"%s",cp);
	  printf("writing file \"%s\"\n",fname);
	  fp=fopen(fname,"w");
	  if (!fp)
	  {
	       CRITICAL((DQS_EVENT,"DQS_ERROR_0209 error: could not open \"%s\"",fname));
	       exit(-1);
	  }
	  fprintf(fp,".\\\" ******************************************************\n");
	  fprintf(fp,".\\\" WARNING! THIS FILE WAS GENERATED AUTOMATICALLY BY dqs_doc\n");
	  fprintf(fp,".\\\" DO NOT EDIT! CHANGES MADE TO THIS FILE WILL BE LOST!\n");
          fprintf(fp,".\\\" ******************************************************\n");
	  fprintf(fp,".TH \"%s\" 3 \"%s\" \"dqs_doc %s\"\n",cp,dqs_ctime(now),head->str3); 
	  fprintf(fp,".SH \"NAME\"\n");
	  fprintf(fp,"%s \\- ",name);
	  if (head->str1)
	  fprintf(fp,"%s",head->str1);
	  fprintf(fp,"%s\n",head->str2);
	  fprintf(fp,".SH \"SYNOPSIS\"\n.ft B\n");
          fprintf(fp,"%s  ",head->str0);
	  if (head->str1)
	  fprintf(fp,"%s",head->str1);
	  fprintf(fp,"%s\n",head->str2);
	  fprintf(fp,".ft R\n.SH \"PARAMETERS\"\n.br\n");
          lp=head->chain;
          while (lp)
          {
               if (!lp->str0) 
               past_args=TRUE;
               if (lp->str0)
               {
                    DTRACE;
                    if (strstr(lp->str0,"/*"))
                    {
                         lp=lp->next;
                         continue;
                    }
                    if (strstr(lp->str0,"*/"))
                    {
                         lp=lp->next;
                         continue;
                    }
                    DTRACE;
               }
               if (past_args)
               {
		    if (!synopsis)
		    {
			 fprintf(fp,".ft R\n.SH \"DESCRIPTION\"\n.br\n");
			 synopsis=TRUE;
		    }
                    if (lp->str0)
                    sprintf(str,"%s\n",lp->str0);
                    else
                    sprintf(str,"\n");
               }
               else
               {
                    if (lp->str0)
                    sprintf(str,".br\n%s\n",lp->str0);
                    else
                    sprintf(str,"\\fBNULL-NULL\\fR\n");
               }
               fprintf(fp,"%s",str);
               lp=lp->next;
	  }
	  fclose(fp);
	  head=head->next;
     }
     
     fclose(fp);
     DEXIT;
}


