#ifndef __HEADER_h_
#define __HEADER_h_


#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include <errno.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <pwd.h>
#include "dqs.h.proto"
#include "func.h"


/*******************DEFINES*******************/
#define DTRACE           if (DEBUG_ON) printf("%6d %s:%d  \n",DEBUG_TRACEID++,__FILE__,__LINE__)
#define DPRINTF(x)       if (DEBUG_ON) printf("%6d %s :%d  ",DEBUG_TRACEID++,__FILE__,__LINE__), printf x
#define DTRACEID(x)      if (DEBUG_ON) DEBUG_TRACEID=x
#define err_crit(x)        {printf("%6d ",DEBUG_TRACEID++);printf(x);printf("  %s:%d\n",__FILE__,__LINE__);kill(getpid(),SIGINT);}
#define err_cont(x)         if (DEBUG_ON) {printf("%6d\t\t\t %s:%d  ",DEBUG_TRACEID++,__FILE__,__LINE__);printf("\t\t");printf(x);printf(" errno ==%d\n",errno); }
#define PUT_NULL(x)  x[strlen(x)] = '\0'
#define PUT_NULLN(x)  x[(strlen(x)-1)] = '\0'
#define is_empty(x)   (strlen(x) == 0)? 1:0
#define MAXSTR 256
#define MAXLEN 1024
#define MAKEFILE_BODY  "make.body"
#define MAKEFILE       "../Makefile"  /* main dqs Makefile*/
#define MALLOC_STR(x)  if(!(x = (char*)malloc(MAXLEN))){err_crit("Can't malloc \n");}


/* Thanks solaris....yeah I know they have memset, but I'd have to # ifdef it */
#define jbzero(xstr,len) {for(no_fkn_bzero=0;no_fkn_bzero<len;no_fkn_bzero++) xstr[no_fkn_bzero]='\0';}
#ifndef TRUE
#define TRUE  1
#endif

#ifndef FALSE
#define FALSE 0
#endif

#if (defined( solaris) || defined(SOLARIS23)|| defined(SOLARIS24) || defined(SOLARIS25))
#ifdef bcmp
#undef bcmp
#endif
#define bcmp(s1, s2, n) memcmp ((s1), (s2), (n))

#ifdef bcopy
#undef bcopy
#endif
#define bcopy(s, d, n)  memcpy ((d), (s), (n))

#ifdef bzero
#undef bzero
#endif
#define bzero(s, n)     memset ((s), 0, (n))

#ifdef index
#undef index
#endif
#define index(s, c) strchr(s, c)

/* this is no longer used in solaris, but then we have no rusage-information */
#ifdef wait3
#undef wait3
#endif
#define wait3(s, o, r) waitpid(-1, s, o)

#endif

typedef enum {
              t_static_configuration=0,
              t_has_automounter,
              t_automounter_prefix,
              t_use_AFS,
              t_klog,
	      t_reauth_time,
	      t_use_reserved_port,
	      t_qmaster_service,
	      t_keep_qmaster_entry,
	      t_dqs_execd_service,
	      t_keep_dqs_execd_entry,
	      t_intercell_service,
	      t_keep_intercell_entry,
	      t_mailer,
	      t_mail_has_subj_line,
	      t_administrator,
	      t_default_manager,
	      t_administrator2,
	      t_logmail,
	      t_default_rerun,
              t_default_account,
              t_default_sort_seq_no, 
              t_sync_io,
              t_user_access,
              t_logfacility,
              t_loglevel,
              t_min_uid,
              t_min_gid,
              t_load_log_time,
              t_max_unheard,
              t_schedule_time,
              t_stat_log_time,
              t_maxujobs,
              t_output_handling,
              t_addon_script,
              t_addon_info,
              t_copy_file_delay,
              t_link_file_path,
              t_slave_loop_time,
              t_pvm_root,
              t_alarms,
              t_alarmm,
              t_alarml,
              t_bin_dir,
              t_conf_dir,
              t_qmaster_spool_dir,
              t_dqs_execd_spool_dir,
              t_doc_dir,
              t_lib_dir,
              t_man1_dir,
              t_man3_dir,
              t_dqs_root,
              t_dqs_sysgrp,
              t_root,
              t_sysgrp,
              t_simple_install,
              t_default_install,
              t_user_cwd,
              t_list_end
} get_type_t;


/***************GLOBAL VARS********************/

#ifdef MAINPROGRAM
int SIMPLE_INSTALL;
int DEBUG_TRACEID;
int DEBUG_ON;
int I_AM_ROOT;

char  NCONF_FILE[MAXSTR];
char  NRESOLVE_FILE[MAXSTR];
char  NKEY_FILE[MAXSTR];

char    *cflags,
        *lflags,
        *install_dir,
        *bin_dir,
        *conf_dir,
        *doc_dir,
        *lib_dir,
        *man1_dir,
        *man3_dir,
        *root,
        *dqs_root,
        *sysgrp,
        *dqs_sysgrp,
        *cc,
        *static_configuration, /* begin dqs.h vars*/
        *conf_file,
        *resolve_file,
        *key_file,
        *afs,
        *klog,
        *reauth_time,
        *log_file,
        *err_file,
        *execd_spool_dir,
        *qmaster_spool_dir,
        *dqs_execd_service,
        *qmaster_service,
        *intercell_service,
        *reserved_port,
        *mailer,
        *dqs_bin,
        *administrator,
        *default_rerun,
        *log_mail,
        *mail_has_subj_line,
        *default_sort_seq_no,
        *sync_io,
        *default_account,
        *default_manager,
        *default_manager2,
        *user_access,
        *min_uid,
        *min_gid,
        *maxujobs,
        *output_handling,
        *addon_script,
        *addon_info,
        *alarms,
        *alarml,
        *alarmm,
        *logfacility,
        *loglevel,
        *default_cell,
        *load_log_time,
        *schedule_time,
        *stat_log_time,
        *max_unheard,
        *automount,
        *dshd_service,
        *user_cwd,
        *copy_file_delay,
        *link_file_path,
        *slave_loop_time,
        *pvm_root,
        *default_host;

int has_manager2;
int has_automount;
int no_fkn_bzero;
int qmaster_service_num;
int dqs_execd_service_num;
int intercell_service_num;
int dshd_service_num;
int num_in_exec_matrix;
int already_has_port_nums;
char *base_user_cwd;
char *exec_matrix[MAXSTR];


#else
extern int SIMPLE_INSTALL;
extern int DEBUG_TRACEID;
extern int DEBUG_ON;
extern int I_AM_HOST;

extern char    *cflags,
        *lflags,
        *install_dir,
        *bin_dir,
        *conf_dir,
        *doc_dir,
        *lib_dir,
        *man1_dir,
        *man3_dir,
        *root,
        *dqs_root,
        *sysgrp,
        *dqs_sysgrp,
        *cc,
        *static_configuration, /* begin dqs.h vars*/
        *conf_file,
        *resolve_file,
        *key_file,
        *afs,
        *klog,
        *reauth_time,
        *log_file,
        *err_file,
        *execd_spool_dir,
        *qmaster_spool_dir,
        *dqs_execd_service,
        *qmaster_service,
        *intercell_service,
        *reserved_port,
        *mailer,
        *dqs_bin,
        *administrator,
        *default_rerun,
        *log_mail,
        *mail_has_subj_line,
        *default_sort_seq_no,
        *sync_io,
        *default_account,
        *default_manager,
        *default_manager2,
        *user_access,
        *min_uid,
        *min_gid,
        *maxujobs,
        *output_handling,
        *addon_script,
        *addon_info,
        *copy_file_delay,
        *link_file_path,
        *slave_loop_time,
        *pvm_root,
        *alarms,
        *alarml,
        *alarmm,
        *logfacility,
        *loglevel,
        *default_cell,
        *load_log_time,
        *schedule_time,
        *stat_log_time,
        *max_unheard,
        *automount,
        *dshd_service,
        *user_cwd,
        *default_host;

extern int has_manager2;
extern int has_automount;
extern int no_fkn_bzero;
extern int qmaster_service_num;
extern int dqs_execd_service_num;
extern int intercell_service_num;
extern int dshd_service_num;

extern int num_in_exec_matrix;
extern int already_has_port_nums;

extern char *exec_matrix[MAXSTR];

extern char  NCONF_FILE[MAXSTR];
extern char  NRESOLVE_FILE[MAXSTR];
extern char  NKEY_FILE[MAXSTR];

#endif
typedef struct gett {
	get_type_t  sanity;
        char message[256];
	char tdefault[256];
	char description[256];
	char reference[256];
} getmsg_t;





/*Makefile define defaults */

#define DQS_ROOT    "0"
#define DQS_SYSGRP  "0"
#define CC         "cc"
#define ROOT       "0"
#define SYSGRP     "0"
#define INSTALL_DIR "DQS"

#define BIN_DIR     "bin"
#define CONF_DIR    "common/conf"
#define QMASTER_DIR  "common/conf"
#define DQS_EXECD_DIR "common/conf"
#define DOC_DIR     "common/doc"
#define LIB_DIR     "local/lib"
#define MAN1_DIR    "man/man1"
#define MAN3_DIR    "man/man3"



#endif


