/*
 * image.c
 *
 * Boot image stuff/misc stuff.
 * 
 * Copyright (c) Tuomo Valkonen 1996-1997.
 */
 
#include<stdio.h>
#include<strings.h>
#include<sys/types.h>
#include<sys/stat.h>
#include<fcntl.h>
#include<errno.h>
#include<linux/fs.h>
#include<unistd.h>

#include<chos/chos.h>
#include<chos/main.h>
#include<chos/image.h>
#include<chos/install.h>
#include<chos/map.h>

/*
 * Set delay...
 */
void do_delay( char *delaystr )
{
	char *endptr;
	int  pos=0;
	
	mh->delay=strtoul(delaystr,&endptr,0);
  	
  	if(*endptr){
  		if(strcasecmp(delaystr,"off"))
  			cfgsyntax(NULL);
  		mh->delay=255;	// off
  		verbose("Delay set off.\n");
    	}else if(mh->delay>127)
    		die(-1,"Delay must be 0<delay<128.\n");
 	else
	 	verbose("Delay set to %d seconds.\n",mh->delay);
  		
}


/*
 * Set install destination...
 */
void do_install( char *inst_str )
{
	int pos=0;
	char a;
	struct stat st;
	
	while((a=inst_str[pos])!='\0'){
				
		if( a=='\\' || a==':' || a=='*' || a=='?' || a=='\t' || a==32 )
			cfgsyntax(NULL);
		else instdest[pos]=a;
		
	 	pos++;
	 	
	 	if( pos>255 ){
	 		die(-1,"ERROR: Install dest. path too long !!");
	 	}
	}
	instdest[pos]='\0';
	if(pos==0)cfgsyntax(NULL);
	
	if(testing)
		return;
	
	if(stat(instdest,&st)<0)
		die(errno,"%s\n",instdest);
		
	if(!S_ISBLK(st.st_mode) && !S_ISREG(st.st_mode))
		die(-1,"%s is not a valid file for bootsector to be installed on..\n");

	verbose("Choose-OS will install its bootsector on %s\n",instdest);
	return;
}


void do_autoboot(char*str)
{
	if(!strcasecmp(str,"no"))
		mh->autoboot=AUTOBOOT_NO;
	else if(!strcasecmp(str,"pressed"))
		mh->autoboot=AUTOBOOT_PRESSED;
	else if(!strcasecmp(str,"not_pressed") || !strcasecmp(str,"not pressed"))
		mh->autoboot=AUTOBOOT_NOT_PRESSED;
	else
		cfgerror("Expected no,pressed or not_pressed");
		
	if(mh->autoboot==AUTOBOOT_NO)
		verbose("Autoboot disabled\n");
	else
		verbose("Autoboot will happen when a modifier key is %s\n",str);
};

/*
 * Gets the emergency boot sector.
 */
void do_emergency(char *str)
{
#ifdef SUPPORT_EMERGENCY
	int 		fd;
	struct stat 	st;
	GEOMETRY 	geo;
	
	if(emerg_dev!=0xff)
		die(-1,"Emergency bootsector already set !\n");

	if( (fd=open(str,O_RDONLY))<0)
		die(errno,str);
	
	if(fstat(fd,&st)<0)
		die(errno,str);
	
	if(S_ISREG(st.st_mode)){
		if(lseek(fd,0,SEEK_END)!=512)
			die(-1,"%s is not 512 bytes\n",str);

	}else if(!S_ISBLK(st.st_mode))
		die(-1,"%s:Not a valid block device/regular file!",str);

	if(!get_device(fd,&geo))
		die(errno,str);
	emerg_sect=get_addr(fd,0,&geo);
	emerg_dev=geo.device;
	VER_BIOS(&geo,emerg_sect,str);
	
	verbose("Emergency bootsector set to %s\n",str);

	close(fd);
#else
	die(-1,"Emergency bootsector option not compiled in. Please recompile.\n");
#endif	
}

void do_password(char*pass)
{
	if(strlen(pass)>MAX_PASSWD_LEN)
		die(-1,"Password too long!\n");

	if(mh->passwd[0])
		die(-1,"Password already set!\n");

	strcpy(mh->passwd,pass);

	fprintf(stderr,	"\n\007PASSWORD SET!\n"
			"Make sure that chos mapfile and "
			"configuration file are not world readable.\n");
}

// Set default image number
void do_default(char*str)
{
	char *endptr;
	int  pos=0;
	int  def;

	def=strtoul(str,&endptr,0);
  	
  	if(*endptr)
		die(-1,"Expected: numeric value\n");
   	
	if(def==0)
		mh->default_image=0;
	else
		mh->default_image=def-1;

	verbose("Image #%d will be default\n",mh->default_image+1);
}

/*
 * Adds image to image descriptor table.
 */
MF_ImageDes* get_free_image()
{
	MF_ImageDes*	i;
	
	if(mh->nimages>=MAX_IMAGES)
		die(-1,"ERROR: Max. number of boot images is 10.");
	
	i=&(im->images[mh->nimages]);
	mh->nimages++;
	i->color=7;
	i->x=0xff;i->y=0xff;
	i->loader=0xff;i->device=0xff;
	
	if(mh->nimages>10)
		i->hotkey='A'+mh->nimages-10;
	else if(mh->nimages==10)
		i->hotkey='0';
	else
		i->hotkey='0'+mh->nimages;
	
	return i;
}

MF_ImageDes*		current_image=NULL;
struct imagestr_struct*	current_cfgimage=NULL;

void new_image(char*str,struct imagestr_struct*t)
{
	int	i;
	
	if(*str!='\"')
		cfgsyntax("Expected: \"");
		
	str++;
	
	current_cfgimage=t;
	current_image=get_free_image();
	
	current_image->type=current_cfgimage->type;
		
	for(i=0;i<=MF_NAME_LEN;i++,str++){
		if(*str=='\"'){
			if(i==0)
				cfgsyntax("Expected: image name");
			if(current_image->name[i-1]=='\\')
				i--;
			else
				break;
		}
		current_image->name[i]=*str;
	}
	if(i>MF_NAME_LEN)
		cfgerror("image name too long");
		
	while(i<=MF_NAME_LEN)
		current_image->name[i++]='\0';
		
	if(*str!='\"')
		cfgsyntax("Expected: \"");
		
	str=strip_whitespace(str+1);
	
	if(*str!='{' || *(str+1)!='\0')
		cfgsyntax("Expected: {\\n");
		
	verbose("\nAdding %s \"%s\"...\n",current_cfgimage->name,current_image->name);

	if(!view)
		current_cfgimage->init(current_image);
}

void end_image()
{
	if(!view)
		current_cfgimage->end(current_image);
}

// 
// Image config
//

void do_image_color(MF_ImageDes*img,char*colorstr)
{
	img->color=get_color(colorstr,NULL);

	verbose("\tColor set to %s on %s...\n",
		color_list[img->color&0xf],
		color_list[(img->color>>4)&0x7]);
}

void do_image_hotkey(MF_ImageDes*img,char*hotstr)
{
	uchar	key;
	int	ok=0;
	
	if(!(key=*hotstr))
		cfgerror("Expected: key");
		
	if(*(hotstr+1)){
		if(!strcmp(hotstr+1,",hidden"))
			img->flags|=CF_HOT_HIDDEN;
		else
			cfgerror("Syntax: <key>[,hidden]");
	}
	
	if(key>='0' && key<='9')
		ok=1;
	else if(key>='A' && key<='Z')
		ok=1;
	else if(key>='a' && key<='z'){
		key-=97-65;
		ok=1;
	}
	if(!ok)
		cfgerror("Hotkey must be 0-9,A-Z.");
	
	for(ok=0;ok<mh->nimages-1;ok++){
		if(im->images[ok].hotkey==key)
			cfgerror("Hotkey \'%c\' already used by \"%s\"",
				key,im->images[ok].name);
	}		
	img->hotkey=key;
	verbose("	Hotkey set to \'%c\' %s\n",key,
			((img->flags&CF_HOT_HIDDEN)?"(hidden)":""));
}

void do_image_position(MF_ImageDes*img,char*str)
{
	get_coord(str,&(img->x),&(img->y));
	
	if(img->x+strlen(img->name)>80)
		cfgerror("Image x-coordinate invalid (would wrap)");

	verbose("	Position set to %d,%d\n",img->x,img->y);
}

void do_image_loader(MF_ImageDes*img,char*str)
{
	static char typestr[50];
	if(img->loader!=0xff)
		die(-1,"Loader already set for image.\n");
		
	sprintf(typestr,"User specified loader (0x%02x)",CHOS_MODULE(img->type));
	img->loader=get_loader(str,CHOS_MODULE(img->type),typestr);
}

void do_image_pass(MF_ImageDes*img,char*str)
{
	if(!*str)
		die(-1,"Argument expected\n");

	if(img->flags&(CF_RESTRICTED|CF_NOPASS))
		die(-1,"Duplicate image::password\n");

	if(!strcmp(str,"yes"))
		return;
	if(!strcmp(str,"no")){
		img->flags|=CF_NOPASS;
		verbose("\tPassword disabled for this image.\n");
		return;
	}
	if(strcmp(str,"restricted") && strcmp(str,"cmdline"))
		die(-1,"Invalid argument (expected yes,no or restricted)\n");

	img->flags|=CF_RESTRICTED;
	verbose("\tPassword will be required to enter new command line.\n");
}

void do_ignore_rebooter_stuff(MF_ImageDes*img,char*str)
{
	return;
}

struct icfgstr_struct common_cfgs[]={
	{"color=",do_image_color},
	{"hotkey=",do_image_hotkey},
	{"position=",do_image_position},
	{"loader=",do_image_loader},
	{"password=",do_image_pass},
	{"rebooter.",do_ignore_rebooter_stuff},
	{NULL,}
};
	
void do_imagecfg(char*str)
{
	int			i,loop;
	struct icfgstr_struct*	cfg=current_cfgimage->cfg;
	char*			a;

	loop=0;

	while(1){
		while(cfg[loop].str){
			i=strlen(cfg[loop].str);
			if(strncasecmp(cfg[loop].str,str,i)){
				loop++;
				continue;
			}
			if(view){
				if(cfg[loop].doit!=do_image_color &&
				   cfg[loop].doit!=do_image_hotkey &&
				   cfg[loop].doit!=do_image_position)
				   	return;
			}
			a=strip_whitespace(str+i);
			if(!*a && cfg[loop].str[i-1]=='=')
				cfgerror("Argument expected");

		    	cfg[loop].doit(current_image,a);
			return;
		}
		if(cfg==common_cfgs)
			break;
		// Try the common ones.
		cfg=common_cfgs;
		loop=0;
	}
	
	if(cfg[loop].str==NULL)
		cfgsyntax("not a valid option for \"%s\"",current_cfgimage->str);
}

