/*
 * image-bsect.c
 *
 * Bootsector/Bootfile image stuff
 * 
 * Copyright (c) Tuomo Valkonen 1996-1997.
 */
 
#include<stdio.h>
#include<strings.h>
#include<sys/types.h>
#include<sys/stat.h>
#include<fcntl.h>
#include<errno.h>
#include<linux/fs.h>
 
#include<chos/chos.h>
#include<chos/main.h>
#include<chos/image.h>
#include<chos/install.h>
#include<chos/map.h>


/*
 * Adds a bootsector image to image table...
 */
void do_bsect_image(MF_ImageDes*img,char*name)
{
	int 		fd;
	char*		tmpptr;
	struct stat 	st;
	GEOMETRY 	geo;

	if(img->device!=0xff)
		cfgerror("Duplicate image=");
		
	if((fd=open(name,O_RDONLY))<0)
		die(errno,name);
	
	if(fstat(fd,&st)<0)
		die(errno,name);
		
	if(S_ISREG(st.st_mode)){
		if(lseek(fd,0,SEEK_END)!=512)
			die(-1,"sizeof(%s)!=512\n",name);
	}else if(!S_ISBLK(st.st_mode))
		die(-1,"%s:not a block device or regular file");

	if( !get_device(fd,&geo) )
		die(errno,name);

	img->device=geo.device;
	img->addr=get_addr(fd,0,&geo);
	verify_bios_read(&geo,img->addr);
	
	close(fd);
}

//
// TODO: Should add verification that the second drive exists...
//

void do_dos4boot(MF_ImageDes*img,char*str)
{
#ifndef SUPPORT_DOS4BOOT
	die(-1,"Dos4Boot support not compiled in. Please recompile.\n");
#else
	if(!strcmp(str,"yes")){
		img->flags|=BS_DOS4BOOT;
		verbose("\tDOS4+ will be told to boot off hdb.\n");
	}else if(!strcmp(str,"no")){
		verbose("\tDOS4+ will boot off hda\n");
		img->flags&=~BS_DOS4BOOT;
	}else
		cfgerror("Expected: yes or no\n");
#endif
}

void do_swap_x(MF_ImageDes*img,char*str,char flag,char*str2)
{
#ifndef SUPPORT_DRIVESWAP
	die(-1,"HD/FD swapping not compiled in. Please recompile.\n");
#else	
	if(!strcmp(str,"yes")){
		fprintf(stderr,"HD/FD SWAPPING IS UNTESTED.\n"
			"YOU'RE USING THIS FEATURE AT YOU OWN RISK\n");
		continue_yn();
		img->flags|=flag;
		verbose("\t%s will be swapped\n",str2);
	}else if(!strcmp(str,"no")){
		img->flags&=~flag;
		verbose("\t%s won't be swapped\n",str2);
	}else
		cfgerror("Expected: yes or no\n");
#endif		
}

void do_swaphd(MF_ImageDes*img,char*str)
{
	do_swap_x(img,str,BS_SWAPHD,"hda/hdb");
}

void do_swapfd(MF_ImageDes*img,char*str)
{
	do_swap_x(img,str,BS_SWAPFD,"fd0/fd1");
}

void do_rewrite(MF_ImageDes*img,char*name)
{
#ifndef SUPPORT_REWRITE
	die(-1,"Rewrite not enabled. Please recompile.\n");
#else
	int	device;
	int	fd;
	struct stat st;
	GEOMETRY geo;
	
	fprintf(stderr,"WARNING: MBR MAY BE REWRITTEN AT BOOTTIME !!!\n");
	continue_yn();
	
	if(img->rewrite_device)
		die(-1,"You can only rewrite one MBR at the moment.\n");
		
	if(!strcmp(name,"yes"))
		device=0x80;
	else{
		if((fd=open(name,O_RDONLY))<0)
			die(errno,name);
	
		if(fstat(fd,&st)<0)
			die(errno,name);
		
		if(!S_ISBLK(st.st_mode))
			die(-1,"%s:not a valid block device");

		if( !get_device(fd,&geo) )
			die(errno,name);

		if(geo.device<0x80)
			die(-1,"%s:Invalid device number (0x%02x). Not a harddisk?.",geo.device);

		if(get_addr(fd,0,&geo)!=0)
			die(-1,"%s:Offset of sector #0!=0. Is it a partition?\n");
		
#if 1
		if(geo.device!=0x80)
			die(-1,"TODO: support rewriting other than /dev/hda.\n");
#endif			
	}
	img->rewrite_device=device;
	verbose("\tMBR rewrite enabled for device 0x%02x\n",device);
#endif	
}

void do_dosmenukey(MF_ImageDes*img,char*str)
{
#ifndef SUPPORT_DOSMENUKEY
	die(-1,"DOSMenuKey support not compiled in. Please recompile.\n");
#else
	static unsigned short numbers[]={
		0x0b30,0x0231,0x0332,0x0433,0x0534,	// 0-3
		0x0635,0x0736,0x0837,0x0938,0x0a39	// 5-9
	};
	#define NNUMBERS	(sizeof(numbers)/sizeof(unsigned short))

	int n;
	unsigned short key;
	char*endptr;

	n=strtoul(str,&endptr,10);

	if(*endptr){
		if(*endptr!='x' && *endptr!='X')
			cfgerror("Invalid key.\n");
		key=strtoul(str,&endptr,16);
		if(*endptr)
			cfgerror("Invalid key.\n");
	}else{
		if(n>9)
			cfgerror("Invalid key.\n");
		key=numbers[n];
	}

	img->keypress=key;
	verbose("\tMenukey set to 0x%04x\n",key);
#endif
}

void do_bsect_init(MF_ImageDes*img)
{
	img->device=0xff;
}

void do_bsect_end(MF_ImageDes*img)
{
	if(img->device==0xff)
		die(-1,"no file specified for \"%s\"",img->name);

	if(img->loader==0xff)
		img->loader=get_loader("bsect",CHOS_MODULE(BIT_BOOTSECT),"Bootsector loader");
}

struct icfgstr_struct bfile_cfgs[]={
	{"image=",do_bsect_image},
	{"swaphd=",do_swaphd},
	{"swapfd=",do_swapfd},
	{"dos4boot=",do_dos4boot},
	{"rewrite=",do_rewrite},
	{"dosmenukey=",do_dosmenukey},
	{NULL,}
};

#define bsect_cfgs bfile_cfgs

struct imagestr_struct imgstr_bootfile=
	{"bootfile","bootfile", BIT_BOOTSECT,bfile_cfgs,do_bsect_init,do_bsect_end};
	
struct imagestr_struct imgstr_bootsect=
	{"bootsect","bootsector",BIT_BOOTSECT,bsect_cfgs,do_bsect_init,do_bsect_end};
