.\"
.\" $Id: xmbdfed.man,v 1.17 1997/12/30 18:08:40 mleisher Exp $
.\"
.TH XMBDFED 1 "28 December 1997" "X Version 11"
.SH NAME 
xmbdfed \- Motif-based BDF font editor

.SH SYNOPSIS
.B xmbdfed
[\fIoptions\fP] [\fIfonts ...\fP]

.SH DESCRIPTION
.I xmbdfed
lets you interactively create new bitmap font files or modify
existing ones.  It allows editing multiple fonts and multiple
glyphs, it allows cut and paste operations between fonts and
glyphs and editing font properties.
.I xmbdfed
can import Metafont PK/GF fonts, Han Bitmap Font Format (HBF), Linux console
fonts (PSF, CP, and EGA/VGA) fonts, Sun VF fonts, or grab a font from the X
server.

.I xmbdfed
works on X Window System Version 11 (X11), Release 5 or Release
6, with Motif 1.2.x or Motif 2.x.

.SH OPTIONS
.I xmbdfed
accepts the following command line arguments:

.PP
.TP 8
.I -nc
do not preserve comments (by default,
.I xmbdfed
automatically collects comments that are saved with the font)
.PP
.TP 8
.I -nu
do not preserve unencoded glyphs (by default,
.I xmbdfed
preserves the unencoded glyphs)
.PP
.TP 8
.I -nm
do not make metrics corrections (by default,
.I xmbdfed
attempts to make metrics corrections automatically)
.PP
.TP 8
.I -np
do not pad character-cell bitmaps (by default,
.I xmbdfed
pads character-cell bitmaps with 0's to the cell dimensions)
.PP
.TP 8
.I -bp
allow blank pages (by default,
.I xmbdfed
skips blank pages)
.PP
.TP 8
.I -ed
do not present the "Really Exit?" dialog (by default, this dialog always
presented)
.PP
.TP 8
.I -ps n
set default point size (if unspecified, 
.I xmbdfed
sets it to 12)
.PP
.TP 8
.I -hres n
set default horizontal resolution
.PP
.TP 8
.I -vres n
set default vertical resolution
.PP
.TP 8
.I -res n
set both default resolutions (if unspecified,
.I xmbdfed
sets both horizontal and vertical resolution to that of display,
(e.g. 90x90 dpi for Sun workstations)
.PP
.TP 8
.I -sp s
set the default font spacing ("p" for Proportional, "m" for Monospaced, or "c"
for Character Cell)

.SH FONT GRID

At the top of each editor window there are some
fields and buttons.  These are:
.IP
The "Font" text field is where the font name
is set so it can be edited.

The "Glyph" field is a label that provides
some information about glyph name, encoding, and
metrics when a glyph is selected.  When a range
of glyphs are selected, this field displays the
start and end codes of the range.

The push buttons are used to navigate through the
glyph pages.  The "Previous Page" and "Next Page"
buttons normally skip glyph pages that are empty,
but that can be changed using the "Setup" dialog.

The "Page" field indicates the current glyph page
and also allows a specific page number to be entered.
Once a page number is entered, pressing the Return
key will cause the Font Grid to shift to that page.
The page number entered is expected to be a decimal
number.

The "Code" field is provided for situations where
the page number is not known, but the encoding is
known.  The encoding entered in this field must be
in the base (8, 10, or 16) that is currently being
used to display glyph encodings (see the "View"
menu below).  Once the encoding is entered, pressing
the Return key will cause the Font Grid to shift to
the page containing the encoding.
.PP
The main window of each font editor is called the
.I Font Grid.
Each Font Grid has a clipboard used for passing glyphs around.
This clipboard is called 
.I FONTGRID_CLIPBOARD.
The format of the data stored to this clipboard is not documented yet.
.sp
When a glyph has been modified either by the user or
by automatic metrics corrections when the font is loaded,
the glyph code above the glyph cell will be highlighted.

.SH Font Grid Menus
The 
.I File
menu has the following entries:
.PP
.TP 8
.I New <Ctrl+N>
This creates a new font using the current defaults for point size, horizontal
and vertical resolution, and font spacing.
.PP
.TP 8
.I Open <Ctrl+O>
This opens a new font in the current Font Grid.  If the font in the grid has
been modified, the option to save the font before loading a new one will be
given.
.PP
.TP 8
.I Save <Ctrl+S>
Save the current font.  If the current font does not have a file name, a file
selection dialog will pop up so a file name can be entered.
.PP
.TP 8
.I Save As <Ctrl+W>
Save the current font with some other name.
.PP
The
.I Import
submenu of the
.I File
menu has the following entries:
.PP
.TP 8
.I PK/GF Font <Ctrl+K>
Import a Metafont PK or GF font.
.PP
.TP 8
.I Console Font <Ctrl+L>
Import a binary console font used by Linux and Sun (PSF, CP, vfont, and
other font formats).
.PP
.TP 8
.I HBF Font <Ctrl+H>
Import an HBF font.
.PP
.TP 8
.I Windows Font <Ctrl+B>
Import a Windows FON/FNT font.  This will also import fonts from .EXE
and .DLL files as well.
.PP
.TP 8
.I TrueType Font <Ctrl+Y>
Import a TrueType font (.ttf extension) or a collection (.ttc collection).
.PP
.TP 8
.I Server Font <Ctrl+G>
Import a font from the X server.
.PP
.TP 8
.I Exit/Close <Ctrl+F4>
Exit the program if this is the primary Font Grid or simply hide (unmap) the
current Font Grid window.
.PP
The 
.I Edit
menu has the following entries:
.PP
.TP 8
.I Copy <Ctrl+C> or <Button3Down>
This copies the current selection to the Font Grid clipboard.
.PP
.TP 8
.I Cut <Ctrl+X> or <Key>Delete or <Key>BackSpace
This copies the current selection to the Font Grid clipboard and
then deletes the selection.
.PP
.TP 8
.I Paste <Ctrl+V> or <Button2Down> or Shift<Button2Down>
This pastes the Font Grid clipboard at the currently selected
position.  If 
.I <Button2Down>
is used, the Font Grid clipboard will be pasted starting with the glyph cell
where the button was pressed.  If
.I Shift<Button2Down>
is used, the Font Grid clipboard will be inserted in front of the glyph cell
where the button was pressed.  Any glyphs that were moved past the 0xffff
encoding to make room for the clipboard contents will be moved to the
unencoded area.  This option always inserts, no matter what mode the font grid
is in.
.PP
.TP 8
.I Properties <Ctrl+P>
This invokes the font property editor.
.PP
.TP 8
.I Comments <Ctrl+M>
This invokes the font comments editor.
.PP
.TP 8
.I Font Info <Ctrl+I>
This invokes a dialog that allows changes to some of the font information so
these values do not have to be changed using the property editor.  These
values include the default character, font device width (for monowidth and
character cell fonts), font ascent and descent, font vertical and horizontal
resolution, and the font spacing.
.PP
The 
.I Font Name
submenu of the
.I Edit
menu has the following four entries:
.PP
.TP 8
.I Make XLFD Name
If the font does not have an XLFD name, this
will save the current font name in the
.I _ORIGINAL_FONT_NAME
font property and then generate an XLFD name
for the font.
.PP
.TP 8
.I Update Name From Properties
This will update the XLFD font name fields from
the font property list.
.PP
.TP 8
.I Update Properties From Name
This will update the font properties from the
XLFD font name.
.PP
.TP 8
.I Update Average Width
This will update the average width field of the
XLFD font name and will update the
.I AVERAGE_WIDTH
font property as a side effect.
.PP
.TP 8
.I Test Glyphs <Ctrl+Z>
This will toggle the glyph test dialog on or off for the editor.  When this is
active, selecting a glyph from any Font Grid will also add it to the glyph
test dialog.  When changes are made to a glyph or the font bounding box, the
glyph test dialog will be updated accordingly.
.sp
The glyph test dialog provides a toggle to turn the baseline on or off and
another toggle to draw from right to left instead of left to right.
.PP
.TP 8
.I Setup <Ctrl+T>
This will invoke the dialog to edit various settings
used by the editor such as the default point size, resolution and font
spacing.
.PP
The 
.I View
menu has the following entries:
.PP
.TP 8
.I Unencoded <Ctrl+E>
This will toggle between displaying the unencoded (glyphs with an
.I ENCODING
field of -1) and encoded glyphs.
.PP
.TP 8
.I Code Base
Selects displaying of glyph encoding.  Options are Octal
(base 8), Decimal (base 10) or Hexadecimal (base 16).
.PP
.TP 8
.I Messages <Ctrl+A>
This will show messages generated when corrections to the font metrics are
done or errors are encountered.
.PP
The
.I Operations
menu has the following entries:
.PP
.TP 8
.I Translate <Ctrl+D>
This will bring up the dialog for entering the X offset and Y offset used to
translate the glyph to a new location.
.sp
The option of translating the selected glyphs or all of the glyphs is
provided.
.PP
.TP 8
.I Rotate <Ctrl+R>
This will bring up the dialog for entering the rotation angle.  The rotation
is limited to between plus or minus 1 and 359 degrees.
.sp
The option of rotating the selected glyphs or all of the glyphs is provided.
.PP
.TP 8
.I Shear <Ctrl+J>
This will bring up the dialog for entering theangle of the shear.  The shear
is limited to plus or minus 45 degrees.
.sp
The option of rotating the selected glyphs or all of the glyphs is provided.
.PP
The 
.I Editors
menu has the following entries:
.PP
.TP 8
.I New <Ctrl+N>
This will cause a new editor to be created.
.PP
.TP 8
.I [editor list]
The remaining menu items are all the Font Grid's that have been
created.  Choosing one will force that window to be made visible (mapped)
and also put that window on top.

.SH Font Grid Other Features
Double clicking the mouse on one of the glyphs will start a Glyph Editor for
that glyph.
.sp
The font name can be edited in the Font Grid and page switching can be done
with the buttons on the Font Grid.

.SH GLYPH EDITOR
The
.I Glyph Editor
provides a simple bitmap editor
designed to edit glyph bitmaps and other glyph
information.  The Glyph Editors all use a special
clipboard used to pass bitmaps between the Glyph
Editors.  This clipboard is called
.I GLYPHEDIT_CLIPBOARD.
.sp
The only limit on the number of Glyph Editors that
can be open at one time is the amount of memory.

.SH Glyph Editor Menus
The
.I File
menu has the following entries:
.PP
.TP 8
.I Update <Ctrl+S>
This will update the Font Grid with the modified glyph.
.PP
.TP 8
.I Import XBM <Ctrl+I>
This will pop up a file selection dialog so an X Bitmap file (.xbm extension)
can be selected to be imported into the glyph editor.
.sp
The imported bitmap is handled the same way as bitmaps pasted.  They are
inserted as a selection with the move operation active and do not destroy any
bitmap that already exists in the editor.
.PP
.TP 8
.I Export XBM <Ctrl+O>
This will pop up a file selection dialog so that the glyph image can be
exported as an X Bitmap file (.xbm extension).
.PP
.TP 8
.I Close <Ctrl+F4>
This will close the Glyph Editor.
.PP
The
.I Edit
menu has the following entries:
.PP
.TP 8
.I Reload <Ctrl+L>
This will reload the glyph and discard any changes made in the GlyphEditor.
.PP
.TP 8
.I Resize <Ctrl+R>
This will allow changing the sizes of the glyph left/right bearings and the
glyph ascent/descent.
.PP
.TP 8
.I Copy <Ctrl+C>
This will copy the currently selected portion of the bitmap to the Glyph
Editor clipboard.
.PP
.TP 8
.I Cut <Ctrl+X>
This will copy the currently selected portion of the bitmap to the Glyph
Editor clipboard and then delete the selection.
.PP
.TP 8
.I Paste <Ctrl+V>
This will paste the contents of the Glyph Editor clipboard into the current
Glyph Editor with the top-left coordinate of the bitmap on the clipboard
pasted at the location of the mouse.  If the bitmap is too big to fit if it is
pasted at the mouse location, the bitmap will be shifted until it fits
completely in the Glyph Editor.
.PP
.TP 8
.I Select All <Ctrl+A>
This will select the whole glyph bitmap.
.PP
.TP 8
.I Next Glyph <Ctrl+N>
This will move the Glyph Editor to the next glyph position in the Font Grid.
If the current glyph has been modified, a save prompt will appear before
moving to the next glyph.
.PP
.TP 8
.I Previous Glyph <Ctrl+P>
This will move the Glyph Editor to the previous glyph position in the Font
Grid.  If the current glyph has been modified, a save prompt will appear
before moving to the previous glyph.
.PP
The
.I Operation
menu has the following entries:
.PP
.TP 8
.I Draw <Ctrl+D>
Change the Glyph Editor into Draw mode.
.PP
.TP 8
.I Move <Ctrl+M>
Change the Glyph Editor into Move mode.  Move mode allows selecting a portion
of the glyph bitmap and moving it to another location.
.PP
.TP 8
.I Copy <Ctrl+Y>
Change the Glyph Editor into Copy mode.  Copy mode allows copying a portion of
the glyph bitmap and moving it to another location.
.PP
.TP 8
.I Rotate <Ctrl+T>
This will invoke the rotation dialog that allows the degrees of rotation
to be specified.  Rotation can be between 1 and 359 degrees.
.PP
.TP 8
.I Shear <Ctrl+E>
This will invoke the shear dialog that allows the degrees of horizontal
shear to be specified.  Other names for shearing are obliquing or slanting.
Shearing is allowed between 1 and 45 degrees.

.SH Glyph Editor Other Features
When the mouse is used to shift the bitmap by one of the buttons, holding
the mouse down will cause the activity to repeat.

.SH RESOURCES
The program understands all of the core X Toolkit resource names
and classes as well as:
.\".in +1in
.TP 8
.B "noComments (Boolean)"
Specify whether
.I xmbdfed
preserves comments or not (default False).
.TP 8
.B "noUnencodedGlyphs (Boolean)"
Specify whether
.I xmbdfed
preserves unencoded glyphs (character code -1) or not (default False).
.TP 8
.B "noMetricsCorrections (Boolean)"
Specify whether
.I xmbdfed
does metrics corrections or not (default False).
.TP 8
.B "padCharacterCells (Boolean)"
Specify whether character-cell glyphs should be padded to cell geometry
(default False).
.TP 8
.B "skipBlankGlyphPages (Boolean)"
Specify whether
.I xmbdfed
skips blank pages or not (default True).
.TP 8
.B "fontPointSize (Cardinal)"
Sets default point size.
.TP 8
.B "fontHorizontalResolution (Cardinal)"
Sets default horizontal resolution.
.TP 8
.B "fontVerticalResolution (Cardinal)"
Sets default vertical resolution.
.TP 8
.B "fontResolution (Cardinal)"
Sets both default horizontal and vertical resolutions.
.TP 8
.B "fontSpacing (String)"
Sets the default font spacing ("p", "m", or "c")

.SH "SEE ALSO"
xfed(1), bdftopcf(1), bdftosnf(1)
.br
\fIGlyph Bitmap Distribution Format (BDF) Specification\fP, Application
Note 5005, Adobe System Inc, 1993

.SH ACKNOWLEDGMENTS

Ross Patterson for his HBF code.
.br
der Mouse for his "getbdf" code.
.br
K. Carothers and A. Korobka for their "fnt2bdf" code in Wine.
.sp
Mike Stroyan <mike_stroyan@fc.hp.com> for patches.
.br
Primoz Peterlin <primoz.peterlin@biofiz.mf.uni-lj.si> for this manual page.
.br
Danny Backx <u27113@kb.be> for the LessTif Imakefile.
.br
Donald Page <donaldp@sco.com> for patches.
.br
Michal Szymanski <msz@sirius.astrouw.edu.pl> for problem reports.
.br
Werner Lemberg <a7971428@unet.univie.ac.at> for problem reports.
.br
William F. Maton <wmaton@enterprise.ic.gc.ca> for problem reports.
.br
Ivan Nejgebauer <ian@uns.ns.ac.yu> for problem reports.
.br
Solofo <solofo@mpi-sb.mpg.de> for problem reports.
.br
Dave Bodenstab <imdave@mcs.net> for patches.
.br
W. Chao <wchao@HRZ.Uni-Bielefeld.DE> for Makefile changes and problem report.

.SH AUTHOR
Mark Leisher
.br
Computing Research Lab
.br
New Mexico State University
.br
Email: mleisher@crl.nmsu.edu
