/* xkeycaps, Copyright (c) 1994 Jamie Zawinski <jwz@netscape.com>
 *
 * Keymap file of the 102 keys PC-style keyboard, French layout (azerty).
 * Mod2 was used to generate "AltGr" keys, and Mod1 is kept on left Alt.
 * This file was built for a "Keytronic" keyboard which has an extra
 * 'currency' symbol on the dollar/sterling key some others haven't.
 * Generated by Frederic Le Guern <leguern@inf.enst.fr>
 */

static const struct default_keycode_map linux102fr_map [] = {
  {   9, 0,		{ XK_Escape }},
  {  10, 0,		{ XK_ampersand,	XK_1 }},
  {  11, Mod2Mask,	{ XK_eacute,	XK_2,	XK_asciitilde }},
  {  12, Mod2Mask,	{ XK_quotedbl,	XK_3,	XK_numbersign }},
  {  13, Mod2Mask,	{ XK_apostrophe,	XK_4,	XK_braceleft }},
  {  14, Mod2Mask,	{ XK_parenleft,	XK_5,	XK_bracketleft }},
  {  15, Mod2Mask,	{ XK_minus,	XK_6,	XK_bar }},
  {  16, Mod2Mask,	{ XK_egrave,	XK_7,	XK_grave }},
  {  17, Mod2Mask,	{ XK_underscore,	XK_8,	XK_backslash }},
  {  18, Mod2Mask,	{ XK_ccedilla,	XK_9,	XK_asciicircum }},
  {  19, Mod2Mask,	{ XK_agrave,	XK_0,	XK_at }},
  {  20, Mod2Mask,	{ XK_parenright,	XK_degree,	XK_bracketright }},
  {  21, Mod2Mask,	{ XK_equal,	XK_plus,	XK_braceright }},
  {  22, 0,		{ XK_BackSpace }},
  {  23, 0,		{ XK_Tab }},
  {  24, 0,		{ XK_a,	XK_A }},
  {  25, 0,		{ XK_z,	XK_Z }},
  {  26, 0,		{ XK_e,	XK_E }},
  {  27, 0,		{ XK_r,	XK_R }},
  {  28, 0,		{ XK_t,	XK_T }},
  {  29, 0,		{ XK_y,	XK_Y }},
  {  30, 0,		{ XK_u,	XK_U }},
  {  31, 0,		{ XK_i,	XK_I }},
  {  32, 0,		{ XK_o,	XK_O }},
  {  33, 0,		{ XK_p,	XK_P }},
  {  34, 0,		{ XK_asciicircum,	XK_diaeresis }},
  {  35, Mod2Mask,	{ XK_dollar,	XK_sterling,	XK_currency }},
  {  36, 0,		{ XK_Return }},
  {  37, ControlMask,	{ XK_Control_L }},
  {  38, 0,		{ XK_q,	XK_Q }},
  {  39, 0,		{ XK_s,	XK_S }},
  {  40, 0,		{ XK_d,	XK_D }},
  {  41, 0,		{ XK_f,	XK_F }},
  {  42, 0,		{ XK_g,	XK_G }},
  {  43, 0,		{ XK_h,	XK_H }},
  {  44, 0,		{ XK_j,	XK_J }},
  {  45, 0,		{ XK_k,	XK_K }},
  {  46, 0,		{ XK_l,	XK_L }},
  {  47, 0,		{ XK_m,	XK_M }},
  {  48, 0,		{ XK_ugrave,	XK_percent }},
  {  49, 0,		{ XK_twosuperior }},
  {  50, ShiftMask,	{ XK_Shift_L }},
  {  51, 0,		{ XK_asterisk,	XK_mu }},
  {  52, 0,		{ XK_w,	XK_W }},
  {  53, 0,		{ XK_x,	XK_X }},
  {  54, 0,		{ XK_c,	XK_C }},
  {  55, 0,		{ XK_v,	XK_V }},
  {  56, 0,		{ XK_b,	XK_B }},
  {  57, 0,		{ XK_n,	XK_N }},
  {  58, 0,		{ XK_comma,	XK_question }},
  {  59, 0,		{ XK_semicolon,	XK_period }},
  {  60, 0,		{ XK_colon,	XK_slash }},
  {  61, 0,		{ XK_exclam,	XK_section }},
  {  62, ShiftMask,	{ XK_Shift_R }},
  {  63, 0,		{ XK_KP_Multiply }},
  {  64, Mod1Mask,	{ XK_Alt_L,	XK_Meta_L }},
  {  65, 0,		{ XK_space }},
  {  66, LockMask,	{ XK_Caps_Lock }},
  {  67, 0,		{ XK_F1,	XK_F13 }},
  {  68, 0,		{ XK_F2,	XK_F14 }},
  {  69, 0,		{ XK_F3,	XK_F15 }},
  {  70, 0,		{ XK_F4,	XK_F16 }},
  {  71, 0,		{ XK_F5,	XK_F17 }},
  {  72, 0,		{ XK_F6,	XK_F18 }},
  {  73, 0,		{ XK_F7,	XK_F19 }},
  {  74, 0,		{ XK_F8,	XK_F20 }},
  {  75, 0,		{ XK_F9,	XK_F21 }},
  {  76, 0,		{ XK_F10,	XK_F22 }},
  {  77, 0,		{ XK_Num_Lock }},
  {  78, 0,		{ XK_Scroll_Lock }},
  {  79, 0,		{ XK_Home,	XK_KP_7 }},
  {  80, 0,		{ XK_Up,	XK_KP_8 }},
  {  81, 0,		{ XK_Prior,	XK_KP_9 }},
  {  82, 0,		{ XK_KP_Subtract }},
  {  83, 0,		{ XK_Left,	XK_KP_4 }},
  {  84, 0,		{ XK_VoidSymbol,	XK_KP_5 }},
  {  85, 0,		{ XK_Right,	XK_KP_6 }},
  {  86, 0,		{ XK_KP_Add }},
  {  87, 0,		{ XK_End,	XK_KP_1 }},
  {  88, 0,		{ XK_Down,	XK_KP_2 }},
  {  89, 0,		{ XK_Next,	XK_KP_3 }},
  {  90, 0,		{ XK_Insert,	XK_KP_0 }},
  {  91, 0,		{ XK_Delete,	XK_KP_Decimal }},
  {  94, 0,		{ XK_less,	XK_greater }},
  {  95, 0,		{ XK_F11,	XK_F23 }},
  {  96, 0,		{ XK_F12,	XK_F24 }},
  {  97, 0,		{ XK_Home }},
  {  98, 0,		{ XK_Up }},
  {  99, 0,		{ XK_Prior }},
  { 100, 0,		{ XK_Left }},
  { 102, 0,		{ XK_Right }},
  { 103, 0,		{ XK_End }},
  { 104, 0,		{ XK_Down }},
  { 105, 0,		{ XK_Next }},
  { 106, 0,		{ XK_Insert }},
  { 107, 0,		{ XK_Delete }},
  { 108, 0,		{ XK_KP_Enter }},
  { 109, ControlMask,	{ XK_Control_R }},
  { 110, 0,		{ XK_Break,	XK_Pause }},
  { 111, 0,		{ XK_Execute,	XK_Print }},
  { 112, 0,		{ XK_KP_Divide }},
  { 113, Mod2Mask,	{ XK_Alt_R,	XK_Mode_switch }},
};
