#include <stdio.h>
#include <X11/Xlib.h>
#include <string.h>
#include <wraster.h>

#define WTP_TILE  1
#define WTP_SCALE 2


char *ProgName;


void
print_help()
{
    printf("usage: %s [-options] image\n", ProgName);
    puts("options:");
    puts(" -t 		tile  image");
    puts(" -s		scale image (default)");
}


int
main(int argc, char **argv)
{
    Display *dpy;
    Window root_win;
    RContextAttributes rattr;
    int screen_number, i, style = WTP_SCALE;
    int scr_width, scr_height;
    RContext *rcontext;
    RImage *image, *tmp;
    Pixmap pixmap;
    char *image_name = NULL;


    ProgName = strrchr(argv[0],'/');
    if (!ProgName)
      ProgName = argv[0];
    else
      ProgName++;

    if (argc>1) {
	for (i=1; i<argc; i++) {
            if (strcmp(argv[i], "-s")==0) {
                style = WTP_SCALE;
            } else if (strcmp(argv[i], "-t")==0) {
                style = WTP_TILE;
            } else if (argv[i][0] != '-' && !image_name) {
                image_name = argv[i];
            } else {
                print_help();
                exit(1);
            }
	}
    }

    if (image_name == NULL) {
        print_help();
        exit(1);
    }
    dpy = XOpenDisplay("");
    if (!dpy) {
	puts("Could not open display!");
	exit(1);
    }

    screen_number = DefaultScreen(dpy);
    root_win = RootWindow(dpy, screen_number);
    scr_width = WidthOfScreen(ScreenOfDisplay(dpy, screen_number));
    scr_height = HeightOfScreen(ScreenOfDisplay(dpy, screen_number));

    /* screen descriptor for raster graphic library */
    rattr.flags = RC_RenderMode | RC_ColorsPerChannel;
    rattr.render_mode = 1?RM_MATCH:RM_DITHER;
    rattr.colors_per_channel = 4;
    if (rattr.colors_per_channel<2)
	rattr.colors_per_channel = 2;

    rcontext = RCreateContext(dpy, screen_number, &rattr);
    if (!rcontext) {
	printf("could not initialize graphics library context: %s\n",
               RErrorString);
	exit(1);
    }

    image = RLoadImage(rcontext, image_name, 0);
    if (!image) {
        printf("could not load image: %s\n", image_name);
        exit(1);
    }
    if (style == WTP_SCALE)
        tmp = RScaleImage(image, scr_width, scr_height);
    else
        tmp = RCloneImage(image);

    if (!tmp) {
        printf("could not scale/tile image: %s", image_name);
        exit(1);
    }

    RConvertImage(rcontext, tmp, &pixmap);
    RDestroyImage(image);
    RDestroyImage(tmp);
    XSetWindowBackgroundPixmap(dpy, root_win, pixmap);
    XClearWindow(dpy, root_win);
    XFlush(dpy);
    XCloseDisplay(dpy);
    exit(0);
}

