/* 
 * savews - saves workspace state
 */
/* 
 
Copyright (c) 1997 Alfredo K. Kojima

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>

Display *dpy;
char *host, *host_node;

extern Window XmuClientWindow();

void put_command(Window fwin)
{
    int x, y;
    unsigned int w, h, b;
    XTextProperty tp;
    int i, done;
    static int first = 1;
    XSizeHints hints;
    long rets;
    Window win, r;
    char **argv;
    int argc;

    
    win = XmuClientWindow(dpy, fwin);
    if (win==None) return;


    if (!XGetGeometry(dpy, win, &r, &x, &y, &w, &h, &b, &b)) 
      return;
    if (!XGetGeometry(dpy, fwin, &r, &x, &y, &b, &b, &b, &b)) 
      return;
    XGetWMClientMachine(dpy, win, &tp);
    if (tp.value==NULL || tp.encoding!=XA_STRING || tp.format !=8)
      return;
    
    if (host_node) {
	if (strcmp((char*)tp.value, host)!=0
	    && strcmp((char*)tp.value, host_node)!=0)
	    return;
    } else {
	if (strcmp((char*)tp.value, host)!=0)
	    return;
    }
    if (!XGetCommand(dpy, win, &argv, &argc))
      return;    
    XGetWMNormalHints(dpy, win, &hints, &rets);
    if (rets & PResizeInc) {
	if (rets & PBaseSize) {
	    w -= hints.base_width;
	    h -= hints.base_height;
	}
	if (hints.width_inc<=0)
	  hints.width_inc=1;
	if (hints.height_inc<=0)
	  hints.height_inc=1;
	w = w / hints.width_inc;
	h = h / hints.height_inc;
    }
    if (!first) {
	puts("&");
    }
    first = 0;
    done = 0;
    for (i=0; i<argc; i++) {
	if (strcmp(argv[i], "-geometry")==0) {
	    if (i<=argc-1) {
		done = 1;
		break;
	    }
	}
    }
    if (!done)
      printf("%s -geometry %dx%d+%d+%d ", argv[0], w, h, x, y);

    for (i=(done ? 0 : 1); i<argc; i++) {
	printf("%s ", argv[i]);
    }
    XFreeStringList(argv);
}

int main(int argc, char **argv)
{
    Window *wins;
    int i;
    unsigned int nwins;
    Window foo;
    char *dot;

    host = getenv("HOSTNAME");
    if (!host)
	host = getenv("HOST");
    if (!host) {
	printf("%s: could not get HOSTNAME environment variable",
	       argv[0]);
	exit(1);
    }
    dot = strchr(host, '.');
    if (!dot)
	host_node = NULL;
    else {
	host_node = malloc(strlen(host)+1);
	*dot = 0;
	strcpy(host_node, host);
	*dot = '.';
    }
    
    
    dpy = XOpenDisplay("");
    if (!dpy) {
	printf("%s: could not open display\n", argv[0]);
	exit(1);
    }
    if (!XQueryTree(dpy, DefaultRootWindow(dpy), &foo, &foo, &wins, &nwins)) {
	printf("%s: XQueryTree() failed\n", argv[0]);
	exit(1);
    }
    puts("#!/bin/sh");
    for (i=0; i<nwins; i++) {
	put_command(wins[i]);
    }
    puts("");
    exit(0);
}
