//
// Dfinition du menu Applications pour WindowMaker
//
// La syntaxe est la suivante :
//
// <Titre> <Commande> <Paramtres>
//
// <Titre> est une chaine de caractres quelconque qui sera utilise comme 
// 	titre. Elle doit etre entre "
//      si elle contient des espaces
//
// <Commande> une des commandes valides suivantes :
//      MENU - dbute la dfinition d'un (sous-)menu
//      END  - termine la dfinition d'un (sous-)menu
//      EXEC <programme> - excute un programme externe
//      EXIT - sortie du gestionnaire de fenetres
//      RESTART [<window manager>] - relance WindowMaker ou lance un
// 	autre gestionnaire de fenetres
//      REFRESH - rafraichit les informations  l'cran
//      ARRANGE_ICONS - rarrange les icones  l'cran
//      SHUTDOWN - tue tous les clients (et ferme la session X window)
//      WORKSPACE_MENU - ajoute un sous-menu pour les oprations concernant
//                                 l'espace de travail (workspace)
//      SHOW_ALL - affiche toutes les fenetres sur le workspace
//      HIDE_OTHERS - cache toutes les fenetres du workspace, sauf celle
//	qui est active (ou la dernire ayant t active)
//
// <Paramtres> dsigne le programme  executer.
//
// ** Options pour la ligne de commandes avec EXEC:
// %s - substitue avec la slection courante. Si aucune slection n'est
//	disponible, la commande est annule
// %w - substitue avec l'identifiant (ID) de la fenetre courante. Si
//	aucune fenetre n'est selectionne
//      empty est retourn
// 
// Vous pouvez protger les caractres spciaux (comme % et ") grace au
// caractre \ :
// ex: xterm -T "\"Hello World\""
//
// A chaque commande MENU doit correspondre un END.
// Exemple :


#include <wmmacros>

"Applications" MENU
        "Info" MENU
                "Copyright..." EXEC xmessage -center -font variable -title \
    'WindowMaker 'WM_VERSION -file $HOME/GNUstep/Library/WindowMaker/Copyright
                "Charge systme" EXEC xosview || xload
                "Processus" EXEC xterm -e top
                "Manuel en ligne" EXEC xman
        "Info" END
        "XTerm" EXEC nxterm -sb || color-xterm -sb || xterm -sb
        "XJed"  EXEC xjed 
        "Workspaces" WORKSPACE_MENU
        "Applications" MENU
                "Graphiques" MENU
                        "Gimp" EXEC gimp
                        "XV" EXEC xv
                        "XPaint" EXEC xpaint
                        "XFig" EXEC xfig
                "Graphiques" END
                "X File Manager" EXEC xfm
                "OffiX Files" EXEC files
                "LyX" EXEC lyx
                "Netscape" EXEC netscape 
                "Ghostview" EXEC ghostview %a(Ghostview)
                "XDvi" EXEC xdvi %a(XDvi)
                "Acrobat" EXEC /usr/local/Acrobat3/bin/acroread %a(Acrobat)
                "TkDesk" EXEC tkdesk
        "Applications" END
        "Editeurs" MENU
                "XEmacs" EXEC xemacs || emacs
                "XJed" EXEC xjed
                "NEdit" EXEC nedit
                "Xedit" EXEC xedit
                "VI" EXEC xterm -e vi
        "Editeurs" END
        "Divers" MENU
                "Xmcd" EXEC xmcd 2> /dev/null
                "Xplaycd" EXEC xplaycd
                "Xmixer" EXEC xmixer
        "Divers" END
        "Utilitaires" MENU
                "Calculatrice" EXEC xcalc
                "Choix des fontes" EXEC xfontsel
                "Loupe" EXEC xmag
                "Colormap" EXEC xcmap
                "XKill" EXEC xkill
                "ASClock" EXEC asclock -shape
                "Clipboard" EXEC xclipboard
        "Utilitaires" END

        "Slection" MENU
                "Envoyer mail a" EXEC xterm -name mail -T "Pine" -e pine %s
                "Naviguer" EXEC netscape -noraise -remote \
                        'openURL(%s,new-window)' || netscape %s
                "Recherche dans le Manuel" EXEC MANUAL_SEARCH(%s)
        "Slection" END

        "Workspace" MENU
                "Cache les autres" HIDE_OTHERS
                "Montre tout" SHOW_ALL
                "Arrange les icones" ARRANGE_ICONS
                "Rafraichissement" REFRESH
                "Lock" EXEC xlock -allowroot -usefirst
                "Fonds" MENU
                        "Aucun" EXEC CLEARROOT
                        "Black" WS_BACK '(solid, black)'
                        "Blue" WS_BACK '(solid, "#505075")'
                        "Purple" WS_BACK '(solid, "#554466")'
                        "Wheat" WS_BACK '(solid, wheat4)'
                        "Dark Gray"  WS_BACK '(solid, "#333340")'
                        "Wine"  WS_BACK '(solid, "#400020")'
                "Fonds" END
#if (DEPTH>8)
// Exemples de gradients pour les nouveaux venus ainsi que pour les fainants.
// Vous devez absolument relancer WindowMaker aprs la slection d'un gradient.
#include <gradients.menu>
#endif
                "Sauvegarde Workspace" EXEC SAVE_WORKSPACE
        "Workspace" END

#if (UID==0)    // Menu affich seulement pour l'utilisateur root
        "Systme" MENU
                // Panneau de controle RedHat
                "RH ControlPanel" EXEC control-panel
        "Systme" END
#endif
        "Sortie" MENU
                 "Relancer" RESTART
                 "Lancer AfterStep" RESTART afterstep
                 "Sortie..."  EXIT
                 "Fin de session..." SHUTDOWN
        "Sortie"  END
"Applications" END
