/*
 * IceWM
 *
 * Copyright (C) 1997 Marko Macek
 */

#include "icewm.h"

void YFrameTitleBar::handleButton(const XButtonEvent &button) {
    if (button.type == ButtonPress) {
        if (!(button.state & ControlMask)) {
            if (//button.button != 2 &&
                (button.button != 1 || (button.state & Mod1Mask) == 0))
            {
                frame()->activate();
                if (raiseOnClickTitleBar)
                    frame()->wmRaise();
            }
        }
    }
    YWindow::handleButton(button);
}

void YFrameTitleBar::handleMotion(const XMotionEvent &motion) {
    YWindow::handleMotion(motion);
}

void YFrameTitleBar::handleClick(const XButtonEvent &down, const XButtonEvent &up, int count) {
    if (count == 2) {
        if (down.button == 1 &&
            ISMASK(BUTTON_MODMASK(down.state), 0, ControlMask))
            frame()->wmMaximize();
        else if (down.button == 1 &&
            ISMASK(BUTTON_MODMASK(down.state), ShiftMask, ControlMask))
            frame()->wmMaximizeVert();
        else if (down.button == 2 &&
                 ISMASK(BUTTON_MODMASK(down.state), 0, ControlMask))
            frame()->wmRollup();
        else if (down.button == 2 &&
                 ISMASK(BUTTON_MODMASK(down.state), ShiftMask, ControlMask))
            frame()->wmMaximizeHorz();
    } else if (count == 1) {
        if (down.button == 3 && (KEY_MODMASK(down.state) & (ShiftMask | Mod1Mask)) == 0) {
            frame()->updateMenu();
            frame()->windowMenu()->popup(0, frame(),
                                         up.x_root, up.y_root, -1, -1,
                                         YPopupWindow::pfCanFlipVertical |
                                         YPopupWindow::pfCanFlipHorizontal);
        } else if (down.button == 1 && KEY_MODMASK(down.state) == Mod1Mask) {
            frame()->wmLower();
        }
    }
}

void YFrameTitleBar::handleBeginDrag(const XButtonEvent &down, const XMotionEvent &/*motion*/) {
    if (frame()->canMove()) {
        frame()->startMoveSize(1, 1,
                               0, 0,
                               down.x + x(), down.y + y());
    }
    //handleDrag(down, motion);
}

void YFrameTitleBar::handleDrag(const XButtonEvent &/*down*/, const XMotionEvent &/*motion*/) {
}

void YFrameTitleBar::handleEndDrag(const XButtonEvent &/*down*/, const XButtonEvent &/*motion*/) {
}

void YFrameTitleBar::activate() {
    if (!isActive) {
        isActive = 1;
        repaint();
#ifdef CONFIG_LOOK_WIN95
        if (wmLook == lookWin95)
            frame()->menuButton()->repaint();
#endif
#ifdef CONFIG_LOOK_PIXMAP
        if (wmLook == lookPixmap) {
            frame()->menuButton()->repaint();
            frame()->closeButton()->repaint();
            frame()->maximizeButton()->repaint();
            frame()->minimizeButton()->repaint();
        }
#endif
    }
}

void YFrameTitleBar::deactivate() {
    if (isActive) {
        isActive = 0;
        repaint();
#ifdef CONFIG_LOOK_WIN95
        if (wmLook == lookWin95)
            frame()->menuButton()->repaint();
#endif
#ifdef CONFIG_LOOK_PIXMAP
        if (wmLook == lookPixmap) {
            frame()->menuButton()->repaint();
            frame()->closeButton()->repaint();
            frame()->maximizeButton()->repaint();
            frame()->minimizeButton()->repaint();
        }
#endif
    }
}

void YFrameTitleBar::paint(Graphics &g, int , int , unsigned int , unsigned int ) {
    YColor *bg = isActive ? activeTitleBarBg : inactiveTitleBarBg;
    YColor *fg = isActive ? activeTitleBarFg : inactiveTitleBarFg;
    int ol = 0;
    int or = 0;

    if (!frame()->client())
        return ;
    
    if (frame()->menuButton()->visible())
        ol += frame()->menuButton()->width();
    if (frame()->closeButton()->visible())
        or += frame()->closeButton()->width();
    if (frame()->minimizeButton()->visible())
        or += frame()->minimizeButton()->width();
    if (frame()->maximizeButton()->visible())
        or += frame()->maximizeButton()->width();

    g.setFont(titleFont);
    int stringOffset = ol + 3;

#ifdef CONFIG_LOOK_MOTIF
    if (wmLook == lookMotif)
        stringOffset++;
#endif
#ifdef CONFIG_LOOK_WARP4
    if (wmLook == lookWarp4)
        stringOffset++;
#endif

    char *title = (char *)frame()->client()->windowTitle();
    int yPos =
        (height() - titleFont->height()) / 2
        + titleFont->ascent();
    int tlen = title ? XTextWidth(titleFont->getFontStruct(), title, strlen(title)) : 0;

    g.setColor(bg);
    switch (wmLook) {
#ifdef CONFIG_LOOK_WIN95
    case lookWin95:
#endif
#ifdef CONFIG_LOOK_NICE
    case lookNice:
#endif
        g.fillRect(0, 0, width(), height());
        break;
#ifdef CONFIG_LOOK_WARP3
    case lookWarp3:
        {
#ifdef TITLEBAR_BOTTOM
            int y = 1;
            int y2 = 0;
#else
            int y = 0;
            int y2 = height() - 1;
#endif
            
            g.fillRect(0, y, width(), height() - 1);
            g.setColor(isActive ? fg->darker() : bg->darker());
            g.drawLine(0, y2, width(), y2);
        }
        break;
#endif
#ifdef CONFIG_LOOK_WARP4
    case lookWarp4:
        if (isActive) {
            g.fillRect(1, 1, width() - 2, height() - 2);
            g.setColor(inactiveTitleBarBg);
            g.draw3DRect(ol, 0, width() - or - 1, height() - 1, false);
        } else {
            g.fillRect(0, 0, width(), height());
        }
        break;
#endif
#ifdef CONFIG_LOOK_MOTIF
    case lookMotif:
        g.fillRect(1, 1, width() - 2, height() - 2);
        g.draw3DRect(ol, 0, width() - or - 1 - ol, height() - 1, true);
        break;
#endif
#ifdef CONFIG_LOOK_PIXMAP
    case lookPixmap:
        {
            int xx = ol;
            int n = isActive ? 1 : 0;

            g.drawPixmap(titleL[n], xx, 0); xx += titleL[n]->width();
            g.repHorz(titleT[n], xx, 0, tlen); xx += tlen;
            stringOffset = ol + titleL[n]->width();
            g.drawPixmap(titleM[n], xx, 0); xx += titleM[n]->width();
            g.repHorz(titleB[n], xx, 0, width() - or - xx);
            xx = width() - or - titleR[n]->width();
            g.drawPixmap(titleR[n], xx, 0);
        }
        break;
#endif
    default:
        break;
    }
    g.setColor(fg);
    if (title)
        g.drawChars((char *)title, 0, strlen((char *)title),
                    stringOffset, yPos);
}
