/*
 * IceWM
 *
 * Copyright (C) 1997 Marko Macek
 *
 * Windows/OS2 like Alt{+Shift}+Tab window switching
 */

#include "icewm.h"

SwitchWindow::SwitchWindow(YWindow *parent): YPopupWindow(parent) {
    fActiveWindow = 0;

    int sW = 4 + app->root()->width() / 5 * 3;
    int sH = 4 + 32;
        //statusFont->max_bounds.ascent +
        //statusFont->max_bounds.descent;

    setGeometry(app->root()->width() / 2 - sW / 2,
                app->root()->height() / 2 - sH / 2,
                sW, sH);

    setStyle(wsOverrideRedirect);
}

SwitchWindow::~SwitchWindow() {
}

void SwitchWindow::paint(Graphics &g, int /*x*/, int /*y*/, unsigned int /*width*/, unsigned int /*height*/) {
    g.setColor(switchBg);
    g.drawBorderW(0, 0, width() - 1, height() - 1, true);
    g.fillRect(1, 1, width() - 3, height() - 3);

    if (fActiveWindow) {
        if (fActiveWindow->clientIcon() && fActiveWindow->clientIcon()->large())
            g.drawMaskPixmap(fActiveWindow->clientIcon()->large(), 2, 2);
        g.setColor(switchFg);
        g.setFont(switchFont);
        char *str = (char *)fActiveWindow->client()->windowTitle();
        if (str != 0)
            g.drawChars((char *)str, 0, strlen(str),
                        width() / 2 - XTextWidth(switchFont->getFontStruct(),
                                                 str, strlen(str)) / 2,
                        height() / 2 + (switchFont->height()) / 2
                        - switchFont->descent());
    }
}

void SwitchWindow::begin(int next) {
    fActiveWindow = app->top(0);
    if (fActiveWindow) {
        fActiveWindow =
            fActiveWindow->findWindow(YFrameWindow::fwfNext |
                                      YFrameWindow::fwfCycle |
                                      YFrameWindow::fwfFocusable |
                                      YFrameWindow::fwfWorkspace |
                                      YFrameWindow::fwfVisible |
                                      YFrameWindow::fwfSame |
                                      (next ? 0 : YFrameWindow::fwfBackward));
    }
    popup(0, 0, YPopupWindow::pfNoPointerChange);
}

void SwitchWindow::activatePopup() {
}

void SwitchWindow::deactivatePopup() {
}

void SwitchWindow::destroyedFrame(YFrameWindow *frame) {
    if (frame == fActiveWindow) {
        fActiveWindow = app->top(0);
        if (fActiveWindow)
            fActiveWindow = fActiveWindow->findWindow(YFrameWindow::fwfNext |
                                                      YFrameWindow::fwfCycle |
                                                      YFrameWindow::fwfVisible |
                                                      YFrameWindow::fwfFocusable |
                                                      YFrameWindow::fwfWorkspace);
        repaint();
    }
}

bool SwitchWindow::handleKey(const XKeyEvent &key) {
    int k = XKeycodeToKeysym(app->display(), key.keycode, 0);
    int m = KEY_MODMASK(key.state);
    
    if (key.type == KeyPress) {
        if (k == XK_Tab && m == Mod1Mask) {
            if (fActiveWindow)
                fActiveWindow = fActiveWindow->findWindow(YFrameWindow::fwfNext |
                                                          YFrameWindow::fwfCycle |
                                                          YFrameWindow::fwfFocusable |
                                                          YFrameWindow::fwfVisible |
                                                          YFrameWindow::fwfSame |
                                                          YFrameWindow::fwfWorkspace);
            else
                fActiveWindow = app->top(0);
            repaint();
        } else if ((/*k == XK_BackTab ||*/ k == XK_Tab) && (m == Mod1Mask + ShiftMask)) {
            if (fActiveWindow)
                fActiveWindow = fActiveWindow->findWindow(YFrameWindow::fwfNext |
                                                          YFrameWindow::fwfBackward |
                                                          YFrameWindow::fwfCycle |
                                                          YFrameWindow::fwfFocusable |
                                                          YFrameWindow::fwfVisible |
                                                          YFrameWindow::fwfSame |
                                                          YFrameWindow::fwfWorkspace);
            else
                fActiveWindow = app->bottom(0);
            repaint();
        } else if (k == XK_Escape && m == Mod1Mask) {
            cancelPopup();
        }
    } else if (key.type == KeyRelease) {
        if (fActiveWindow &&
            (k == XK_Alt_L || k == XK_Alt_R ||
             k == XK_Meta_L || k == XK_Meta_R))
        {
            fActiveWindow->wmRaise();
            app->activate(fActiveWindow);
            cancelPopup();
        }
    }
    return YPopupWindow::handleKey(key);
}

void SwitchWindow::handleButton(const XButtonEvent &button) {
    YPopupWindow::handleButton(button);
}
