/*
 * IceWM
 *
 * Copyright (C) 1997 Marko Macek
 */

#include "icewm.h"

YRootWindow::YRootWindow(YWindow *parent, Window win): YWindow(parent, win) {
    setPointer(leftPointer);
    grabKey(XK_Escape, ControlMask | Mod1Mask | ShiftMask);
    grabKey(XK_Escape, Mod1Mask);
    grabKey(XK_Escape, Mod1Mask | ShiftMask);
    grabKey(XK_Escape, ControlMask);
    grabKey(XK_Escape, ControlMask | ShiftMask);
    grabKey(XK_Escape, ShiftMask);
    grabKey(XK_Delete, ControlMask | Mod1Mask);
    grabKey(XK_Delete, ControlMask | Mod1Mask | ShiftMask); // if c-a-d broken

    // ???
    grabKey(XK_Left, Mod1Mask | ControlMask);
    grabKey(XK_Right, Mod1Mask | ControlMask);
    grabKey(XK_Left, Mod1Mask | ControlMask | ShiftMask);
    grabKey(XK_Right, Mod1Mask | ControlMask | ShiftMask);

#ifdef SUPPORT_WIN95KBD
    if (win95keys) {
        grabKey(XK_Menu, Mod1Mask);
        grabKey(XK_Meta_L, 0);
        grabKey(XK_Meta_R, 0);
    }
#endif
    setFocus();
}

YRootWindow::~YRootWindow() {
}

bool YRootWindow::handleKey(const XKeyEvent &key) {
    if (key.type == KeyPress) {
        int k = XKeycodeToKeysym(app->display(), key.keycode, 0);
        int m = KEY_MODMASK(key.state);

        MSG(("key: %d, mod: %d", k, m));

        if (k == XK_Left && m == (Mod1Mask | ControlMask)) {
            app->activateWorkspace((app->activeWorkspace() + app->workspaceCount() - 1) % app->workspaceCount());
        } else if (k == XK_Right && m == (Mod1Mask | ControlMask)) {
            app->activateWorkspace((app->activeWorkspace() + 1) % app->workspaceCount());
        } else if (k == XK_Escape && m == (Mod1Mask | ControlMask | ShiftMask))
            app->exit(0);
        else if (k == XK_Delete && m == (Mod1Mask | ControlMask)) {
            ctrlAltDelete->activate();
        } else if (k == XK_Delete && m == (Mod1Mask | ControlMask | ShiftMask))
            app->exit(0);
        else if (k == XK_Escape && m == ControlMask) {
            if (taskBar->visible())
                taskBar->raise();
            //app->popupWindowListMenu(key.x_root, key.y_root);
            app->popupStartMenu();
        } else if (k == XK_Escape && m == ControlMask + ShiftMask) {
            if (windowList)
                windowList->showFocused();
        }
            //popupWindowListMenu();
#ifdef SUPPORT_WIN95KBD
        else if (win95keys && k == XK_Menu && m == Mod1Mask)
            app->popupWindowListMenu();
        else if (win95keys && (k == XK_Meta_L) && m == 0)
            app->popupStartMenu();
        else if (win95keys && (k == XK_Meta_R) && m == 0) {
            if (windowList)
                windowList->showFocused();
        }
#endif
        else if (app->focus()) {
            if (k == XK_Escape && m == (Mod1Mask | ShiftMask))
                app->focus()->wmPrevWindow();
            else if (k == XK_Escape && m == ShiftMask)
                app->focus()->popupSystemMenu();
            else if (k == XK_Left && m == (Mod1Mask | ControlMask | ShiftMask)) {
                int nw = (app->activeWorkspace() +
                          app->workspaceCount() - 1) % app->workspaceCount();

                app->focus()->wmOccupyWorkspace(nw);
                app->activateWorkspace(nw);
                app->focus()->wmOccupyOnlyWorkspace(nw);
            } else if (k == XK_Right && m == (Mod1Mask | ControlMask | ShiftMask)) {
                int nw = (app->activeWorkspace() + 1) % app->workspaceCount();

                app->focus()->wmOccupyWorkspace(nw);
                app->activateWorkspace(nw);
                app->focus()->wmOccupyOnlyWorkspace(nw);
            } else if (m == Mod1Mask) {
                if (k == XK_Escape)
                    app->focus()->wmNextWindow();
            }
        } else {
        }
    }
    return true;
}

void YRootWindow::handleButton(const XButtonEvent &button) {
    if ((button.type == ButtonRelease) &&
        (button.button == 1 || button.button == 3) &&
        (button.state == Button1Mask + Button3Mask))
    {
        if (windowList)
            windowList->showFocused();
    } else
        YWindow::handleButton(button);
}

void YRootWindow::handleClick(const XButtonEvent &down, const XButtonEvent &up, int /*count*/) {
    if (up.button == 1 && BUTTON_MODMASK(down.state) == 0)
        app->popupWindowListMenu(up.x, up.y);
    else if (up.button == 3 && BUTTON_MODMASK(down.state) == 0)
        rootMenu->popup(0, 0, up.x, up.y, -1, -1,
                        YPopupWindow::pfCanFlipVertical |
                        YPopupWindow::pfCanFlipHorizontal |
                        YPopupWindow::pfPopupMenu);

}

void YRootWindow::handleConfigureRequest(const XConfigureRequestEvent &configureRequest) {
    YFrameWindow *frame;

    MSG(("root configure request"));
    
    frame = app->getFrame(configureRequest.window);
    if (frame == 0) {
        YFrameClient *client = app->manageWindow(configureRequest.window);
        if (client != 0)
            client->configureClient(configureRequest);
    } else
        frame->configureClient(configureRequest);
}

void YRootWindow::handleMapRequest(const XMapRequestEvent &mapRequest) {
    app->mapWindow(mapRequest.window);
}

void YRootWindow::handleMap(const XMapEvent &map) {
    if (windowList && map.window == windowList->handle())
        app->mapWindow(map.window);
}

void YRootWindow::handleUnmap(const XUnmapEvent &unmap) {
    if (unmap.send_event)
        app->unmapWindow(unmap.window);
}

void YRootWindow::handleDestroyWindow(const XDestroyWindowEvent &destroyWindow) {
//#ifdef DEBUG
//    if (debug) msg("DESTROY: %lX", destroyWindow.window);
//#endif
    if (destroyWindow.window == handle())
        YWindow::handleDestroyWindow(destroyWindow);
    //else {
    //    app->destroyedWindow(destroyWindow.window);
    //}
}

void YRootWindow::handleClientMessage(const XClientMessageEvent &message) {
    if (message.message_type == _XA_WM_CHANGE_STATE &&
        message.data.l[0] == IconicState)
    {
        YFrameWindow *frame = app->getFrame(message.window);

        if (frame && !(frame->minimized() || frame->rolledup()))
            frame->wmMinimize();
    }
}
