//<copyright>
//
// Copyright (c) 1993,94
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
// This file is part of VRweb.
//
// VRweb is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// VRweb is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with VRweb; see the file LICENCE. If not, write to the
// Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// Note that the GNU General Public License does not permit incorporating
// the Software into proprietary or commercial programs. Such usage
// requires a separate license from IICM.
//
//</copyright>

//<file>
//
// Name:        light.C
//
// Purpose:     implementation of class Light
//
// Created:     18 Mar 92   Michael Hofer and Michael Pichler
//
// Changed:     17 Mar 94   Michael Pichler
//
// $Id: light.C,v 1.3 1997/02/25 17:03:58 mpichler Exp $
//
//</file>



#include "light.h"
#include "vecutil.h"

#include <ge3d/ge3d.h>


#include <iostream.h>
#include <stdio.h>
#include <ctype.h>





Light::Light (int obj_n, int par, const char* name)
: Object3D (obj_n, par, name)
{
  initRGB (intensity_, 0.7, 0.7, 0.7);  // default intensity
  // default: positional light source
  positional_ = 1.0;
  camlgt_ = 0;
}



// implementation of Light::readlgtfile see readscene.C



void Light::print ()
{
  cout << "Light. ";

  printobj ();

  cout << "  Intensity (rgb): " 
    << intensity_.R << ", "
    << intensity_.G << ", "
    << intensity_.B << endl;

  cout << "  " << (positional_ ? "positional" : "directional (inifite)") << " light source";
  if (camlgt_)
    cout << ", bound to active camera";
  cout << '.' << endl;

  cout << endl;
}



void Light::setlight (int index)
{ 
  // note: position cannot be stored, as GL's viewing transformation is stored
  // in the model matrix and not in the projection matrix
  // otherwise lighting calculations are incorrect

//cerr << "setting a light source. positional: " << positional_ << ", camera light: " << camlgt_ << endl;

  ge3dLightSource (index, &intensity_, trfmat_, positional_, camlgt_);
}
