/*
**	SWISH++
**	file_index.c
**
**	Copyright (C) 1998  Paul J. Lucas
**
**	This program is free software; you can redistribute it and/or modify
**	it under the terms of the GNU General Public License as published by
**	the Free Software Foundation; either version 2 of the License, or
**	(at your option) any later version.
** 
**	This program is distributed in the hope that it will be useful,
**	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
** 
**	You should have received a copy of the GNU General Public License
**	along with this program; if not, write to the Free Software
**	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

// local
#include "fake_ansi.h"
#include "file_index.h"

//*****************************************************************************
//
// SYNOPSIS
//
	void file_index::set_index_file( file_vector<char> const &file )
//
// DESCRIPTION
//
//	Set the index file to use by setting data members to the proper
//	positions withing the index file.
//
// CAVEAT
//
//	Ideally, this function would be part of the constructor, but the name
//	of the index file can be passed in via the command line and that isn't
//	parsed until after the instance is constructed.
//
// SEE ALSO
//
//	index.c		write_full_index() -- format of index file
//
//*****************************************************************************
{
	begin_ = file.begin();
	long const *const p = REINTERPRET_CAST( long const* )( begin_ );
	long const num_words = p[ 0 ];

	long const *const q = REINTERPRET_CAST( long const* )(
		REINTERPRET_CAST( char const* )( begin_ )
		+ sizeof( num_words ) + num_words * sizeof( off_t )
	);

	num_files_ = q[ 0 ];
	offset_ = STATIC_CAST( off_t const* )( &q[ 1 ] );
}
