#ifndef ___ARENA_X11_H___
#  define ___ARENA_X11_H___


#include "defs.h"

#include <X11/Xlib.h>


#ifndef XK_DeleteChar
#  define XK_DeleteChar XK_Delete
#endif


extern float dpi(void);

extern Bool Busy(void);
extern void ShowBusy(void);
extern void HideBusy(void);
extern void Beep(void);

Bool ParseColour(const char *s, long *value_p);

Window CreateSubWindow(Display* display, Window parent_window,
		       int x, int y, unsigned int width, unsigned int height,
		       long maskXevents_not_to_propagate,
		       long background_colour);

int GetFont(char *family_l, long px_size, long weight, long style,
	    Bool small_caps);

Bool FrameVisibleSubArea(XRectangle  Area,
			 XRectangle  frameArea,
			 XRectangle* frameVisibleSubArea);

void DrawOutSet(Window win, GC gc,
		int x, int y, unsigned int w, unsigned int h);
void DrawInSet(Window win, GC gc,
	       int x, int y, unsigned int w, unsigned int h);

void DrawOutSetCircle(Window win, GC gc,
		      int x, int y, unsigned int w, unsigned int h);
void DrawInSetCircle(Window win, GC gc,
		     int x, int y, unsigned int w, unsigned int h);

/*
 * The function draws the transparent image to the Drawable.
 */
Status Arena_PutTransparentImage(Display* display, GC GraphicContext,
				 Pixmap image, Pixmap mask,
				 Drawable destination,
				 int x, int y,
				 unsigned int width, unsigned int height);


#endif	/* ifndef ___ARENA_X11_H___ */
