/* parsecommand.c
 * Routines used to parse and execute commands received via
 * the PropertyNotify Event caught by GuiEvents().  Somewhere along the
 * Arena development cycle this was created (it looks like Colas Nahaboo) and
 * has been "broken" by other work along the way.
 *
 * I got "into" it when trying to remove the call to system() and trying
 * to check the URL for "security" concerns.  I really added all these comments
 * so "I" could try to understand what was going on...
 *
 * The command structure I decided was being attempted is VERY basic!
 *    GOTO URL=/url/spec            Yes, it just opens that url!
 * or GOTO NEW URL=/url/spec        Run another copy of arena with url spec
 *
 * As of 0.3.46, I don't think this stuff was used at all!
 * But, it works now glk.18.10.97.  I used the new routine
 * ArenaSendXPropertyCommand(char *cmd) to "try" things out...
 * BUT using this to Spawn a new copy of Arena can be very dangerous!
 * Keep in mind... Same working dir, Same HOME, etc... But, IT WORKS!
 *
 * Does anyone know of "other" processes that might "send" us a XChangeProperty
 */

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/time.h>


#include "arena.h"
#ifdef ARENA_DEBUG
#  include "debug.h"
#endif

#include "WWWLib.h"

#include "bridge.h"
#include "spawn.h"
#include "status.h"
#include "bookmark.h"
#include "util.h"

/* ParseGoto
 * Yes, all it gets is GOTO commands from ParseCommandLine() below!
 * If it fails, at least announce it!
 */
char *ParseGoto(char *command_line, char *limit)
{
 char *curr;
 char *url = NULL;
 int  new;
 int  parse_ok;

#ifdef ARENA_DEBUG
 char Iam[] = "ParseGoto";
#endif

 curr = command_line;
 parse_ok = False;
 new = False;

 /* Pick out the pieces of the command line.
  * Looking for "NEW " and "URL=..."
  * Make sure that the string found for the URL is SAFE!
  */
 while(curr <= limit && !parse_ok)
   {
    if (*curr == 0)
      {
       parse_ok = True;
      }
    else if(strncmp(curr, "URL=", 4) == 0)
      {
       curr += 4;
       url =  curr;
       curr += Arena_StrLen(curr);
       if (BMCheckForSecurity(url))        /* We get an error mess, but not  */
	 url = NULL;                       /* very descriptive               */
      }
    else if (strncmp(curr, "NEW ", 4) == 0)
      {
       new = True;
       curr += 4;
      }
    else
      {
       break;
      }
   }
 
 /* Well, we finished parsing the GOTO command... did it give us anything
  * to do?  If not, at least announce the failure!
  */
 if(parse_ok && url)
   {
    if(new)
      {
       char *cmd;
       int status;
       cmd = (char *)Arena_MAlloc(Arena_StrLen(url)+20, True);
       sprintf(cmd, "arena --url %s", url);
       status = SpawnSystemCommand(cmd, NULL, WAIT_ASYNC, KILL_NEVER, NULL);
       free(cmd);
       if (status > 0)
	 {
	  Warn(_("XChangeProperty Unable to Spawn... %s"), command_line);
#ifdef ARENA_DEBUG
	  Arena_TracePrint(Iam, " Unable to Spawn %s\n", command_line);
#endif
	 }
      }
    else
      {
       OpenDoc(url);
      }
   }
 else
   {
    Warn(_("XChangeProperty Invalid GOTO structure... %s"), command_line);
#ifdef ARENA_DEBUG
    Arena_TracePrint(Iam, " Invalid GOTO structure %s\n", command_line);
#endif
   }
 /* Signal end of command line.... Therefore DONE! */
 return limit;
}

/* ParseCommandLine
 * Called from GuiEvents() to respond to a window property change event.
 * The property responded to is Atom ARENA_COMMAND.
 */
void ParseCommandLine(char *command_line, int command_size)
{
 char *p, *end, *curr;

#ifdef ARENA_DEBUG
 char Iam[] = "ParseCommandLine";
#endif

 if (command_line == NULL) return;
 end = command_line + command_size;
 curr = command_line;

 /* At present, only seems to allow GOTO command...
  * There is absolutely NO error structure here, so I'll settle
  * for announcing our failure.
  */
 while(curr < end)
   {
    if(strncmp(curr, "GOTO ", 5) == 0)
      {
       p = ParseGoto(curr + 5, end);
       curr = p;
      }
    else
      {
       Warn(_("XChangeProperty Invalid GOTO structure... %s"), command_line);
#ifdef ARENA_DEBUG
       Arena_TracePrint(Iam, " Invalid GOTO structure %s\n", command_line);
#endif
       curr += Arena_StrLen(curr)+1;
      }
   }
}

/* Send ARENA_COMMAND
 * Simple cover routine for the XChangeProperty() for ARENA_COMMAND
 * Originally created to "test" ParseCommandLine()...
 */
void ArenaSendXPropertyCommand(char *cmd)
 {
  extern Atom ARENA_COMMAND;
  extern Window win;
  extern Display* display;

  if (cmd != NULL)
    XChangeProperty(display, win, ARENA_COMMAND, XA_STRING, 8, PropModeReplace,
		    cmd, Arena_StrLen(cmd));
  return;
 }
