#ifndef ___ARENA_IMAGE_H___
#  define ___ARENA_IMAGE_H___


#include "defs.h"
#include "types.h"
#include "image_types.h"


/*
 * Global variables. :(
 */
extern XColor papercols[256];

extern Image *note_image, *caution_image, *warning_image;  /* standard icons */
extern Image* arena_bg_image;
extern unsigned char *tileData;
extern unsigned int tileWidth, tileHeight;


/*
 * Functions.
 */

Image* NewImage(void);
Bool DelImage(Image* theImage);

int InitImaging(int ColourStyle);

void ReportStandardColourMaps(Atom which_map);
void ReportVisuals(void);

Bool MakePaper(void);
void MakeIcons(unsigned int depth);

unsigned char *Transparent(unsigned char *p, int i, int j);

ImageData* NewImageData(size_t image_length, size_t image_mask_length);
void FreeImageData(ImageData* theImageData);

ImageXyoke* NewImageXyoke(void);
void FreeImageXyoke(ImageXyoke* imageXcouple);

ImageAssembly* NewImageAssembly(ArenaImageingCapability imageing,
				unsigned int width, unsigned int height,
				unsigned int depth,
				unsigned int mask_depth);
Bool NextPixel_to_ImageAssembly(ImageAssembly* image_assembly,
				unsigned char* pixel_p,
				unsigned int mask_pixel);
ImageData* FinishImageAssembly(ImageAssembly* image_assembly);

Image* GetImage(char *href, int hreflen, Bool reload);

Bool InitProgressiveImage(Doc* doc);
ProcessImage ProcessProgressiveImage(Doc* doc,
				     unsigned long chunk_pos,
				     unsigned long chunk_length);

ProcessImage ProcessLoadedImage(Doc* doc);
Bool XprocessLoadedImage(ImageXyoke* imageXcouple, Image* image);

ImageXyoke* processImage_data2image(ImageData* imageData,
				    unsigned int width,
				    unsigned int height,
				    unsigned int depth);

void FreeImages(int cloned);


#endif /* ifndef ___ARENA_IMAGE_H___ */
