/********************************************************************\
 * main.h -- main for xacc (X-Accountant)                           *
 * Copyright (C) 1997 Robin D. Clark                                *
 *                                                                  *
 * This program is free software; you can redistribute it and/or    *
 * modify it under the terms of the GNU General Public License as   *
 * published by the Free Software Foundation; either version 2 of   *
 * the License, or (at your option) any later version.              *
 *                                                                  *
 * This program is distributed in the hope that it will be useful,  *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of   *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the    *
 * GNU General Public License for more details.                     *
 *                                                                  *
 * You should have received a copy of the GNU General Public License*
 * along with this program; if not, write to the Free Software      *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.        *
 *                                                                  *
 *   Author: Rob Clark                                              *
 * Internet: rclark@cs.hmc.edu                                      *
 *  Address: 609 8th Street                                         *
 *           Huntington Beach, CA 92648-4632                        *
\********************************************************************/

#ifndef __MAIN_H__
#define __MAIN_H__

#define BUFSIZE   1024

#include <Xm/Xm.h>

#include "config.h"

#include "date.h"
#include "Transaction.h"

/** DIALOG BOX MESSAGES: ********************************************/
#define ACC_NEW_MSG       "Do you want to create a new account?\n"\
                          "If not, then please select an account\n"\
                          "to open in the main window.\n"
#define ACC_EDIT_MSG      "To edit an account, you must first \n"\
                          "choose an account to delete.\n"
#define ACC_DEL_MSG       "To delete an account, you must first \n"\
                          "choose an account to delete.\n"
#define ACC_DEL_SURE_MSG  "Are you sure you want to delete the %s account?"
#define ACC_NO_NAME_MSG   "The account must be given a name! \n"
#define FILE_TOO_OLD_MSG  "This file is from an older version of "\
                          "X-Accountant.  Do you want to continue?"
#define FILE_TOO_NEW_MSG  "This file appears to be from a newer version "\
                          "of X-Accountant.  Do you want to continue?"
#define FILE_BAD_READ_MSG "There was an error reading the file. "\
                          "Do you want to continue?"
#define FILE_NOT_FOUND_MSG "The file %s could not be found."
#define FILE_EMPTY_MSG    "The file %s is empty."
#define FMB_SAVE_MSG      "Changes have been made since last "\
                          "Save.  Save data to file?"
#define RECN_TRANS_WARN   "Warning!  This is a reconciled transaction. "\
                          "Do you want do continue?"
#define TRANS_DEL_MSG     "Are you sure you want \nto delete the transaction \n %s ?"

#define XFER_NSF_MSG      "There must be at least two accounts\n"\
                          "created before you can transfer funds."
#define XFER_DIFF_MSG     "The \"From\" and \"To\" accounts\n must be different!"
#define XFER_SAME_MSG     "You can't transfer from and to the same account!"
#define XFER_NO_ACC_MSG   "You must specify an account to transfer from, \n"\
                          "or to, or both, for this transaction; otherise \n"\
                          "it will not be recorded."


/** MISC INTERNATIONALIZATION STRINGS: ******************************/
/* hack alert -- Linux seems not to support localeconv()
 * for getting currency symbols & monetary units.  Besides,
 * I couldn't find a routine that would print currency amounts anyway... 
 */

/* hack alert -- probably, most of these should be handled as
 * X resources, instead of compile-time things */

#define CURRENCY_SYMBOL  "$"

/* phrases */
#define ACC_NAME_STR     "Account Name"
#define ACC_TYPE_STR     "Account Type"
#define ADJ_BALN_STR     "Adjust Balance"
#define EDIT_ACCT_STR    "Edit Account"
#define END_BALN_STR     "Ending Balance"
#define LOST_ACC_STR     "Lost Accounts"
#define NEW_BALN_STR     "New Balance"
#define OPEN_BALN_STR    "Opening Balance"
#define PICK_ONE_STR     "Pick One"
#define PARENT_ACC_STR   "Parent Account"
#define PREV_BALN_STR    "Previous Balance"
#define PURCH_PRIC_STR   "Purch Price"
#define SALE_PRIC_STR    "Sale Price"
#define SETUP_ACCT_STR   "Set Up Account"
#define TOT_SHRS_STR     "Tot Shrs"
#define XFER_MONEY_STR   "Transfer Money"
#define XFRM_STR         "Transfer From"
#define XFTO_STR         "Transfer To"

/* single words */
#define ACTION_STR       "Action"
#define AMT_STR          "Amount"
#define APPR_STR         "Appreciation"
#define ASSETS_STR       "Assets"
#define BACK_STR         "Back"
#define BALN_STR         "Balance"
#define BOUGHT_STR       "Bought"
#define BUY_STR          "Buy"
#define CANCEL_STR       "Cancel"
#define CHARGE_STR       "Charge"
#define CLEARED_STR      "Cleared"
#define CLOSE_STR        "Close"
#define CREATE_STR       "Create"
#define CREDIT_STR       "Credit"
#define CREDITS_STR      "Credits"
#define DATE_STR         "Date"
#define DEBIT_STR        "Debit"
#define DEBITS_STR       "Debits"
#define DECREASE_STR     "Decrease"
#define DEFICIT_STR      "Deficit"
#define DELETE_STR       "Delete"
#define DEPOSIT_STR      "Deposit"
#define DEPR_STR         "Depreciation"
#define DESC_STR         "Description"
#define DIFF_STR         "Difference"
#define DIST_STR         "Dist"    /* Distribution */
#define DIV_STR          "Div"     /* Dividend */
#define EDIT_STR         "Edit"
#define EXPENSE_STR      "Expense"
#define FORWARD_STR      "Forward"
#define HELP_STR         "Help"
#define INCOME_STR       "Income"
#define INCREASE_STR     "Increase"
#define INT_STR          "Int"     /* Interest */
#define LTCG_STR         "LTCG"    /* Long Term Capital Gains */
#define MEMO_STR         "Memo"
#define NEW_STR          "New"
#define NO_STR           "No"
#define NONE_STR         "(none)"
#define NOTES_STR        "Notes"
#define NUM_STR          "Num"
#define OK_STR           "Ok"
#define OPEN_STR         "Open"
#define PAYMENT_STR      "Payment"
#define PRICE_STR        "Price"
#define PROFITS_STR      "Profits"
#define REBATE_STR       "Rebate"
#define RECEIVE_STR      "Receive"
#define RECONCILE_STR    "Reconcile"
#define RECORD_STR       "Record"
#define REPORT_STR       "Report"
#define SAVE_STR         "Save"
#define SELL_STR         "Sell"
#define SOLD_STR         "Sold"
#define SPEND_STR        "Spend"
#define SPLIT_STR        "Split"
#define STCG_STR         "STCG"   /* Short Term Captial Gains */
#define SURPLUS_STR      "Surplus"
#define TOTAL_STR        "Total"
#define TRANSFER_STR     "Transfer"
#define VALUE_STR        "Value"
#define WARN_STR         "WARNING"
#define WITHDRAW_STR     "Withdraw"
#define YES_STR          "Yes"

/* with colons at end */
#define ACC_NAME_C_STR   ACC_NAME_STR   ":"
#define ASSETS_C_STR     ASSETS_STR     ":"
#define BALN_C_STR       BALN_STR       ":"
#define CLEARED_C_STR    CLEARED_STR    ":"
#define CREDITS_C_STR    CREDITS_STR    ":"
#define DEBITS_C_STR     DEBITS_STR     ":"
#define DESC_C_STR       DESC_STR       ":"
#define DIFF_C_STR       DIFF_STR       ":"
#define END_BALN_C_STR   END_BALN_STR   ":"
#define PARENT_ACC_C_STR PARENT_ACC_STR ":"
#define PREV_BALN_C_STR  PREV_BALN_STR  ":"
#define PROFITS_C_STR    PROFITS_STR    ":"
#define TOTAL_C_STR      TOTAL_STR      ":"

/** HELP STUFF: *****************************************************/
#define HELP_VAR     "XACC_HELP"
#define HELP_ROOT    "./Docs/"
#define HH_ABOUT     "xacc-about.html"
#define HH_ACC       "xacc-accwin.html"
#define HH_REGWIN    "xacc-regwin.html"
#define HH_RECNWIN   "xacc-recnwin.html"
#define HH_ADJBWIN   "xacc-adjbwin.html"
#define HH_MAIN      "xacc-main.html"
#define HH_GPL       "xacc-gpl.html"

/** STRUCTS *********************************************************/

/** PROTOTYPES ******************************************************/

/** GLOBALS *********************************************************/
extern String accRes[];
extern char  *helpPath;


#endif
