/* library.c */

#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <unistd.h>
#include <errno.h>
#include "library.h"


extern char *fgetsz (char *s, int size, FILE *stream)
{
	int c, wait;
	char *p;

	if (size <= 0) {
		/* Oops... shouldn't happen */
		abort ();
	}

	p = s;

	while (1) {
		if (p - s >= size - 1) {
			*p = '\0';
			return s;
		}
		wait = 0;
		while (1) {
		    c = getc (stream);		 
		    if (c == EOF) {		 /* error */
			*p = '\0';
			if (p == s) return NULL; /* couldn't get anything */
			if (ferror(stream)) {	 /* error on stream */
			    if (errno == EINTR) { /* if error is signal interrupt */
				wait++;	
				if (wait < 30) { /* retry reading 30 times */
				    sleep(1);
				    continue;
				}
			    }
			    else
				return NULL;	 /* other errors are errors */
			}
			return s;		 /* end of file */
		    }
		    else
			break;
		}
		
		if (c == '\0') {
		    *p = '\0';
		    return s;
		}
		*p = c;
		p++;
	}
}

extern int fputsz (const char *s, FILE *stream)
{
	if (fputs (s, stream) == EOF)
		return EOF;

	if (putc ('\0', stream) == EOF)
		return EOF;

	return 0;
}


extern void convert_to_printable (char *s)
{
	for ( ; *s; s++)
		if (! isprint (*s))
			*s = '?';
}
