%
% common Swedish names for notes. "ess" means flat, "iss" means sharp
%
% by Mats Bengtsson.


%
% Please note that, while these names are used to enter *notes*, they
% actually are *melodic*s, i.e. they represent a pitch solely. Notes
% have a rhythmic part too. This is the reason that we don't write 'note { .. }'
%
\notenames {
	cessess	= \melodic_request { -1 0 -2 }
	cess 	= \melodic_request { -1 0 -1 }
	c 	= \melodic_request { -1 0 0 }
	ciss 	= \melodic_request { -1 0 1 }
	cississ	= \melodic_request { -1 0 2 }
	dessess	= \melodic_request { -1 1 -2 }
	dess 	= \melodic_request { -1 1 -1 }
	d 	= \melodic_request { -1 1 0 }
	diss 	= \melodic_request { -1 1 1 }
	dississ	= \melodic_request { -1 1 2 }
	essess 	= \melodic_request { -1 2 -2 }
	ess 	= \melodic_request { -1 2 -1 }
	e 	= \melodic_request { -1 2 0 }
	eiss 	= \melodic_request { -1 2 1 }
	eississ	= \melodic_request { -1 2 2 }
	fessess	= \melodic_request { -1 3 -2 }
	fess 	= \melodic_request { -1 3 -1 }
	f 	= \melodic_request { -1 3 0 }
	fiss 	= \melodic_request { -1 3 1 }
	fississ	= \melodic_request { -1 3 2 }
	gessess	= \melodic_request { -1 4 -2 }
	gess 	= \melodic_request { -1 4 -1 }
	g 	= \melodic_request { -1 4 0 }
	giss 	= \melodic_request { -1 4 1 }
	gississ	= \melodic_request { -1 4 2 }
	assess 	= \melodic_request { -1 5 -2 }
	ass 	= \melodic_request { -1 5 -1 }
	a 	= \melodic_request { -1 5 0 }
	aiss 	= \melodic_request { -1 5 1 }
	aississ	= \melodic_request { -1 5 2 }
	hessess	= \melodic_request { -1 6 -2 }
	b 	= \melodic_request { -1 6 -1 }
	h 	= \melodic_request { -1 6 0 }
	hiss 	= \melodic_request { -1 6 1 }
	hississ	= \melodic_request { -1 6 2 }


	%
	% upper case: 1 octave lower.
	%


	Cessess	= \melodic_request { -2 0 -2 }
	Cess 	= \melodic_request { -2 0 -1 }
	C 	= \melodic_request { -2 0 0 }
	Ciss 	= \melodic_request { -2 0 1 }
	Cississ	= \melodic_request { -2 0 2 }
	Dessess	= \melodic_request { -2 1 -2 }
	Dess 	= \melodic_request { -2 1 -1 }
	D 	= \melodic_request { -2 1 0 }
	Diss 	= \melodic_request { -2 1 1 }
	Dississ	= \melodic_request { -2 1 2 }
	Essess 	= \melodic_request { -2 2 -2 }
	Ess 	= \melodic_request { -2 2 -1 }
	E 	= \melodic_request { -2 2 0 }
	Eiss 	= \melodic_request { -2 2 1 }
	Eississ	= \melodic_request { -2 2 2 }
	Fessess	= \melodic_request { -2 3 -2 }
	Fess 	= \melodic_request { -2 3 -1 }
	F 	= \melodic_request { -2 3 0 }
	Fiss 	= \melodic_request { -2 3 1 }
	Fississ	= \melodic_request { -2 3 2 }
	Gessess	= \melodic_request { -2 4 -2 }
	Gess 	= \melodic_request { -2 4 -1 }
	G 	= \melodic_request { -2 4 0 }
	Giss 	= \melodic_request { -2 4 1 }
	Gississ	= \melodic_request { -2 4 2 }
	Assess 	= \melodic_request { -2 5 -2 }
	Ass 	= \melodic_request { -2 5 -1 }
	A 	= \melodic_request { -2 5 0 }
	Aiss 	= \melodic_request { -2 5 1 }
	Aississ	= \melodic_request { -2 5 2 }
	Hessess	= \melodic_request { -2 6 -2 }
	B 	= \melodic_request { -2 6 -1 }
	H 	= \melodic_request { -2 6 0 }
	Hiss 	= \melodic_request { -2 6 1 }
	Hississ	= \melodic_request { -2 6 2 }


}
