// menus.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


#ifdef __GNUG__
#pragma implementation
#endif

#include "localdefs.h"
#include <InterViews/action.h>
#include <InterViews/box.h>
#include <InterViews/glue.h>
#include "menus.h"
#include "vmessage.h"

PulldownCommandMenu::PulldownCommandMenu(const char* str, boolean enabled)
		: PulldownMenu(cmdLabel = new VMessage(str, Left, 2, enabled)) {
	SetClassName("PulldownCommandMenu");
	PulldownMenu::Enable(enabled);
}

void
PulldownCommandMenu::Enable(boolean isEnabled) {
	cmdLabel->enable(isEnabled);
	PulldownMenu::Enable(isEnabled);
}

//********

PullrightCommandMenu::PullrightCommandMenu(const char* str, boolean enabled)
		: PullrightMenu((Interactor *) nil) {
	SetClassName("PullrightCommandMenu");
	Insert( new HBox(
		cmdLabel = new VMessage(str, Left, 2, /* hfil, */ enabled),
		new Message("   ", Center, 2, hfil),
		arrowLabel = new VMessage("->", Right, 2, /* hfil, */ enabled)
		)
	);
	PullrightMenu::Enable(enabled);
}

void
PullrightCommandMenu::Enable(boolean isEnabled) {
	cmdLabel->enable(isEnabled);
	arrowLabel->enable(isEnabled);
	PullrightMenu::Enable(isEnabled);
}

//********

Command::Command(const char* str, const char* keystr, Action* action,
		boolean enabled) : MenuItem((Interactor *) nil), myAction(action) {
	SetClassName("Command");
	Insert( new HBox(
		cmdMessage = new VMessage(str, Left, 2, /* hfil, */ enabled),
		new Message("   ", Center, 2, hfil),
		keyMessage = new VMessage(keystr, Right, 2, /* hfil, */ enabled)
		)
	);
	myAction->ref();
	MenuItem::Enable(enabled);
}

Command::~Command() {
	Resource::unref(myAction);
}

void
Command::Do() {
	myAction->execute();
}

void
Command::Enable(boolean isEnabled) {
	cmdMessage->enable(isEnabled);
	keyMessage->enable(isEnabled);
	Control::Enable(isEnabled);
}
