// formantrequester.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


#ifdef __GNUG__
#pragma implementation
#endif

#include "application.h"
#include "formantrequester.h"
#include "datamodifier.h"
#include "data.h"
#include "lpcfilter.h"

FormantRequester::FormantRequester(const char* title, LPC_Filter* l,
                                   const double srate, double& gain,
                                   double& warp, ChoiceValue& interpMode)
		: ValueRequester<double>(title, "Gain Factor:", gain),
		  client(l), sampRate(srate), theWarp(warp), interp(interpMode) {}
		  
void
FormantRequester::configureRequest(Request* request) {
	ValueRequester<double>::configureRequest(request);
	request->appendValue("Warp Factor:", &theWarp, Range(-1.0, 1.0), true);
	request->appendChoice("Interpolation Mode:",
			     "|Interpolated|Recalculated|", &interp);
}

boolean
FormantRequester::confirmValues() {
	int status = true;
	float lpcrate = client->lpcSamplingRate();
	char msg[120];
	if(sampRate != lpcrate) {
		sprintf(msg,
			"Warning: LPC data samprate (%d) != selection samprate (%d).",
				lpcrate, sampRate);
		status = Application::confirm(msg, "The formant peaks will be skewed.",
			"Continue anyway?", Cancel);
	}
	return status;
}
