// configurable.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

#ifndef CONFIGURABLE_H
#ifdef __GNUG__
#pragma interface
#endif
#define CONFIGURABLE_H

#include "localdefs.h"

class Controller;
class Requester;

class Configurable {
public:
	Configurable() : theStatus(Succeed), configured(false) {}
	virtual Status configure(Controller *);
	Status reconfigure(Controller *);
	boolean ready();
protected:
	virtual Requester* createRequester() { return nil; }
	virtual boolean isConfigured() { return configured; }
	virtual void initialize() { configured = true; }
	virtual void okIf(boolean is) { theStatus = (is) ? Succeed : Fail; }
	boolean ok() { return theStatus == Succeed; }
private:
	Status theStatus;
	boolean configured;
};

inline boolean
Configurable::ready() { return ok() && isConfigured(); }

#endif
