/*================================================================
 * global flags
 *================================================================*/

#include <stdio.h>
#include "sfopts.h"
#include "config.h"

/* master volume */
#ifndef DEFAULT_VOLUME
#define DEFAULT_VOLUME	70	/* 70% */
#endif

/* default attenuation sense */
#ifndef DEF_ATTEN_SENSE
#define DEF_ATTEN_SENSE	  10
#endif

sf_options awe_option = {
	0,	/* add blank */
	-1,	/* bank */
	0, 0,	/* chorus, reverb */
	DEFAULT_VOLUME,		/* volume */
	DEF_ATTEN_SENSE,	/* atten sense */
	32,			/* default atten */
	50.0,			/* decay sense */
	NULL,			/* search path */
};

/*----------------------------------------------------------------
 * estimate default attenuation
 *----------------------------------------------------------------*/

void awe_init_option(void)
{
	awe_option.default_atten = awe_calc_def_atten(awe_option.atten_sense);
}

int awe_calc_def_atten(double sense)
{
	if (sense <= 0) {
		fprintf(stderr, "calc_def_atten: illegal sense %g\n", sense);
		return 0;
	}
	return (int)(35.55 - 35.55/sense);
}


