/*================================================================
 * preload samples in a midi file invoking sfxload program
 *================================================================*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/wait.h>
#include "util.h"
#include "midievent.h"
#include "controls.h"
#include "channel.h"

#define LOADER		"sfxload"
#define APPEND_OPT	"-b0"
#define SUB_OPT		"-b1"
#define CLEAR_OPT	"-x"

typedef struct _SFPatchRec {
	int preset, bank, keynote;
	struct _SFPatchRec *next;
} SFPatchRec;

static int npreloads;
static SFPatchRec *pload;

static void exec_loader(MidiInfo *mp, char **argv);


void preload_sample(MidiInfo *mp, char *fontfile)
{
	MidiEvent *ev;
	SFPatchRec *p, *next;
	char **argv;
	int i, filep;

	npreloads = 0;
	pload = NULL;

	channel_init(mp);

	ev = mp->list;
	for (i = 0; i < mp->nlists; i++, ev++) {
		do_midi_event(ev, mp, EV_PRELOAD);
	}

	if (npreloads <= 0)
		return;

	argv = (char**)safe_malloc(sizeof(char*) * (npreloads + 5));
	i = 0;
	argv[i++] = LOADER;
	argv[i++] = APPEND_OPT;
	if (! mp->sample_cleared) {
		argv[i++] = CLEAR_OPT;
		mp->sample_cleared = TRUE;
	}
	filep = i;
	for (p = pload; p; p = p->next) {
		char tmp[32];
		if (p->keynote != -1)
			sprintf(tmp, "-L%d/%d/%d", p->preset, p->bank,
				p->keynote);
		else if (p->bank != 0)
			sprintf(tmp, "-L%d/%d", p->preset, p->bank);
		else
			sprintf(tmp, "-L%d", p->preset);
		argv[i++] = safe_strdup(tmp);
	}
	argv[i++] = fontfile;
	argv[i++] = NULL;

	exec_loader(mp, argv);

	for (i = filep; i < npreloads + filep; i++)
		safe_free(argv[i]);
	for (p = pload; p; p = next) {
		next = p->next;
		free(p);
	}
}

static void exec_loader(MidiInfo *mp, char **argv)
{
	int pid, rc;

	midi_close(mp);
	if ((pid = fork()) == 0) {
		execvp(LOADER, argv);
		exit(1);
	}
	wait(&rc);
	if (rc && ctl) {
		ctl->cmsg(CMSG_INFO, -1, "preload: couldn't load all fonts");
	}
}

void add_preload(int chn, int preset, int bank, int keynote)
{
	SFPatchRec *rec;

	for (rec = pload; rec; rec = rec->next) {
		if (rec->preset == preset && rec->bank == bank &&
		    rec->keynote == keynote)
			return;
	}

	rec = (SFPatchRec*)safe_malloc(sizeof(SFPatchRec));
	rec->preset = preset;
	rec->bank = bank;
	rec->keynote = keynote;
	rec->next = pload;
	pload = rec;
	npreloads++;
}

/*----------------------------------------------------------------*/

void load_sub_sf(MidiInfo *mp, char *args)
{
	int i;
	char *argv[100];

	i = 0;
	argv[i++] = LOADER;
	argv[i++] = SUB_OPT;
	if (! mp->sample_cleared) {
		argv[i++] = CLEAR_OPT;
		mp->sample_cleared = TRUE;
	}
	argv[i++] = args;
	argv[i++] = NULL;
	exec_loader(mp, argv);
}

