/*
 * linux_vars.h --
 *
 * This file contains the definitions for Linux specific SNMP variables.
 *
 * Copyright (c) 1996-1998
 *
 * Juergen Schoenwaelder	University of Twente, The Netherlands
 *				TU Braunschweig, Germany
 * 
 * Permission to use, copy, modify, and distribute this software and its 
 * documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in 
 * supporting documentation, and that the name of CMU not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  
 * 
 * THE AUTHORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * THE AUTHORS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * 
 */

#ifndef LINUX_VARS_H
#define LINUX_VARS_H

/*
 * Definitions of tags that are used internally to read/write the
 * selected object type. These tags should be unique. We allocate
 * value is groups (high byte) so that we can make changes easily.
 */

#define LINUXCPU		0x01
#define LINUXBOGO		0x02
#define LINUXLOAD1		0x03
#define LINUXLOAD5		0x04
#define LINUXLOAD15		0x05

/*
 * The functions exported by the linux_vars.c module.
 */

extern void linux_init();
extern u_char* var_linux();

#endif
