/*
 * tnm.h --
 *
 *	Common definitions for the Tnm Tcl extension.
 *
 * Copyright (c) 1993-1996 Technical University of Braunschweig.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */

#ifndef _TNM
#define _TNM

#if defined(_WIN32) && !defined(__WIN32__)
#   define __WIN32__
#endif

#ifdef __WIN32__
#   undef USE_PROTOTYPE
#   undef HAS_STDARG
#   define USE_PROTOTYPE
#   define HAS_STDARG
#endif

/*
 *----------------------------------------------------------------
 * Here start the common definitions for the scotty extension:
 *----------------------------------------------------------------
 */

#define TNM_VERSION "2.1.9"

#ifndef TNM_URL
#define TNM_URL "http://wwwsnmp.cs.utwente.nl/~schoenw/scotty"
#endif

#include <tcl.h>

/*
 *----------------------------------------------------------------
 * The ckstrdup macro is useful for two reasons: It emulates
 * strdup which is missing on some systems and it allows to track
 * memory allocation problems using Tcl's memory debugger.
 *----------------------------------------------------------------
 */

#define ckstrdup(s)	strcpy(ckalloc(strlen(s)+1), s)

/*
 *----------------------------------------------------------------
 * The SNMP package and the optional GDMO and CMIP extension have
 * their own initialization procedure. We define them here to 
 * bypass any problems with finding their include files.
 *----------------------------------------------------------------
 */

EXTERN int 
Tnm_SnmpInit		_ANSI_ARGS_((Tcl_Interp *interp));

#ifdef HAVE_OSIMIS
EXTERN int 
Tnm_CmipInit		_ANSI_ARGS_((Tcl_Interp *interp));
#endif

#ifdef HAVE_GDMO
EXTERN int
Tnm_GdmoInit		_ANSI_ARGS_((Tcl_Interp *interp));
#endif

#ifdef HAVE_MSQL
EXTERN int
Msqltcl_Init		_ANSI_ARGS_((Tcl_Interp *interp));
#endif

/*
 *----------------------------------------------------------------
 * Tcl command procedures provided by the Tnm extension:
 *----------------------------------------------------------------
 */

EXTERN int
Tnm_EventCmd	_ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp, 
			     int argc, char **argv));
EXTERN int
Tnm_JobCmd	_ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp, 
			     int argc, char **argv));
EXTERN int
Tnm_SyslogCmd	_ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp, 
			     int argc, char **argv));
EXTERN int
Tnm_UdpCmd	_ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp, 
			     int argc, char **argv));
EXTERN int
Tnm_RpcCmd	_ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp, 
			     int argc, char **argv));
EXTERN int
Tnm_HttpCmd	_ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp, 
			     int argc, char **argv));
EXTERN int
Tnm_DnsCmd	_ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp, 
			     int argc, char **argv));
EXTERN int
Tnm_NtpCmd	_ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp, 
			     int argc, char **argv));
EXTERN int
Tnm_SunrpcCmd	_ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp, 
			     int argc, char **argv));
EXTERN int
Tnm_IcmpCmd	_ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp,
			     int argc, char **argv));
EXTERN int
Tnm_InedCmd	_ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp, 
			     int argc, char **argv));
EXTERN int
Tnm_NetdbCmd	_ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp, 
			     int argc, char **argv));

#endif /* _TNM */
