'\"
'\" Copyright (c) 1994-1996 Technical University of Braunschweig.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
.so man.macros
.TH rpc n "" Tnm "Tnm Tcl Extension"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
rpc \- A simple RPC protocol for Tcl applications.
.BE

.SH DESCRIPTION

.SH RPC COMMAND
.TP
.B rpc server \fIport\fR
Set up an RPC server listening an port \fIport\fR. This command
returns a rpc handle that be used to register Tcl procs that will 
be exported by a trivial RPC protocol on top of TCP. This RPC
mechanism allows us to write cooperating scripts without
worrying much about the communication protocol.

.TP
.B rpc client \fIhost\fR \fIport\fR
Connect to the RPC server running on \fIhost\fR with port \fIport\fR.
The returned client handle can be used to invoke an exported proc
on the server host.

.TP
.B rpc delete \fIhandle\fR
Delete a server or a client RPC handle. All connections associated
with the handle will be closed.

.TP
.B rpc register \fIrpchandle\fR \fIproc\fR
Export \fIproc\fR as an RPC callable proc using the server handle
\fIrpchandle\fR. Only registered procs can be called by RPC clients.

.TP
.B rpc unregister \fIrpchandle\fR \fIproc\fR
Remove \fIproc\fR from the list of exported procs on server handle
\fIrpchandle\fR.

.TP
.B rpc info \fR[\fIrpchandle\fR]
Calling rpc info without any arguments returns a list of all rpc handles
that have been created using the rpc server and rpc client command.
Info about a specific rpc file handle \fIrpchandle\fR is returned by
using the optional argument. The result is a list containing the tcp
file handle used for the communication and the list of registered
commands for a rpc handle and a list of all files that represent
connections to an rpc server. This list is empty if \fIrpchandle\fR
belongs to a rpc client.

.TP
.B rpc# [-async] \fIproc\fR \fIarg1\fR \fIarg2\fR ...
To invoke a remote procedure \fIproc\fR, use the same syntax as used
with a local invocation preceeded by a client \fIrpchandle\fR. The
result of the remote procedure call will be returned or an error if the
underlying communication channel signals errors. The -async options can be
used to invoke \fIproc\fR without waiting for it to complete. The
async option will never return a result.

.SH SEE ALSO
scotty(1), Tcl(n)

.SH AUTHORS
Juergen Schoenwaelder <schoenw@cs.utwente.nl>
.br
